/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.configuration.parameterstore.strategy;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.AwsRegionProviderChain;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.coveo.configuration.parameterstore.ParameterStorePropertySource;
import com.coveo.configuration.parameterstore.ParameterStorePropertySourceConfigurationProperties;
import com.coveo.configuration.parameterstore.ParameterStoreSource;
import com.coveo.configuration.parameterstore.strategy.ParameterStorePropertySourceConfigurationStrategy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class DefaultParameterStorePropertySourceConfigurationStrategy
implements ParameterStorePropertySourceConfigurationStrategy {
    private static final String PARAMETER_STORE_PROPERTY_SOURCE_NAME = "AWSParameterStorePropertySource";
    private AwsRegionProviderChain awsRegionProviderChain;

    public DefaultParameterStorePropertySourceConfigurationStrategy(AwsRegionProviderChain awsRegionProviderChain) {
        this.awsRegionProviderChain = awsRegionProviderChain;
    }

    @Override
    public void configureParameterStorePropertySources(ConfigurableEnvironment environment, AWSSimpleSystemsManagementClientBuilder ssmClientBuilder) {
        boolean haltBoot = (Boolean)environment.getProperty(ParameterStorePropertySourceConfigurationProperties.HALT_BOOT, Boolean.class, (Object)Boolean.FALSE);
        environment.getPropertySources().addFirst((PropertySource)this.buildParameterStorePropertySource(this.buildSSMClient(environment, ssmClientBuilder), haltBoot));
    }

    private ParameterStorePropertySource buildParameterStorePropertySource(AWSSimpleSystemsManagement ssmClient, boolean haltBoot) {
        return new ParameterStorePropertySource(PARAMETER_STORE_PROPERTY_SOURCE_NAME, new ParameterStoreSource(ssmClient, haltBoot));
    }

    private AWSSimpleSystemsManagement buildSSMClient(ConfigurableEnvironment environment, AWSSimpleSystemsManagementClientBuilder ssmClientBuilder) {
        if (this.hasCustomEndpoint(environment)) {
            return (AWSSimpleSystemsManagement)((AWSSimpleSystemsManagementClientBuilder)ssmClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getCustomEndpoint(environment), this.getSigningRegion(environment)))).build();
        }
        return (AWSSimpleSystemsManagement)ssmClientBuilder.build();
    }

    private boolean hasCustomEndpoint(ConfigurableEnvironment environment) {
        return environment.containsProperty(ParameterStorePropertySourceConfigurationProperties.SSM_CLIENT_CUSTOM_ENDPOINT);
    }

    private String getCustomEndpoint(ConfigurableEnvironment environment) {
        return environment.getProperty(ParameterStorePropertySourceConfigurationProperties.SSM_CLIENT_CUSTOM_ENDPOINT);
    }

    private String getSigningRegion(ConfigurableEnvironment environment) {
        return environment.getProperty(ParameterStorePropertySourceConfigurationProperties.SSM_CLIENT_SIGNING_REGION, this.awsRegionProviderChain.getRegion());
    }
}

