/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.configuration.parameterstore.strategy;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.coveo.configuration.parameterstore.ParameterStorePropertySource;
import com.coveo.configuration.parameterstore.ParameterStorePropertySourceConfigurationProperties;
import com.coveo.configuration.parameterstore.ParameterStoreSource;
import com.coveo.configuration.parameterstore.strategy.ParameterStorePropertySourceConfigurationStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

public class MultiRegionParameterStorePropertySourceConfigurationStrategy
implements ParameterStorePropertySourceConfigurationStrategy {
    private static final String PARAMETER_STORE_PROPERTY_SOURCE_NAME = "MultiRegionAWSParameterStorePropertySource_";

    @Override
    public void configureParameterStorePropertySources(ConfigurableEnvironment environment, AWSSimpleSystemsManagementClientBuilder ssmClientBuilder) {
        boolean haltBoot = (Boolean)environment.getProperty(ParameterStorePropertySourceConfigurationProperties.HALT_BOOT, Boolean.class, (Object)Boolean.FALSE);
        List<String> regions = this.getRegions(environment);
        Collections.reverse(regions);
        String lastRegion = regions.get(0);
        environment.getPropertySources().addFirst((PropertySource)this.buildParameterStorePropertySource(ssmClientBuilder, lastRegion, haltBoot));
        regions.stream().skip(1L).forEach(region -> environment.getPropertySources().addFirst((PropertySource)this.buildParameterStorePropertySource(ssmClientBuilder, (String)region, false)));
    }

    private ParameterStorePropertySource buildParameterStorePropertySource(AWSSimpleSystemsManagementClientBuilder ssmClientBuilder, String region, boolean haltBoot) {
        return new ParameterStorePropertySource(PARAMETER_STORE_PROPERTY_SOURCE_NAME + region, new ParameterStoreSource(this.buildSSMClient(ssmClientBuilder, region), haltBoot));
    }

    private AWSSimpleSystemsManagement buildSSMClient(AWSSimpleSystemsManagementClientBuilder ssmClientBuilder, String region) {
        return (AWSSimpleSystemsManagement)((AWSSimpleSystemsManagementClientBuilder)ssmClientBuilder.withRegion(region)).build();
    }

    private List<String> getRegions(ConfigurableEnvironment environment) {
        List regions = CollectionUtils.arrayToList((Object)environment.getProperty(ParameterStorePropertySourceConfigurationProperties.MULTI_REGION_SSM_CLIENT_REGIONS, String[].class));
        if (CollectionUtils.isEmpty((Collection)regions)) {
            throw new IllegalArgumentException(String.format("To enable multi region support, the property '%s' must not be empty.", ParameterStorePropertySourceConfigurationProperties.MULTI_REGION_SSM_CLIENT_REGIONS));
        }
        return regions;
    }
}

