/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CloudflareAccountCreateRequest;
import com.datadog.api.client.v2.model.CloudflareAccountResponse;
import com.datadog.api.client.v2.model.CloudflareAccountUpdateRequest;
import com.datadog.api.client.v2.model.CloudflareAccountsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class CloudflareIntegrationApi {
    private ApiClient apiClient;

    public CloudflareIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CloudflareIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CloudflareAccountResponse createCloudflareAccount(CloudflareAccountCreateRequest body) throws ApiException {
        return this.createCloudflareAccountWithHttpInfo(body).getData();
    }

    public CompletableFuture<CloudflareAccountResponse> createCloudflareAccountAsync(CloudflareAccountCreateRequest body) {
        return this.createCloudflareAccountWithHttpInfoAsync(body).thenApply(response -> (CloudflareAccountResponse)response.getData());
    }

    public ApiResponse<CloudflareAccountResponse> createCloudflareAccountWithHttpInfo(CloudflareAccountCreateRequest body) throws ApiException {
        CloudflareAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCloudflareAccount");
        }
        String localVarPath = "/api/v2/integrations/cloudflare/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.createCloudflareAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudflareAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudflareAccountResponse>> createCloudflareAccountWithHttpInfoAsync(CloudflareAccountCreateRequest body) {
        Invocation.Builder builder;
        CloudflareAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CloudflareAccountResponse>> result = new CompletableFuture<ApiResponse<CloudflareAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCloudflareAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/cloudflare/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.createCloudflareAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudflareAccountResponse>> result = new CompletableFuture<ApiResponse<CloudflareAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudflareAccountResponse>(){});
    }

    public void deleteCloudflareAccount(String accountId) throws ApiException {
        this.deleteCloudflareAccountWithHttpInfo(accountId);
    }

    public CompletableFuture<Void> deleteCloudflareAccountAsync(String accountId) {
        return this.deleteCloudflareAccountWithHttpInfoAsync(accountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCloudflareAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCloudflareAccount");
        }
        String localVarPath = "/api/v2/integrations/cloudflare/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.deleteCloudflareAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCloudflareAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCloudflareAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/cloudflare/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.deleteCloudflareAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CloudflareAccountResponse getCloudflareAccount(String accountId) throws ApiException {
        return this.getCloudflareAccountWithHttpInfo(accountId).getData();
    }

    public CompletableFuture<CloudflareAccountResponse> getCloudflareAccountAsync(String accountId) {
        return this.getCloudflareAccountWithHttpInfoAsync(accountId).thenApply(response -> (CloudflareAccountResponse)response.getData());
    }

    public ApiResponse<CloudflareAccountResponse> getCloudflareAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getCloudflareAccount");
        }
        String localVarPath = "/api/v2/integrations/cloudflare/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.getCloudflareAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudflareAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudflareAccountResponse>> getCloudflareAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<CloudflareAccountResponse>> result = new CompletableFuture<ApiResponse<CloudflareAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling getCloudflareAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/cloudflare/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.getCloudflareAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudflareAccountResponse>> result = new CompletableFuture<ApiResponse<CloudflareAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudflareAccountResponse>(){});
    }

    public CloudflareAccountsResponse listCloudflareAccounts() throws ApiException {
        return this.listCloudflareAccountsWithHttpInfo().getData();
    }

    public CompletableFuture<CloudflareAccountsResponse> listCloudflareAccountsAsync() {
        return this.listCloudflareAccountsWithHttpInfoAsync().thenApply(response -> (CloudflareAccountsResponse)response.getData());
    }

    public ApiResponse<CloudflareAccountsResponse> listCloudflareAccountsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/cloudflare/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.listCloudflareAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudflareAccountsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudflareAccountsResponse>> listCloudflareAccountsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/cloudflare/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.listCloudflareAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudflareAccountsResponse>> result = new CompletableFuture<ApiResponse<CloudflareAccountsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudflareAccountsResponse>(){});
    }

    public CloudflareAccountResponse updateCloudflareAccount(String accountId, CloudflareAccountUpdateRequest body) throws ApiException {
        return this.updateCloudflareAccountWithHttpInfo(accountId, body).getData();
    }

    public CompletableFuture<CloudflareAccountResponse> updateCloudflareAccountAsync(String accountId, CloudflareAccountUpdateRequest body) {
        return this.updateCloudflareAccountWithHttpInfoAsync(accountId, body).thenApply(response -> (CloudflareAccountResponse)response.getData());
    }

    public ApiResponse<CloudflareAccountResponse> updateCloudflareAccountWithHttpInfo(String accountId, CloudflareAccountUpdateRequest body) throws ApiException {
        CloudflareAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateCloudflareAccount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCloudflareAccount");
        }
        String localVarPath = "/api/v2/integrations/cloudflare/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.updateCloudflareAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudflareAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudflareAccountResponse>> updateCloudflareAccountWithHttpInfoAsync(String accountId, CloudflareAccountUpdateRequest body) {
        Invocation.Builder builder;
        CloudflareAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<CloudflareAccountResponse>> result = new CompletableFuture<ApiResponse<CloudflareAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateCloudflareAccount"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CloudflareAccountResponse>> result = new CompletableFuture<ApiResponse<CloudflareAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCloudflareAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/cloudflare/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudflareIntegrationApi.updateCloudflareAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudflareAccountResponse>> result = new CompletableFuture<ApiResponse<CloudflareAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudflareAccountResponse>(){});
    }
}

