/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.SensitiveDataScannerConfigRequest;
import com.datadog.api.client.v2.model.SensitiveDataScannerCreateGroupResponse;
import com.datadog.api.client.v2.model.SensitiveDataScannerCreateRuleResponse;
import com.datadog.api.client.v2.model.SensitiveDataScannerGetConfigResponse;
import com.datadog.api.client.v2.model.SensitiveDataScannerGroupCreateRequest;
import com.datadog.api.client.v2.model.SensitiveDataScannerGroupDeleteRequest;
import com.datadog.api.client.v2.model.SensitiveDataScannerGroupDeleteResponse;
import com.datadog.api.client.v2.model.SensitiveDataScannerGroupUpdateRequest;
import com.datadog.api.client.v2.model.SensitiveDataScannerGroupUpdateResponse;
import com.datadog.api.client.v2.model.SensitiveDataScannerReorderGroupsResponse;
import com.datadog.api.client.v2.model.SensitiveDataScannerRuleCreateRequest;
import com.datadog.api.client.v2.model.SensitiveDataScannerRuleDeleteRequest;
import com.datadog.api.client.v2.model.SensitiveDataScannerRuleDeleteResponse;
import com.datadog.api.client.v2.model.SensitiveDataScannerRuleUpdateRequest;
import com.datadog.api.client.v2.model.SensitiveDataScannerRuleUpdateResponse;
import com.datadog.api.client.v2.model.SensitiveDataScannerStandardPatternsResponseData;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class SensitiveDataScannerApi {
    private ApiClient apiClient;

    public SensitiveDataScannerApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SensitiveDataScannerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SensitiveDataScannerCreateGroupResponse createScanningGroup(SensitiveDataScannerGroupCreateRequest body) throws ApiException {
        return this.createScanningGroupWithHttpInfo(body).getData();
    }

    public CompletableFuture<SensitiveDataScannerCreateGroupResponse> createScanningGroupAsync(SensitiveDataScannerGroupCreateRequest body) {
        return this.createScanningGroupWithHttpInfoAsync(body).thenApply(response -> (SensitiveDataScannerCreateGroupResponse)response.getData());
    }

    public ApiResponse<SensitiveDataScannerCreateGroupResponse> createScanningGroupWithHttpInfo(SensitiveDataScannerGroupCreateRequest body) throws ApiException {
        SensitiveDataScannerGroupCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createScanningGroup");
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/groups";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.createScanningGroup", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerCreateGroupResponse>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerCreateGroupResponse>> createScanningGroupWithHttpInfoAsync(SensitiveDataScannerGroupCreateRequest body) {
        Invocation.Builder builder;
        SensitiveDataScannerGroupCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerCreateGroupResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerCreateGroupResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createScanningGroup"));
            return result;
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/groups";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.createScanningGroup", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerCreateGroupResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerCreateGroupResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerCreateGroupResponse>(){});
    }

    public SensitiveDataScannerCreateRuleResponse createScanningRule(SensitiveDataScannerRuleCreateRequest body) throws ApiException {
        return this.createScanningRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<SensitiveDataScannerCreateRuleResponse> createScanningRuleAsync(SensitiveDataScannerRuleCreateRequest body) {
        return this.createScanningRuleWithHttpInfoAsync(body).thenApply(response -> (SensitiveDataScannerCreateRuleResponse)response.getData());
    }

    public ApiResponse<SensitiveDataScannerCreateRuleResponse> createScanningRuleWithHttpInfo(SensitiveDataScannerRuleCreateRequest body) throws ApiException {
        SensitiveDataScannerRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createScanningRule");
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.createScanningRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerCreateRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerCreateRuleResponse>> createScanningRuleWithHttpInfoAsync(SensitiveDataScannerRuleCreateRequest body) {
        Invocation.Builder builder;
        SensitiveDataScannerRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerCreateRuleResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerCreateRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createScanningRule"));
            return result;
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.createScanningRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerCreateRuleResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerCreateRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerCreateRuleResponse>(){});
    }

    public SensitiveDataScannerGroupDeleteResponse deleteScanningGroup(String groupId, SensitiveDataScannerGroupDeleteRequest body) throws ApiException {
        return this.deleteScanningGroupWithHttpInfo(groupId, body).getData();
    }

    public CompletableFuture<SensitiveDataScannerGroupDeleteResponse> deleteScanningGroupAsync(String groupId, SensitiveDataScannerGroupDeleteRequest body) {
        return this.deleteScanningGroupWithHttpInfoAsync(groupId, body).thenApply(response -> (SensitiveDataScannerGroupDeleteResponse)response.getData());
    }

    public ApiResponse<SensitiveDataScannerGroupDeleteResponse> deleteScanningGroupWithHttpInfo(String groupId, SensitiveDataScannerGroupDeleteRequest body) throws ApiException {
        SensitiveDataScannerGroupDeleteRequest localVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteScanningGroup");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteScanningGroup");
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/groups/{group_id}".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.deleteScanningGroup", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerGroupDeleteResponse>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerGroupDeleteResponse>> deleteScanningGroupWithHttpInfoAsync(String groupId, SensitiveDataScannerGroupDeleteRequest body) {
        Invocation.Builder builder;
        SensitiveDataScannerGroupDeleteRequest localVarPostBody = body;
        if (groupId == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerGroupDeleteResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerGroupDeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'groupId' when calling deleteScanningGroup"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerGroupDeleteResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerGroupDeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteScanningGroup"));
            return result;
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/groups/{group_id}".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.deleteScanningGroup", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerGroupDeleteResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerGroupDeleteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerGroupDeleteResponse>(){});
    }

    public SensitiveDataScannerRuleDeleteResponse deleteScanningRule(String ruleId, SensitiveDataScannerRuleDeleteRequest body) throws ApiException {
        return this.deleteScanningRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<SensitiveDataScannerRuleDeleteResponse> deleteScanningRuleAsync(String ruleId, SensitiveDataScannerRuleDeleteRequest body) {
        return this.deleteScanningRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (SensitiveDataScannerRuleDeleteResponse)response.getData());
    }

    public ApiResponse<SensitiveDataScannerRuleDeleteResponse> deleteScanningRuleWithHttpInfo(String ruleId, SensitiveDataScannerRuleDeleteRequest body) throws ApiException {
        SensitiveDataScannerRuleDeleteRequest localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteScanningRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteScanningRule");
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.deleteScanningRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerRuleDeleteResponse>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerRuleDeleteResponse>> deleteScanningRuleWithHttpInfoAsync(String ruleId, SensitiveDataScannerRuleDeleteRequest body) {
        Invocation.Builder builder;
        SensitiveDataScannerRuleDeleteRequest localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerRuleDeleteResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerRuleDeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteScanningRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerRuleDeleteResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerRuleDeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteScanningRule"));
            return result;
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.deleteScanningRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerRuleDeleteResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerRuleDeleteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerRuleDeleteResponse>(){});
    }

    public SensitiveDataScannerGetConfigResponse listScanningGroups() throws ApiException {
        return this.listScanningGroupsWithHttpInfo().getData();
    }

    public CompletableFuture<SensitiveDataScannerGetConfigResponse> listScanningGroupsAsync() {
        return this.listScanningGroupsWithHttpInfoAsync().thenApply(response -> (SensitiveDataScannerGetConfigResponse)response.getData());
    }

    public ApiResponse<SensitiveDataScannerGetConfigResponse> listScanningGroupsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/sensitive-data-scanner/config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.listScanningGroups", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerGetConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerGetConfigResponse>> listScanningGroupsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/sensitive-data-scanner/config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.listScanningGroups", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerGetConfigResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerGetConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerGetConfigResponse>(){});
    }

    public SensitiveDataScannerStandardPatternsResponseData listStandardPatterns() throws ApiException {
        return this.listStandardPatternsWithHttpInfo().getData();
    }

    public CompletableFuture<SensitiveDataScannerStandardPatternsResponseData> listStandardPatternsAsync() {
        return this.listStandardPatternsWithHttpInfoAsync().thenApply(response -> (SensitiveDataScannerStandardPatternsResponseData)response.getData());
    }

    public ApiResponse<SensitiveDataScannerStandardPatternsResponseData> listStandardPatternsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/sensitive-data-scanner/config/standard-patterns";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.listStandardPatterns", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerStandardPatternsResponseData>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerStandardPatternsResponseData>> listStandardPatternsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/sensitive-data-scanner/config/standard-patterns";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.listStandardPatterns", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerStandardPatternsResponseData>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerStandardPatternsResponseData>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerStandardPatternsResponseData>(){});
    }

    public SensitiveDataScannerReorderGroupsResponse reorderScanningGroups(SensitiveDataScannerConfigRequest body) throws ApiException {
        return this.reorderScanningGroupsWithHttpInfo(body).getData();
    }

    public CompletableFuture<SensitiveDataScannerReorderGroupsResponse> reorderScanningGroupsAsync(SensitiveDataScannerConfigRequest body) {
        return this.reorderScanningGroupsWithHttpInfoAsync(body).thenApply(response -> (SensitiveDataScannerReorderGroupsResponse)response.getData());
    }

    public ApiResponse<SensitiveDataScannerReorderGroupsResponse> reorderScanningGroupsWithHttpInfo(SensitiveDataScannerConfigRequest body) throws ApiException {
        SensitiveDataScannerConfigRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling reorderScanningGroups");
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.reorderScanningGroups", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerReorderGroupsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerReorderGroupsResponse>> reorderScanningGroupsWithHttpInfoAsync(SensitiveDataScannerConfigRequest body) {
        Invocation.Builder builder;
        SensitiveDataScannerConfigRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerReorderGroupsResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerReorderGroupsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling reorderScanningGroups"));
            return result;
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.reorderScanningGroups", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerReorderGroupsResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerReorderGroupsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerReorderGroupsResponse>(){});
    }

    public SensitiveDataScannerGroupUpdateResponse updateScanningGroup(String groupId, SensitiveDataScannerGroupUpdateRequest body) throws ApiException {
        return this.updateScanningGroupWithHttpInfo(groupId, body).getData();
    }

    public CompletableFuture<SensitiveDataScannerGroupUpdateResponse> updateScanningGroupAsync(String groupId, SensitiveDataScannerGroupUpdateRequest body) {
        return this.updateScanningGroupWithHttpInfoAsync(groupId, body).thenApply(response -> (SensitiveDataScannerGroupUpdateResponse)response.getData());
    }

    public ApiResponse<SensitiveDataScannerGroupUpdateResponse> updateScanningGroupWithHttpInfo(String groupId, SensitiveDataScannerGroupUpdateRequest body) throws ApiException {
        SensitiveDataScannerGroupUpdateRequest localVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling updateScanningGroup");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateScanningGroup");
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/groups/{group_id}".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.updateScanningGroup", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerGroupUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerGroupUpdateResponse>> updateScanningGroupWithHttpInfoAsync(String groupId, SensitiveDataScannerGroupUpdateRequest body) {
        Invocation.Builder builder;
        SensitiveDataScannerGroupUpdateRequest localVarPostBody = body;
        if (groupId == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerGroupUpdateResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerGroupUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'groupId' when calling updateScanningGroup"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerGroupUpdateResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerGroupUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateScanningGroup"));
            return result;
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/groups/{group_id}".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.updateScanningGroup", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerGroupUpdateResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerGroupUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerGroupUpdateResponse>(){});
    }

    public SensitiveDataScannerRuleUpdateResponse updateScanningRule(String ruleId, SensitiveDataScannerRuleUpdateRequest body) throws ApiException {
        return this.updateScanningRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<SensitiveDataScannerRuleUpdateResponse> updateScanningRuleAsync(String ruleId, SensitiveDataScannerRuleUpdateRequest body) {
        return this.updateScanningRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (SensitiveDataScannerRuleUpdateResponse)response.getData());
    }

    public ApiResponse<SensitiveDataScannerRuleUpdateResponse> updateScanningRuleWithHttpInfo(String ruleId, SensitiveDataScannerRuleUpdateRequest body) throws ApiException {
        SensitiveDataScannerRuleUpdateRequest localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateScanningRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateScanningRule");
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.updateScanningRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerRuleUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SensitiveDataScannerRuleUpdateResponse>> updateScanningRuleWithHttpInfoAsync(String ruleId, SensitiveDataScannerRuleUpdateRequest body) {
        Invocation.Builder builder;
        SensitiveDataScannerRuleUpdateRequest localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerRuleUpdateResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerRuleUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling updateScanningRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SensitiveDataScannerRuleUpdateResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerRuleUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateScanningRule"));
            return result;
        }
        String localVarPath = "/api/v2/sensitive-data-scanner/config/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SensitiveDataScannerApi.updateScanningRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SensitiveDataScannerRuleUpdateResponse>> result = new CompletableFuture<ApiResponse<SensitiveDataScannerRuleUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SensitiveDataScannerRuleUpdateResponse>(){});
    }
}

