/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.regex.Pattern;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final String PREFIX = "dd.";
    private static final Pattern ENV_REPLACEMENT = Pattern.compile("[^a-zA-Z0-9_]");
    public static final String CONFIGURATION_FILE = "trace.config";
    public static final String SERVICE_NAME = "service.name";
    public static final String TRACE_ENABLED = "trace.enabled";
    public static final String INTEGRATIONS_ENABLED = "integrations.enabled";
    public static final String WRITER_TYPE = "writer.type";
    public static final String AGENT_HOST = "agent.host";
    public static final String TRACE_AGENT_PORT = "trace.agent.port";
    public static final String AGENT_PORT_LEGACY = "agent.port";
    public static final String AGENT_UNIX_DOMAIN_SOCKET = "trace.agent.unix.domain.socket";
    public static final String PRIORITY_SAMPLING = "priority.sampling";
    public static final String TRACE_RESOLVER_ENABLED = "trace.resolver.enabled";
    public static final String SERVICE_MAPPING = "service.mapping";
    public static final String GLOBAL_TAGS = "trace.global.tags";
    public static final String SPAN_TAGS = "trace.span.tags";
    public static final String JMX_TAGS = "trace.jmx.tags";
    public static final String TRACE_ANALYTICS_ENABLED = "trace.analytics.enabled";
    public static final String TRACE_ANNOTATIONS = "trace.annotations";
    public static final String TRACE_EXECUTORS_ALL = "trace.executors.all";
    public static final String TRACE_EXECUTORS = "trace.executors";
    public static final String TRACE_METHODS = "trace.methods";
    public static final String TRACE_CLASSES_EXCLUDE = "trace.classes.exclude";
    public static final String TRACE_SAMPLING_SERVICE_RULES = "trace.sampling.service.rules";
    public static final String TRACE_SAMPLING_OPERATION_RULES = "trace.sampling.operation.rules";
    public static final String TRACE_SAMPLING_DEFAULT_RATE = "trace.sampling.default.rate";
    public static final String TRACE_SAMPLING_RATE_LIMIT = "trace.sampling.rate.limit";
    public static final String TRACE_REPORT_HOSTNAME = "trace.report-hostname";
    public static final String HEADER_TAGS = "trace.header.tags";
    public static final String HTTP_SERVER_ERROR_STATUSES = "http.server.error.statuses";
    public static final String HTTP_CLIENT_ERROR_STATUSES = "http.client.error.statuses";
    public static final String HTTP_SERVER_TAG_QUERY_STRING = "http.server.tag.query-string";
    public static final String HTTP_CLIENT_TAG_QUERY_STRING = "http.client.tag.query-string";
    public static final String HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN = "trace.http.client.split-by-domain";
    public static final String DB_CLIENT_HOST_SPLIT_BY_INSTANCE = "trace.db.client.split-by-instance";
    public static final String SPLIT_BY_TAGS = "trace.split-by-tags";
    public static final String PARTIAL_FLUSH_MIN_SPANS = "trace.partial.flush.min.spans";
    public static final String RUNTIME_CONTEXT_FIELD_INJECTION = "trace.runtime.context.field.injection";
    public static final String PROPAGATION_STYLE_EXTRACT = "propagation.style.extract";
    public static final String PROPAGATION_STYLE_INJECT = "propagation.style.inject";
    public static final String JMX_FETCH_ENABLED = "jmxfetch.enabled";
    public static final String JMX_FETCH_CONFIG_DIR = "jmxfetch.config.dir";
    public static final String JMX_FETCH_CONFIG = "jmxfetch.config";
    public static final String JMX_FETCH_METRICS_CONFIGS = "jmxfetch.metrics-configs";
    public static final String JMX_FETCH_CHECK_PERIOD = "jmxfetch.check-period";
    public static final String JMX_FETCH_REFRESH_BEANS_PERIOD = "jmxfetch.refresh-beans-period";
    public static final String JMX_FETCH_STATSD_HOST = "jmxfetch.statsd.host";
    public static final String JMX_FETCH_STATSD_PORT = "jmxfetch.statsd.port";
    public static final String HEALTH_METRICS_ENABLED = "trace.health.metrics.enabled";
    public static final String HEALTH_METRICS_STATSD_HOST = "trace.health.metrics.statsd.host";
    public static final String HEALTH_METRICS_STATSD_PORT = "trace.health.metrics.statsd.port";
    public static final String LOGS_INJECTION_ENABLED = "logs.injection";
    public static final String SERVICE_TAG = "service";
    @Deprecated
    public static final String SERVICE = "service";
    public static final String RUNTIME_ID_TAG = "runtime-id";
    public static final String LANGUAGE_TAG_KEY = "language";
    public static final String LANGUAGE_TAG_VALUE = "jvm";
    public static final String DEFAULT_SERVICE_NAME = "unnamed-java-app";
    private static final boolean DEFAULT_TRACE_ENABLED = true;
    public static final boolean DEFAULT_INTEGRATIONS_ENABLED = true;
    public static final String DD_AGENT_WRITER_TYPE = "DDAgentWriter";
    public static final String LOGGING_WRITER_TYPE = "LoggingWriter";
    private static final String DEFAULT_AGENT_WRITER_TYPE = "DDAgentWriter";
    public static final String DEFAULT_AGENT_HOST = "localhost";
    public static final int DEFAULT_TRACE_AGENT_PORT = 8126;
    public static final String DEFAULT_AGENT_UNIX_DOMAIN_SOCKET = null;
    private static final boolean DEFAULT_RUNTIME_CONTEXT_FIELD_INJECTION = true;
    private static final boolean DEFAULT_PRIORITY_SAMPLING_ENABLED = true;
    private static final boolean DEFAULT_TRACE_RESOLVER_ENABLED = true;
    private static final Set<Integer> DEFAULT_HTTP_SERVER_ERROR_STATUSES = Config.parseIntegerRangeSet("500-599", "default");
    private static final Set<Integer> DEFAULT_HTTP_CLIENT_ERROR_STATUSES = Config.parseIntegerRangeSet("400-499", "default");
    private static final boolean DEFAULT_HTTP_SERVER_TAG_QUERY_STRING = false;
    private static final boolean DEFAULT_HTTP_CLIENT_TAG_QUERY_STRING = false;
    private static final boolean DEFAULT_HTTP_CLIENT_SPLIT_BY_DOMAIN = false;
    private static final boolean DEFAULT_DB_CLIENT_HOST_SPLIT_BY_INSTANCE = false;
    private static final String DEFAULT_SPLIT_BY_TAGS = "";
    private static final int DEFAULT_PARTIAL_FLUSH_MIN_SPANS = 1000;
    private static final String DEFAULT_PROPAGATION_STYLE_EXTRACT = PropagationStyle.DATADOG.name();
    private static final String DEFAULT_PROPAGATION_STYLE_INJECT = PropagationStyle.DATADOG.name();
    private static final boolean DEFAULT_JMX_FETCH_ENABLED = true;
    public static final int DEFAULT_JMX_FETCH_STATSD_PORT = 8125;
    public static final boolean DEFAULT_METRICS_ENABLED = false;
    public static final boolean DEFAULT_LOGS_INJECTION_ENABLED = false;
    private static final String SPLIT_BY_SPACE_OR_COMMA_REGEX = "[,\\s]+";
    private static final boolean DEFAULT_TRACE_REPORT_HOSTNAME = false;
    private static final String DEFAULT_TRACE_ANNOTATIONS = null;
    private static final boolean DEFAULT_TRACE_EXECUTORS_ALL = false;
    private static final String DEFAULT_TRACE_EXECUTORS = "";
    private static final String DEFAULT_TRACE_METHODS = null;
    public static final boolean DEFAULT_TRACE_ANALYTICS_ENABLED = false;
    public static final float DEFAULT_ANALYTICS_SAMPLE_RATE = 1.0f;
    public static final double DEFAULT_TRACE_SAMPLING_RATE_LIMIT = 100.0;
    private static final String INTERNAL_HOST_NAME = "_dd.hostname";
    private final String runtimeId;
    private final String serviceName;
    private final boolean traceEnabled;
    private final boolean integrationsEnabled;
    private final String writerType;
    private final String agentHost;
    private final int agentPort;
    private final String agentUnixDomainSocket;
    private final boolean prioritySamplingEnabled;
    private final boolean traceResolverEnabled;
    private final Map<String, String> serviceMapping;
    private final Map<String, String> globalTags;
    private final Map<String, String> spanTags;
    private final Map<String, String> jmxTags;
    private final List<String> excludedClasses;
    private final Map<String, String> headerTags;
    private final Set<Integer> httpServerErrorStatuses;
    private final Set<Integer> httpClientErrorStatuses;
    private final boolean httpServerTagQueryString;
    private final boolean httpClientTagQueryString;
    private final boolean httpClientSplitByDomain;
    private final boolean dbClientSplitByInstance;
    private final Set<String> splitByTags;
    private final Integer partialFlushMinSpans;
    private final boolean runtimeContextFieldInjection;
    private final Set<PropagationStyle> propagationStylesToExtract;
    private final Set<PropagationStyle> propagationStylesToInject;
    private final boolean jmxFetchEnabled;
    private final String jmxFetchConfigDir;
    private final List<String> jmxFetchConfigs;
    @Deprecated
    private final List<String> jmxFetchMetricsConfigs;
    private final Integer jmxFetchCheckPeriod;
    private final Integer jmxFetchRefreshBeansPeriod;
    private final String jmxFetchStatsdHost;
    private final Integer jmxFetchStatsdPort;
    private final boolean healthMetricsEnabled;
    private final String healthMetricsStatsdHost;
    private final Integer healthMetricsStatsdPort;
    private final boolean logsInjectionEnabled;
    private final boolean reportHostName;
    private final String traceAnnotations;
    private final String traceMethods;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final boolean traceAnalyticsEnabled;
    private final Map<String, String> traceSamplingServiceRules;
    private final Map<String, String> traceSamplingOperationRules;
    private final Double traceSamplingDefaultRate;
    private final Double traceSamplingRateLimit;
    private static Properties propertiesFromConfigFile;
    private static final Config INSTANCE;

    Config() {
        propertiesFromConfigFile = Config.loadConfigurationFile();
        this.runtimeId = UUID.randomUUID().toString();
        this.serviceName = Config.getSettingFromEnvironment(SERVICE_NAME, DEFAULT_SERVICE_NAME);
        this.traceEnabled = Config.getBooleanSettingFromEnvironment(TRACE_ENABLED, true);
        this.integrationsEnabled = Config.getBooleanSettingFromEnvironment(INTEGRATIONS_ENABLED, true);
        this.writerType = Config.getSettingFromEnvironment(WRITER_TYPE, "DDAgentWriter");
        this.agentHost = Config.getSettingFromEnvironment(AGENT_HOST, DEFAULT_AGENT_HOST);
        this.agentPort = Config.getIntegerSettingFromEnvironment(TRACE_AGENT_PORT, Config.getIntegerSettingFromEnvironment(AGENT_PORT_LEGACY, 8126));
        this.agentUnixDomainSocket = Config.getSettingFromEnvironment(AGENT_UNIX_DOMAIN_SOCKET, DEFAULT_AGENT_UNIX_DOMAIN_SOCKET);
        this.prioritySamplingEnabled = Config.getBooleanSettingFromEnvironment(PRIORITY_SAMPLING, true);
        this.traceResolverEnabled = Config.getBooleanSettingFromEnvironment(TRACE_RESOLVER_ENABLED, true);
        this.serviceMapping = Config.getMapSettingFromEnvironment(SERVICE_MAPPING, null);
        this.globalTags = Config.getMapSettingFromEnvironment(GLOBAL_TAGS, null);
        this.spanTags = Config.getMapSettingFromEnvironment(SPAN_TAGS, null);
        this.jmxTags = Config.getMapSettingFromEnvironment(JMX_TAGS, null);
        this.excludedClasses = Config.getListSettingFromEnvironment(TRACE_CLASSES_EXCLUDE, null);
        this.headerTags = Config.getMapSettingFromEnvironment(HEADER_TAGS, null);
        this.httpServerErrorStatuses = this.getIntegerRangeSettingFromEnvironment(HTTP_SERVER_ERROR_STATUSES, DEFAULT_HTTP_SERVER_ERROR_STATUSES);
        this.httpClientErrorStatuses = this.getIntegerRangeSettingFromEnvironment(HTTP_CLIENT_ERROR_STATUSES, DEFAULT_HTTP_CLIENT_ERROR_STATUSES);
        this.httpServerTagQueryString = Config.getBooleanSettingFromEnvironment(HTTP_SERVER_TAG_QUERY_STRING, false);
        this.httpClientTagQueryString = Config.getBooleanSettingFromEnvironment(HTTP_CLIENT_TAG_QUERY_STRING, false);
        this.httpClientSplitByDomain = Config.getBooleanSettingFromEnvironment(HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN, false);
        this.dbClientSplitByInstance = Config.getBooleanSettingFromEnvironment(DB_CLIENT_HOST_SPLIT_BY_INSTANCE, false);
        this.splitByTags = Collections.unmodifiableSet(new LinkedHashSet<String>(Config.getListSettingFromEnvironment(SPLIT_BY_TAGS, "")));
        this.partialFlushMinSpans = Config.getIntegerSettingFromEnvironment(PARTIAL_FLUSH_MIN_SPANS, 1000);
        this.runtimeContextFieldInjection = Config.getBooleanSettingFromEnvironment(RUNTIME_CONTEXT_FIELD_INJECTION, true);
        this.propagationStylesToExtract = Config.getEnumSetSettingFromEnvironment(PROPAGATION_STYLE_EXTRACT, DEFAULT_PROPAGATION_STYLE_EXTRACT, PropagationStyle.class, true);
        this.propagationStylesToInject = Config.getEnumSetSettingFromEnvironment(PROPAGATION_STYLE_INJECT, DEFAULT_PROPAGATION_STYLE_INJECT, PropagationStyle.class, true);
        this.jmxFetchEnabled = Config.getBooleanSettingFromEnvironment(JMX_FETCH_ENABLED, true);
        this.jmxFetchConfigDir = Config.getSettingFromEnvironment(JMX_FETCH_CONFIG_DIR, null);
        this.jmxFetchConfigs = Config.getListSettingFromEnvironment(JMX_FETCH_CONFIG, null);
        this.jmxFetchMetricsConfigs = Config.getListSettingFromEnvironment(JMX_FETCH_METRICS_CONFIGS, null);
        this.jmxFetchCheckPeriod = Config.getIntegerSettingFromEnvironment(JMX_FETCH_CHECK_PERIOD, null);
        this.jmxFetchRefreshBeansPeriod = Config.getIntegerSettingFromEnvironment(JMX_FETCH_REFRESH_BEANS_PERIOD, null);
        this.jmxFetchStatsdHost = Config.getSettingFromEnvironment(JMX_FETCH_STATSD_HOST, null);
        this.jmxFetchStatsdPort = Config.getIntegerSettingFromEnvironment(JMX_FETCH_STATSD_PORT, 8125);
        this.healthMetricsEnabled = Config.getBooleanSettingFromEnvironment(HEALTH_METRICS_ENABLED, false);
        this.healthMetricsStatsdHost = Config.getSettingFromEnvironment(HEALTH_METRICS_STATSD_HOST, null);
        this.healthMetricsStatsdPort = Config.getIntegerSettingFromEnvironment(HEALTH_METRICS_STATSD_PORT, null);
        this.logsInjectionEnabled = Config.getBooleanSettingFromEnvironment(LOGS_INJECTION_ENABLED, false);
        this.reportHostName = Config.getBooleanSettingFromEnvironment(TRACE_REPORT_HOSTNAME, false);
        this.traceAnnotations = Config.getSettingFromEnvironment(TRACE_ANNOTATIONS, DEFAULT_TRACE_ANNOTATIONS);
        this.traceMethods = Config.getSettingFromEnvironment(TRACE_METHODS, DEFAULT_TRACE_METHODS);
        this.traceExecutorsAll = Config.getBooleanSettingFromEnvironment(TRACE_EXECUTORS_ALL, false);
        this.traceExecutors = Config.getListSettingFromEnvironment(TRACE_EXECUTORS, "");
        this.traceAnalyticsEnabled = Config.getBooleanSettingFromEnvironment(TRACE_ANALYTICS_ENABLED, false);
        this.traceSamplingServiceRules = Config.getMapSettingFromEnvironment(TRACE_SAMPLING_SERVICE_RULES, null);
        this.traceSamplingOperationRules = Config.getMapSettingFromEnvironment(TRACE_SAMPLING_OPERATION_RULES, null);
        this.traceSamplingDefaultRate = Config.getDoubleSettingFromEnvironment(TRACE_SAMPLING_DEFAULT_RATE, null);
        this.traceSamplingRateLimit = Config.getDoubleSettingFromEnvironment(TRACE_SAMPLING_RATE_LIMIT, 100.0);
        log.debug("New instance: {}", (Object)this);
    }

    private Config(Properties properties, Config parent) {
        this.runtimeId = parent.runtimeId;
        this.serviceName = properties.getProperty(SERVICE_NAME, parent.serviceName);
        this.traceEnabled = Config.getPropertyBooleanValue(properties, TRACE_ENABLED, parent.traceEnabled);
        this.integrationsEnabled = Config.getPropertyBooleanValue(properties, INTEGRATIONS_ENABLED, parent.integrationsEnabled);
        this.writerType = properties.getProperty(WRITER_TYPE, parent.writerType);
        this.agentHost = properties.getProperty(AGENT_HOST, parent.agentHost);
        this.agentPort = Config.getPropertyIntegerValue(properties, TRACE_AGENT_PORT, Config.getPropertyIntegerValue(properties, AGENT_PORT_LEGACY, parent.agentPort));
        this.agentUnixDomainSocket = properties.getProperty(AGENT_UNIX_DOMAIN_SOCKET, parent.agentUnixDomainSocket);
        this.prioritySamplingEnabled = Config.getPropertyBooleanValue(properties, PRIORITY_SAMPLING, parent.prioritySamplingEnabled);
        this.traceResolverEnabled = Config.getPropertyBooleanValue(properties, TRACE_RESOLVER_ENABLED, parent.traceResolverEnabled);
        this.serviceMapping = Config.getPropertyMapValue(properties, SERVICE_MAPPING, parent.serviceMapping);
        this.globalTags = Config.getPropertyMapValue(properties, GLOBAL_TAGS, parent.globalTags);
        this.spanTags = Config.getPropertyMapValue(properties, SPAN_TAGS, parent.spanTags);
        this.jmxTags = Config.getPropertyMapValue(properties, JMX_TAGS, parent.jmxTags);
        this.excludedClasses = Config.getPropertyListValue(properties, TRACE_CLASSES_EXCLUDE, parent.excludedClasses);
        this.headerTags = Config.getPropertyMapValue(properties, HEADER_TAGS, parent.headerTags);
        this.httpServerErrorStatuses = this.getPropertyIntegerRangeValue(properties, HTTP_SERVER_ERROR_STATUSES, parent.httpServerErrorStatuses);
        this.httpClientErrorStatuses = this.getPropertyIntegerRangeValue(properties, HTTP_CLIENT_ERROR_STATUSES, parent.httpClientErrorStatuses);
        this.httpServerTagQueryString = Config.getPropertyBooleanValue(properties, HTTP_SERVER_TAG_QUERY_STRING, parent.httpServerTagQueryString);
        this.httpClientTagQueryString = Config.getPropertyBooleanValue(properties, HTTP_CLIENT_TAG_QUERY_STRING, parent.httpClientTagQueryString);
        this.httpClientSplitByDomain = Config.getPropertyBooleanValue(properties, HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN, parent.httpClientSplitByDomain);
        this.dbClientSplitByInstance = Config.getPropertyBooleanValue(properties, DB_CLIENT_HOST_SPLIT_BY_INSTANCE, parent.dbClientSplitByInstance);
        this.splitByTags = Collections.unmodifiableSet(new LinkedHashSet<String>(Config.getPropertyListValue(properties, SPLIT_BY_TAGS, new ArrayList<String>(parent.splitByTags))));
        this.partialFlushMinSpans = Config.getPropertyIntegerValue(properties, PARTIAL_FLUSH_MIN_SPANS, parent.partialFlushMinSpans);
        this.runtimeContextFieldInjection = Config.getPropertyBooleanValue(properties, RUNTIME_CONTEXT_FIELD_INJECTION, parent.runtimeContextFieldInjection);
        Set<PropagationStyle> parsedPropagationStylesToExtract = Config.getPropertySetValue(properties, PROPAGATION_STYLE_EXTRACT, PropagationStyle.class);
        this.propagationStylesToExtract = parsedPropagationStylesToExtract == null ? parent.propagationStylesToExtract : parsedPropagationStylesToExtract;
        Set<PropagationStyle> parsedPropagationStylesToInject = Config.getPropertySetValue(properties, PROPAGATION_STYLE_INJECT, PropagationStyle.class);
        this.propagationStylesToInject = parsedPropagationStylesToInject == null ? parent.propagationStylesToInject : parsedPropagationStylesToInject;
        this.jmxFetchEnabled = Config.getPropertyBooleanValue(properties, JMX_FETCH_ENABLED, parent.jmxFetchEnabled);
        this.jmxFetchConfigDir = properties.getProperty(JMX_FETCH_CONFIG_DIR, parent.jmxFetchConfigDir);
        this.jmxFetchConfigs = Config.getPropertyListValue(properties, JMX_FETCH_CONFIG, parent.jmxFetchConfigs);
        this.jmxFetchMetricsConfigs = Config.getPropertyListValue(properties, JMX_FETCH_METRICS_CONFIGS, parent.jmxFetchMetricsConfigs);
        this.jmxFetchCheckPeriod = Config.getPropertyIntegerValue(properties, JMX_FETCH_CHECK_PERIOD, parent.jmxFetchCheckPeriod);
        this.jmxFetchRefreshBeansPeriod = Config.getPropertyIntegerValue(properties, JMX_FETCH_REFRESH_BEANS_PERIOD, parent.jmxFetchRefreshBeansPeriod);
        this.jmxFetchStatsdHost = properties.getProperty(JMX_FETCH_STATSD_HOST, parent.jmxFetchStatsdHost);
        this.jmxFetchStatsdPort = Config.getPropertyIntegerValue(properties, JMX_FETCH_STATSD_PORT, parent.jmxFetchStatsdPort);
        this.healthMetricsEnabled = Config.getPropertyBooleanValue(properties, HEALTH_METRICS_ENABLED, false);
        this.healthMetricsStatsdHost = properties.getProperty(HEALTH_METRICS_STATSD_HOST, parent.healthMetricsStatsdHost);
        this.healthMetricsStatsdPort = Config.getPropertyIntegerValue(properties, HEALTH_METRICS_STATSD_PORT, parent.healthMetricsStatsdPort);
        this.logsInjectionEnabled = Config.getBooleanSettingFromEnvironment(LOGS_INJECTION_ENABLED, false);
        this.reportHostName = Config.getPropertyBooleanValue(properties, TRACE_REPORT_HOSTNAME, parent.reportHostName);
        this.traceAnnotations = properties.getProperty(TRACE_ANNOTATIONS, parent.traceAnnotations);
        this.traceMethods = properties.getProperty(TRACE_METHODS, parent.traceMethods);
        this.traceExecutorsAll = Config.getPropertyBooleanValue(properties, TRACE_EXECUTORS_ALL, parent.traceExecutorsAll);
        this.traceExecutors = Config.getPropertyListValue(properties, TRACE_EXECUTORS, parent.traceExecutors);
        this.traceAnalyticsEnabled = Config.getPropertyBooleanValue(properties, TRACE_ANALYTICS_ENABLED, parent.traceAnalyticsEnabled);
        this.traceSamplingServiceRules = Config.getPropertyMapValue(properties, TRACE_SAMPLING_SERVICE_RULES, parent.traceSamplingServiceRules);
        this.traceSamplingOperationRules = Config.getPropertyMapValue(properties, TRACE_SAMPLING_OPERATION_RULES, parent.traceSamplingOperationRules);
        this.traceSamplingDefaultRate = Config.getPropertyDoubleValue(properties, TRACE_SAMPLING_DEFAULT_RATE, parent.traceSamplingDefaultRate);
        this.traceSamplingRateLimit = Config.getPropertyDoubleValue(properties, TRACE_SAMPLING_RATE_LIMIT, parent.traceSamplingRateLimit);
        log.debug("New instance: {}", (Object)this);
    }

    public Map<String, String> getLocalRootSpanTags() {
        String hostName;
        Map<String, String> runtimeTags = this.getRuntimeTags();
        HashMap<String, String> result = new HashMap<String, String>(runtimeTags);
        result.put(LANGUAGE_TAG_KEY, LANGUAGE_TAG_VALUE);
        if (this.reportHostName && null != (hostName = this.getHostName()) && !hostName.isEmpty()) {
            result.put(INTERNAL_HOST_NAME, hostName);
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedSpanTags() {
        Map<String, String> result = Config.newHashMap(this.globalTags.size() + this.spanTags.size());
        result.putAll(this.globalTags);
        result.putAll(this.spanTags);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedJmxTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        Map<String, String> result = Config.newHashMap(this.globalTags.size() + this.jmxTags.size() + runtimeTags.size() + 1);
        result.putAll(this.globalTags);
        result.putAll(this.jmxTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        return Collections.unmodifiableMap(result);
    }

    public float getInstrumentationAnalyticsSampleRate(String ... aliases) {
        for (String alias : aliases) {
            Float rate = Config.getFloatSettingFromEnvironment(alias + ".analytics.sample-rate", null);
            if (null == rate) continue;
            return rate.floatValue();
        }
        return 1.0f;
    }

    private Map<String, String> getRuntimeTags() {
        Map<String, String> result = Config.newHashMap(2);
        result.put(RUNTIME_ID_TAG, this.runtimeId);
        return Collections.unmodifiableMap(result);
    }

    public boolean isIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.integrationEnabled(integrationNames, defaultEnabled);
    }

    public static boolean integrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment("integration." + name + ".enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public boolean isJmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.jmxFetchIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public static boolean jmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment("jmxfetch." + name + ".enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public boolean isTraceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.traceAnalyticsIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public static boolean traceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment(name + ".analytics.enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public static String getSettingFromEnvironment(String name, String defaultValue) {
        String value = System.getProperties().getProperty(Config.propertyNameToSystemPropertyName(name));
        if (null != value) {
            return value;
        }
        value = System.getenv(Config.propertyNameToEnvironmentVariableName(name));
        if (null != value) {
            return value;
        }
        value = propertiesFromConfigFile.getProperty(Config.propertyNameToSystemPropertyName(name));
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    private static Map<String, String> getMapSettingFromEnvironment(String name, String defaultValue) {
        return Config.parseMap(Config.getSettingFromEnvironment(name, defaultValue), Config.propertyNameToSystemPropertyName(name));
    }

    public static List<String> getListSettingFromEnvironment(String name, String defaultValue) {
        return Config.parseList(Config.getSettingFromEnvironment(name, defaultValue));
    }

    public static Boolean getBooleanSettingFromEnvironment(String name, Boolean defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        return value == null || value.trim().isEmpty() ? defaultValue : Boolean.valueOf(value);
    }

    public static Float getFloatSettingFromEnvironment(String name, Float defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        try {
            return value == null ? defaultValue : Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, e);
            return defaultValue;
        }
    }

    public static Double getDoubleSettingFromEnvironment(String name, Double defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        try {
            return value == null ? defaultValue : Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, e);
            return defaultValue;
        }
    }

    private static Integer getIntegerSettingFromEnvironment(String name, Integer defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        try {
            return value == null ? defaultValue : Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, e);
            return defaultValue;
        }
    }

    private static <T extends Enum<T>> Set<T> getEnumSetSettingFromEnvironment(String name, String defaultValue, Class<T> clazz, boolean emptyResultMeansUseDefault) {
        String value = Config.getSettingFromEnvironment(name, defaultValue);
        Set<T> result = Config.convertStringSetToEnumSet(Config.parseStringIntoSetOfNonEmptyStrings(value, SPLIT_BY_SPACE_OR_COMMA_REGEX), clazz);
        if (emptyResultMeansUseDefault && result.isEmpty()) {
            result = Config.convertStringSetToEnumSet(Config.parseStringIntoSetOfNonEmptyStrings(defaultValue, SPLIT_BY_SPACE_OR_COMMA_REGEX), clazz);
        }
        return result;
    }

    private Set<Integer> getIntegerRangeSettingFromEnvironment(String name, Set<Integer> defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        try {
            return value == null ? defaultValue : Config.parseIntegerRangeSet(value, name);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, e);
            return defaultValue;
        }
    }

    private static String propertyNameToEnvironmentVariableName(String setting) {
        return ENV_REPLACEMENT.matcher(Config.propertyNameToSystemPropertyName(setting).toUpperCase()).replaceAll("_");
    }

    private static String propertyNameToSystemPropertyName(String setting) {
        return PREFIX + setting;
    }

    private static Map<String, String> getPropertyMapValue(Properties properties, String name, Map<String, String> defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Config.parseMap(value, name);
    }

    private static List<String> getPropertyListValue(Properties properties, String name, List<String> defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Config.parseList(value);
    }

    private static Boolean getPropertyBooleanValue(Properties properties, String name, Boolean defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Boolean.valueOf(value);
    }

    private static Integer getPropertyIntegerValue(Properties properties, String name, Integer defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Integer.valueOf(value);
    }

    private static Double getPropertyDoubleValue(Properties properties, String name, Double defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Double.valueOf(value);
    }

    private static <T extends Enum<T>> Set<T> getPropertySetValue(Properties properties, String name, Class<T> clazz) {
        Set<T> result;
        String value = properties.getProperty(name);
        if (value != null && !(result = Config.convertStringSetToEnumSet(Config.parseStringIntoSetOfNonEmptyStrings(value, SPLIT_BY_SPACE_OR_COMMA_REGEX), clazz)).isEmpty()) {
            return result;
        }
        return null;
    }

    private Set<Integer> getPropertyIntegerRangeValue(Properties properties, String name, Set<Integer> defaultValue) {
        String value = properties.getProperty(name);
        try {
            return value == null ? defaultValue : Config.parseIntegerRangeSet(value, name);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, e);
            return defaultValue;
        }
    }

    private static Map<String, String> parseMap(String str, String settingName) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        if (!str.matches("(([^,:]+:[^,:]*,)*([^,:]+:[^,:]*),?)?")) {
            log.warn("Invalid config for {}: '{}'. Must match 'key1:value1,key2:value2'.", (Object)settingName, (Object)str);
            return Collections.emptyMap();
        }
        String[] tokens = str.split(",", -1);
        Map<String, String> map = Config.newHashMap(tokens.length);
        for (String token : tokens) {
            String[] keyValue = token.split(":", -1);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            if (value.length() <= 0) {
                log.warn("Ignoring empty value for key '{}' in config for {}", (Object)key, (Object)settingName);
                continue;
            }
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    private static Set<Integer> parseIntegerRangeSet(String str, String settingName) throws NumberFormatException {
        assert (str != null);
        if (!(str = str.replaceAll("\\s", "")).matches("\\d{3}(?:-\\d{3})?(?:,\\d{3}(?:-\\d{3})?)*")) {
            log.warn("Invalid config for {}: '{}'. Must be formatted like '400-403,405,410-499'.", (Object)settingName, (Object)str);
            throw new NumberFormatException();
        }
        String[] tokens = str.split(",", -1);
        HashSet<Integer> set = new HashSet<Integer>();
        for (String token : tokens) {
            String[] range = token.split("-", -1);
            if (range.length == 1) {
                set.add(Integer.parseInt(range[0]));
                continue;
            }
            if (range.length != 2) continue;
            int left = Integer.parseInt(range[0]);
            int right = Integer.parseInt(range[1]);
            int min = Math.min(left, right);
            int max = Math.max(left, right);
            for (int i = min; i <= max; ++i) {
                set.add(i);
            }
        }
        return Collections.unmodifiableSet(set);
    }

    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    private static List<String> parseList(String str) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = str.split(",", -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str, String regex) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String value : str.split(regex)) {
            if (value.isEmpty()) continue;
            result.add(value);
        }
        return Collections.unmodifiableSet(result);
    }

    private static <V extends Enum<V>> Set<V> convertStringSetToEnumSet(Set<String> input, Class<V> clazz) {
        LinkedHashSet<V> result = new LinkedHashSet<V>();
        for (String value : input) {
            try {
                result.add(Enum.valueOf(clazz, value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.debug("Cannot recognize config string value: {}, {}", (Object)value, (Object)clazz);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static Properties loadConfigurationFile() {
        Properties properties = new Properties();
        String configurationFilePath = System.getProperty(Config.propertyNameToSystemPropertyName(CONFIGURATION_FILE));
        if (null == configurationFilePath) {
            configurationFilePath = System.getenv(Config.propertyNameToEnvironmentVariableName(CONFIGURATION_FILE));
        }
        if (null == configurationFilePath) {
            return properties;
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
            return properties;
        }
        try {
            FileReader fileReader = new FileReader(configurationFile);
            properties.load(fileReader);
        }
        catch (FileNotFoundException fnf) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
        }
        catch (IOException ioe) {
            log.error("Configuration file '{}' cannot be accessed or correctly parsed.", (Object)configurationFilePath);
        }
        return properties;
    }

    private String getHostName() {
        String possibleHostname = null;
        possibleHostname = System.getProperty("os.name").startsWith("Windows") ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from environment variable");
            return possibleHostname.trim();
        }
        try {
            Process process = Runtime.getRuntime().exec("hostname");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            possibleHostname = reader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from hostname command");
            return possibleHostname.trim();
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static Config get() {
        return INSTANCE;
    }

    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(properties, INSTANCE);
    }

    public String toString() {
        return "Config(runtimeId=" + this.getRuntimeId() + ", serviceName=" + this.getServiceName() + ", traceEnabled=" + this.isTraceEnabled() + ", integrationsEnabled=" + this.isIntegrationsEnabled() + ", writerType=" + this.getWriterType() + ", agentHost=" + this.getAgentHost() + ", agentPort=" + this.getAgentPort() + ", agentUnixDomainSocket=" + this.getAgentUnixDomainSocket() + ", prioritySamplingEnabled=" + this.isPrioritySamplingEnabled() + ", traceResolverEnabled=" + this.isTraceResolverEnabled() + ", serviceMapping=" + this.getServiceMapping() + ", globalTags=" + this.globalTags + ", spanTags=" + this.spanTags + ", jmxTags=" + this.jmxTags + ", excludedClasses=" + this.getExcludedClasses() + ", headerTags=" + this.getHeaderTags() + ", httpServerErrorStatuses=" + this.getHttpServerErrorStatuses() + ", httpClientErrorStatuses=" + this.getHttpClientErrorStatuses() + ", httpServerTagQueryString=" + this.isHttpServerTagQueryString() + ", httpClientTagQueryString=" + this.isHttpClientTagQueryString() + ", httpClientSplitByDomain=" + this.isHttpClientSplitByDomain() + ", dbClientSplitByInstance=" + this.isDbClientSplitByInstance() + ", splitByTags=" + this.getSplitByTags() + ", partialFlushMinSpans=" + this.getPartialFlushMinSpans() + ", runtimeContextFieldInjection=" + this.isRuntimeContextFieldInjection() + ", propagationStylesToExtract=" + this.getPropagationStylesToExtract() + ", propagationStylesToInject=" + this.getPropagationStylesToInject() + ", jmxFetchEnabled=" + this.isJmxFetchEnabled() + ", jmxFetchConfigDir=" + this.getJmxFetchConfigDir() + ", jmxFetchConfigs=" + this.getJmxFetchConfigs() + ", jmxFetchMetricsConfigs=" + this.getJmxFetchMetricsConfigs() + ", jmxFetchCheckPeriod=" + this.getJmxFetchCheckPeriod() + ", jmxFetchRefreshBeansPeriod=" + this.getJmxFetchRefreshBeansPeriod() + ", jmxFetchStatsdHost=" + this.getJmxFetchStatsdHost() + ", jmxFetchStatsdPort=" + this.getJmxFetchStatsdPort() + ", healthMetricsEnabled=" + this.isHealthMetricsEnabled() + ", healthMetricsStatsdHost=" + this.getHealthMetricsStatsdHost() + ", healthMetricsStatsdPort=" + this.getHealthMetricsStatsdPort() + ", logsInjectionEnabled=" + this.isLogsInjectionEnabled() + ", reportHostName=" + this.isReportHostName() + ", traceAnnotations=" + this.getTraceAnnotations() + ", traceMethods=" + this.getTraceMethods() + ", traceExecutorsAll=" + this.isTraceExecutorsAll() + ", traceExecutors=" + this.getTraceExecutors() + ", traceAnalyticsEnabled=" + this.isTraceAnalyticsEnabled() + ", traceSamplingServiceRules=" + this.getTraceSamplingServiceRules() + ", traceSamplingOperationRules=" + this.getTraceSamplingOperationRules() + ", traceSamplingDefaultRate=" + this.getTraceSamplingDefaultRate() + ", traceSamplingRateLimit=" + this.getTraceSamplingRateLimit() + ")";
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public String getWriterType() {
        return this.writerType;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentUnixDomainSocket() {
        return this.agentUnixDomainSocket;
    }

    public boolean isPrioritySamplingEnabled() {
        return this.prioritySamplingEnabled;
    }

    public boolean isTraceResolverEnabled() {
        return this.traceResolverEnabled;
    }

    public Map<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    public Set<Integer> getHttpServerErrorStatuses() {
        return this.httpServerErrorStatuses;
    }

    public Set<Integer> getHttpClientErrorStatuses() {
        return this.httpClientErrorStatuses;
    }

    public boolean isHttpServerTagQueryString() {
        return this.httpServerTagQueryString;
    }

    public boolean isHttpClientTagQueryString() {
        return this.httpClientTagQueryString;
    }

    public boolean isHttpClientSplitByDomain() {
        return this.httpClientSplitByDomain;
    }

    public boolean isDbClientSplitByInstance() {
        return this.dbClientSplitByInstance;
    }

    public Set<String> getSplitByTags() {
        return this.splitByTags;
    }

    public Integer getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public Set<PropagationStyle> getPropagationStylesToExtract() {
        return this.propagationStylesToExtract;
    }

    public Set<PropagationStyle> getPropagationStylesToInject() {
        return this.propagationStylesToInject;
    }

    public boolean isJmxFetchEnabled() {
        return this.jmxFetchEnabled;
    }

    public String getJmxFetchConfigDir() {
        return this.jmxFetchConfigDir;
    }

    public List<String> getJmxFetchConfigs() {
        return this.jmxFetchConfigs;
    }

    @Deprecated
    public List<String> getJmxFetchMetricsConfigs() {
        return this.jmxFetchMetricsConfigs;
    }

    public Integer getJmxFetchCheckPeriod() {
        return this.jmxFetchCheckPeriod;
    }

    public Integer getJmxFetchRefreshBeansPeriod() {
        return this.jmxFetchRefreshBeansPeriod;
    }

    public String getJmxFetchStatsdHost() {
        return this.jmxFetchStatsdHost;
    }

    public Integer getJmxFetchStatsdPort() {
        return this.jmxFetchStatsdPort;
    }

    public boolean isHealthMetricsEnabled() {
        return this.healthMetricsEnabled;
    }

    public String getHealthMetricsStatsdHost() {
        return this.healthMetricsStatsdHost;
    }

    public Integer getHealthMetricsStatsdPort() {
        return this.healthMetricsStatsdPort;
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public boolean isReportHostName() {
        return this.reportHostName;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public String getTraceMethods() {
        return this.traceMethods;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public boolean isTraceAnalyticsEnabled() {
        return this.traceAnalyticsEnabled;
    }

    public Map<String, String> getTraceSamplingServiceRules() {
        return this.traceSamplingServiceRules;
    }

    public Map<String, String> getTraceSamplingOperationRules() {
        return this.traceSamplingOperationRules;
    }

    public Double getTraceSamplingDefaultRate() {
        return this.traceSamplingDefaultRate;
    }

    public Double getTraceSamplingRateLimit() {
        return this.traceSamplingRateLimit;
    }

    static {
        INSTANCE = new Config();
    }

    public static enum PropagationStyle {
        DATADOG,
        B3,
        HAYSTACK;

    }
}

