/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class Agent {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "datadog.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "datadog.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[dd.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "datadog.slf4j.simpleLogger.defaultLogLevel";
    private static final Logger LOGGER;
    private static ClassLoader AGENT_CLASSLOADER;
    private static ClassLoader JMXFETCH_CLASSLOADER;

    public static void start(Instrumentation inst, URL bootstrapURL) throws Exception {
        Agent.startDatadogAgent(inst, bootstrapURL);
        boolean appUsingCustomLogManager = Agent.isAppUsingCustomLogManager();
        if (appUsingCustomLogManager) {
            LOGGER.debug("Custom logger detected. Delaying JMXFetch initialization.");
            Agent.registerLogManagerCallback(new StartJmxFetchCallback(inst, bootstrapURL));
        } else {
            Agent.startJmxFetch(inst, bootstrapURL);
        }
        if (Agent.isJavaBefore9WithJFR() && appUsingCustomLogManager) {
            LOGGER.debug("Custom logger detected. Delaying Datadog Tracer initialization.");
            Agent.registerLogManagerCallback(new InstallDatadogTracerCallback(inst, bootstrapURL));
        } else {
            Agent.installDatadogTracer(inst, bootstrapURL);
        }
    }

    private static void registerLogManagerCallback(Runnable callback) throws Exception {
        Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.AgentInstaller");
        Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
        registerCallbackMethod.invoke(null, "java.util.logging.LogManager", callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startDatadogAgent(Instrumentation inst, URL bootstrapURL) throws Exception {
        if (AGENT_CLASSLOADER == null) {
            ClassLoader agentClassLoader = Agent.createDatadogClassLoader("agent-tooling-and-instrumentation.isolated", bootstrapURL);
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(agentClassLoader);
                Class<?> agentInstallerClass = agentClassLoader.loadClass("datadog.trace.agent.tooling.AgentInstaller");
                Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
                agentInstallerMethod.invoke(null, inst);
                AGENT_CLASSLOADER = agentClassLoader;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void installDatadogTracer(Instrumentation inst, URL bootstrapURL) throws Exception {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AGENT_CLASSLOADER);
            Class<?> tracerInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.TracerInstaller");
            Method tracerInstallerMethod = tracerInstallerClass.getMethod("installGlobalTracer", new Class[0]);
            tracerInstallerMethod.invoke(null, new Object[0]);
            Method logVersionInfoMethod = tracerInstallerClass.getMethod("logVersionInfo", new Class[0]);
            logVersionInfoMethod.invoke(null, new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startJmxFetch(Instrumentation inst, URL bootstrapURL) throws Exception {
        if (JMXFETCH_CLASSLOADER == null) {
            ClassLoader jmxFetchClassLoader = Agent.createDatadogClassLoader("agent-jmxfetch.isolated", bootstrapURL);
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(jmxFetchClassLoader);
                Class<?> jmxFetchAgentClass = jmxFetchClassLoader.loadClass("datadog.trace.agent.jmxfetch.JMXFetch");
                Method jmxFetchInstallerMethod = jmxFetchAgentClass.getMethod("run", new Class[0]);
                jmxFetchInstallerMethod.invoke(null, new Object[0]);
                JMXFETCH_CLASSLOADER = jmxFetchClassLoader;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
    }

    private static void configureLogger() {
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (Agent.isDebugMode()) {
            Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static ClassLoader createDatadogClassLoader(String innerJarFilename, URL bootstrapURL) throws Exception {
        ClassLoader agentParent = Agent.isJavaBefore9() ? null : Agent.getPlatformClassLoader();
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class);
        return (ClassLoader)constructor.newInstance(bootstrapURL, innerJarFilename, agentParent);
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = System.getProperty("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv("dd.trace.debug".replace('.', '_').toUpperCase());
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    private static boolean isAppUsingCustomLogManager() {
        String tracerCustomLogManSysprop = "dd.app.customlogmanager";
        String customLogManagerProp = System.getProperty("dd.app.customlogmanager");
        String customLogManagerEnv = System.getenv("dd.app.customlogmanager".replace('.', '_').toUpperCase());
        if (customLogManagerProp != null || customLogManagerEnv != null) {
            LOGGER.debug("Prop - customlogmanager: " + customLogManagerProp);
            LOGGER.debug("Env - customlogmanager: " + customLogManagerEnv);
            return Boolean.parseBoolean(customLogManagerProp) || Boolean.parseBoolean(customLogManagerEnv);
        }
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            LOGGER.debug("Env - jboss: " + jbossHome);
            return true;
        }
        String logManagerProp = System.getProperty("java.util.logging.manager");
        if (logManagerProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(logManagerProp.replaceAll("\\.", "/") + ".class") != null;
            LOGGER.debug("Prop - logging.manager: " + logManagerProp);
            LOGGER.debug("logging.manager on system classpath: " + onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }

    private static boolean isJavaBefore9WithJFR() {
        if (!Agent.isJavaBefore9()) {
            return false;
        }
        String jfrClassResourceName = "jdk.jfr.Recording".replace('.', '/') + ".class";
        return Thread.currentThread().getContextClassLoader().getResource(jfrClassResourceName) != null;
    }

    static {
        Agent.configureLogger();
        LOGGER = LoggerFactory.getLogger(Agent.class);
        AGENT_CLASSLOADER = null;
        JMXFETCH_CLASSLOADER = null;
    }

    protected static class InstallDatadogTracerCallback
    extends ClassLoadCallBack {
        InstallDatadogTracerCallback(Instrumentation inst, URL bootstrapURL) {
            super(inst, bootstrapURL);
        }

        @Override
        public String getName() {
            return "datadog-tracer";
        }

        @Override
        public void execute() throws Exception {
            Agent.installDatadogTracer(this.inst, this.bootstrapURL);
        }
    }

    protected static class StartJmxFetchCallback
    extends ClassLoadCallBack {
        StartJmxFetchCallback(Instrumentation inst, URL bootstrapURL) {
            super(inst, bootstrapURL);
        }

        @Override
        public String getName() {
            return "jmxfetch";
        }

        @Override
        public void execute() throws Exception {
            Agent.startJmxFetch(this.inst, this.bootstrapURL);
        }
    }

    protected static abstract class ClassLoadCallBack
    implements Runnable {
        final Instrumentation inst;
        final URL bootstrapURL;

        ClassLoadCallBack(Instrumentation inst, URL bootstrapURL) {
            this.inst = inst;
            this.bootstrapURL = bootstrapURL;
        }

        @Override
        public void run() {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassLoadCallBack.this.execute();
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to run class loader callback {}", (Object)ClassLoadCallBack.this.getName(), (Object)e);
                    }
                }
            });
            thread.setName("dd-agent-startup-" + this.getName());
            thread.setDaemon(true);
            thread.start();
        }

        public abstract String getName();

        public abstract void execute() throws Exception;
    }
}

