/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.InternalJarURLHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class DatadogClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DatadogClassLoader.class);
    private final BootstrapClassLoaderProxy bootstrapProxy;

    public DatadogClassLoader(URL bootstrapJarLocation, String internalJarFileName, ClassLoader parent) {
        super(new URL[0], parent);
        this.bootstrapProxy = bootstrapJarLocation == null ? new BootstrapClassLoaderProxy(new URL[0]) : new BootstrapClassLoaderProxy(new URL[]{bootstrapJarLocation});
        try {
            URL internalJarURL = new URL("x-internal-jar", null, 0, "/", new InternalJarURLHandler(internalJarFileName, bootstrapJarLocation));
            this.addURL(internalJarURL);
        }
        catch (MalformedURLException e) {
            log.error("URL malformed.  Unsupported JDK?", e);
        }
    }

    @Override
    public URL getResource(String resourceName) {
        URL bootstrapResource = this.bootstrapProxy.getResource(resourceName);
        if (null == bootstrapResource) {
            return super.getResource(resourceName);
        }
        return bootstrapResource;
    }

    public boolean hasLoadedClass(String className) {
        return this.findLoadedClass(className) != null;
    }

    public BootstrapClassLoaderProxy getBootstrapProxy() {
        return this.bootstrapProxy;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    public static final class BootstrapClassLoaderProxy
    extends URLClassLoader {
        public BootstrapClassLoaderProxy(URL[] urls) {
            super(urls, (ClassLoader)null);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

