/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.NoSuchFileException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class InternalJarURLHandler
extends URLStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(InternalJarURLHandler.class);
    private final Map<String, JarEntry> filenameToEntry = new HashMap<String, JarEntry>();
    private JarFile bootstrapJarFile;

    InternalJarURLHandler(String internalJarFileName, URL bootstrapJarLocation) {
        try {
            if (bootstrapJarLocation != null) {
                this.bootstrapJarFile = new JarFile(new File(bootstrapJarLocation.toURI()));
                Enumeration<JarEntry> entries = this.bootstrapJarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().startsWith(internalJarFileName + "/")) continue;
                    this.filenameToEntry.put(entry.getName().substring(internalJarFileName.length()), entry);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("Unable to read internal jar", e);
        }
        if (this.filenameToEntry.isEmpty()) {
            log.warn("Internal jar entries found");
        }
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        byte[] bytes;
        String filename = url.getFile().replaceAll("\\.class$", ".classdata");
        if ("/".equals(filename)) {
            bytes = new byte[]{};
        } else if (this.filenameToEntry.containsKey(filename)) {
            JarEntry entry = this.filenameToEntry.get(filename);
            bytes = InternalJarURLHandler.getBytes(this.bootstrapJarFile.getInputStream(entry));
        } else {
            throw new NoSuchFileException(url.getFile(), null, url.getFile() + " not in internal jar");
        }
        return new InternalJarURLConnection(url, bytes);
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[4096];
        int bytesRead = inputStream.read(buffer, 0, buffer.length);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            while (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer, 0, buffer.length);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    private static class InternalJarURLConnection
    extends URLConnection {
        private final byte[] bytes;

        private InternalJarURLConnection(URL url, byte[] bytes) {
            super(url);
            this.bytes = bytes;
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public Permission getPermission() {
            return null;
        }
    }
}

