/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.decorator.ServerDecorator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public abstract class HttpServerDecorator<REQUEST, CONNECTION, RESPONSE>
extends ServerDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDecorator.class);
    public static final String DD_SPAN_ATTRIBUTE = "datadog.span";
    private static final Pattern VALID_IPV4_ADDRESS = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");

    protected abstract String method(REQUEST var1);

    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    protected abstract String peerHostIP(CONNECTION var1);

    protected abstract Integer peerPort(CONNECTION var1);

    protected abstract Integer status(RESPONSE var1);

    @Override
    protected String spanType() {
        return "web";
    }

    @Override
    protected boolean traceAnalyticsDefault() {
        return Config.get().isTraceAnalyticsEnabled();
    }

    public AgentSpan onRequest(AgentSpan span, REQUEST request) {
        assert (span != null);
        if (request != null) {
            span.setTag("http.method", this.method(request));
            try {
                URI url = this.url(request);
                if (url != null) {
                    String path;
                    StringBuilder urlNoParams = new StringBuilder();
                    if (url.getScheme() != null) {
                        urlNoParams.append(url.getScheme());
                        urlNoParams.append("://");
                    }
                    if (url.getHost() != null) {
                        urlNoParams.append(url.getHost());
                        if (url.getPort() > 0 && url.getPort() != 80 && url.getPort() != 443) {
                            urlNoParams.append(":");
                            urlNoParams.append(url.getPort());
                        }
                    }
                    if ((path = url.getPath()).isEmpty()) {
                        urlNoParams.append("/");
                    } else {
                        urlNoParams.append(path);
                    }
                    span.setTag("http.url", urlNoParams.toString());
                    if (Config.get().isHttpServerTagQueryString()) {
                        span.setTag("http.query.string", url.getQuery());
                        span.setTag("http.fragment.string", url.getFragment());
                    }
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
        }
        return span;
    }

    public AgentSpan onConnection(AgentSpan span, CONNECTION connection) {
        assert (span != null);
        if (connection != null) {
            Integer port;
            String ip = this.peerHostIP(connection);
            if (ip != null) {
                if (VALID_IPV4_ADDRESS.matcher(ip).matches()) {
                    span.setTag("peer.ipv4", ip);
                } else if (ip.contains(":")) {
                    span.setTag("peer.ipv6", ip);
                }
            }
            if ((port = this.peerPort(connection)) != null && port > 0) {
                span.setTag("peer.port", port);
            }
        }
        return span;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        Integer status;
        assert (span != null);
        if (response != null && (status = this.status(response)) != null) {
            span.setTag("http.status_code", status);
            if (Config.get().getHttpServerErrorStatuses().contains(status)) {
                span.setError(true);
            }
        }
        return span;
    }
}

