/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jdbc;

public class DBInfo {
    public static DBInfo DEFAULT = new Builder().type("database").build();
    private final String type;
    private final String subtype;
    private final String url;
    private final String user;
    private final String instance;
    private final String db;
    private final String host;
    private final Integer port;

    DBInfo(String type, String subtype, String url, String user, String instance, String db, String host, Integer port) {
        this.type = type;
        this.subtype = subtype;
        this.url = url;
        this.user = user;
        this.instance = instance;
        this.db = db;
        this.host = host;
        this.port = port;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().type(this.type).subtype(this.subtype).url(this.url).user(this.user).instance(this.instance).db(this.db).host(this.host).port(this.port);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDb() {
        return this.db;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBInfo)) {
            return false;
        }
        DBInfo other = (DBInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$subtype = this.getSubtype();
        String other$subtype = other.getSubtype();
        if (this$subtype == null ? other$subtype != null : !this$subtype.equals(other$subtype)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$instance = this.getInstance();
        String other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
            return false;
        }
        String this$db = this.getDb();
        String other$db = other.getDb();
        if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        return !(this$port == null ? other$port != null : !((Object)this$port).equals(other$port));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $subtype = this.getSubtype();
        result = result * 59 + ($subtype == null ? 43 : $subtype.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
        String $db = this.getDb();
        result = result * 59 + ($db == null ? 43 : $db.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        return result;
    }

    public String toString() {
        return "DBInfo(type=" + this.getType() + ", subtype=" + this.getSubtype() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", instance=" + this.getInstance() + ", db=" + this.getDb() + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    public static class Builder {
        private String type;
        private String subtype;
        private String url;
        private String user;
        private String instance;
        private String db;
        private String host;
        private Integer port;

        Builder() {
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder instance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public DBInfo build() {
            return new DBInfo(this.type, this.subtype, this.url, this.user, this.instance, this.db, this.host, this.port);
        }

        public String toString() {
            return "DBInfo.Builder(type=" + this.type + ", subtype=" + this.subtype + ", url=" + this.url + ", user=" + this.user + ", instance=" + this.instance + ", db=" + this.db + ", host=" + this.host + ", port=" + this.port + ")";
        }
    }
}

