/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.DD128bTraceId;
import datadog.trace.api.DD64bTraceId;
import datadog.trace.api.internal.util.LongStringUtils;

public abstract class DDTraceId {
    public static final DDTraceId ZERO = DDTraceId.from(0L);
    public static final DDTraceId ONE = DDTraceId.from(1L);

    public static DDTraceId from(long id) {
        return DD64bTraceId.from(id);
    }

    public static DDTraceId from(String s) throws NumberFormatException {
        return DD64bTraceId.create(LongStringUtils.parseUnsignedLong(s), s);
    }

    public static DDTraceId fromHex(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("s cannot be null");
        }
        return s.length() > 16 ? DD128bTraceId.fromHex(s) : DD64bTraceId.fromHex(s);
    }

    public abstract String toString();

    public abstract String toHexString();

    public abstract String toHexStringPadded(int var1);

    public abstract long toLong();

    public abstract long toHighOrderLong();
}

