/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EarlyFlakeDetectionSettings {
    public static final EarlyFlakeDetectionSettings DEFAULT = new EarlyFlakeDetectionSettings(false, Collections.emptyList(), -1);
    private final boolean enabled;
    private final List<ExecutionsByDuration> executionsByDuration;
    private final int faultySessionThreshold;

    public EarlyFlakeDetectionSettings(boolean enabled, List<ExecutionsByDuration> executionsByDuration, int faultySessionThreshold) {
        this.enabled = enabled;
        this.executionsByDuration = executionsByDuration;
        this.faultySessionThreshold = faultySessionThreshold;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getFaultySessionThreshold() {
        return this.faultySessionThreshold;
    }

    public List<ExecutionsByDuration> getExecutionsByDuration() {
        return this.executionsByDuration;
    }

    public int getExecutions(long durationMillis) {
        for (ExecutionsByDuration e : this.executionsByDuration) {
            if (durationMillis > e.durationMillis) continue;
            return e.executions;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EarlyFlakeDetectionSettings that = (EarlyFlakeDetectionSettings)o;
        return this.enabled == that.enabled && this.faultySessionThreshold == that.faultySessionThreshold && Objects.equals(this.executionsByDuration, that.executionsByDuration);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.executionsByDuration, this.faultySessionThreshold);
    }

    public static final class ExecutionsByDuration {
        public final long durationMillis;
        public final int executions;

        public ExecutionsByDuration(long durationMillis, int executions) {
            this.durationMillis = durationMillis;
            this.executions = executions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionsByDuration that = (ExecutionsByDuration)o;
            return this.durationMillis == that.durationMillis && this.executions == that.executions;
        }

        public int hashCode() {
            return Objects.hash(this.durationMillis, this.executions);
        }
    }
}

