/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.coverage;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class TestReportFileEntry {
    private final String sourceFileName;
    private final List<Segment> segments;

    public TestReportFileEntry(String sourceFileName, List<Segment> segments) {
        this.sourceFileName = sourceFileName;
        this.segments = segments;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public Collection<Segment> getSegments() {
        return this.segments;
    }

    public String toString() {
        return "TestReportFileEntry{sourceFileName='" + this.sourceFileName + "', lines=[" + this.segments.stream().map(s -> String.valueOf(((Segment)s).startLine)).collect(Collectors.joining(",")) + "]}";
    }

    public static class Segment
    implements Comparable<Segment> {
        private final int startLine;
        private final int startColumn;
        private final int endLine;
        private final int endColumn;
        private final int numberOfExecutions;

        public Segment(int startLine, int startColumn, int endLine, int endColumn, int numberOfExecutions) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.numberOfExecutions = numberOfExecutions;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getStartColumn() {
            return this.startColumn;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getEndColumn() {
            return this.endColumn;
        }

        public int getNumberOfExecutions() {
            return this.numberOfExecutions;
        }

        @Override
        public int compareTo(Segment segment) {
            return this.startLine - segment.startLine;
        }

        public String toString() {
            return "Segment{startLine=" + this.startLine + ", startColumn=" + this.startColumn + ", endLine=" + this.endLine + ", endColumn=" + this.endColumn + ", numberOfExecutions=" + this.numberOfExecutions + '}';
        }
    }
}

