/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.git;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.git.CommitInfo;
import ddtrot.dd.trace.api.git.GitInfo;
import ddtrot.dd.trace.api.git.GitInfoBuilder;
import ddtrot.dd.trace.api.git.GitUtils;
import ddtrot.dd.trace.api.git.PersonInfo;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSuppliedGitInfoBuilder
implements GitInfoBuilder {
    private static final Logger log = LoggerFactory.getLogger(UserSuppliedGitInfoBuilder.class);

    @Override
    public GitInfo build(@Nullable String repositoryPath) {
        String gitCommitCommitterDate;
        String gitCommitCommitterEmail;
        String gitCommitCommitterName;
        String gitCommitAuthorDate;
        String gitCommitAuthorEmail;
        String gitCommitSha;
        String gitRepositoryUrl = System.getenv("DD_GIT_REPOSITORY_URL");
        if (gitRepositoryUrl == null) {
            gitRepositoryUrl = Config.get().getGlobalTags().get("git.repository_url");
        }
        String gitTag = System.getenv("DD_GIT_TAG");
        String gitBranch = null;
        String gitBranchOrTag = System.getenv("DD_GIT_BRANCH");
        if (gitBranchOrTag != null) {
            if (!GitUtils.isTagReference(gitBranchOrTag)) {
                gitBranch = GitUtils.normalizeBranch(gitBranchOrTag);
            } else if (gitTag == null) {
                gitTag = GitUtils.normalizeTag(gitBranchOrTag);
            }
        }
        if ((gitCommitSha = System.getenv("DD_GIT_COMMIT_SHA")) == null) {
            gitCommitSha = Config.get().getGlobalTags().get("git.commit.sha");
        }
        String gitCommitMessage = System.getenv("DD_GIT_COMMIT_MESSAGE");
        String gitCommitAuthorName = System.getenv("DD_GIT_COMMIT_AUTHOR_NAME");
        GitInfo gitInfo = new GitInfo(gitRepositoryUrl, gitBranch, gitTag, new CommitInfo(gitCommitSha, new PersonInfo(gitCommitAuthorName, gitCommitAuthorEmail = System.getenv("DD_GIT_COMMIT_AUTHOR_EMAIL"), gitCommitAuthorDate = System.getenv("DD_GIT_COMMIT_AUTHOR_DATE")), new PersonInfo(gitCommitCommitterName = System.getenv("DD_GIT_COMMIT_COMMITTER_NAME"), gitCommitCommitterEmail = System.getenv("DD_GIT_COMMIT_COMMITTER_EMAIL"), gitCommitCommitterDate = System.getenv("DD_GIT_COMMIT_COMMITTER_DATE")), gitCommitMessage));
        if (!gitInfo.isEmpty()) {
            String commitSha;
            String repoUrl = gitInfo.getRepositoryURL();
            if (repoUrl == null || repoUrl.isEmpty()) {
                log.error("Could not resolve git repository URL (can be provided via DD_GIT_REPOSITORY_URL env var, tags config property or by embedding git metadata at build time)");
            }
            if (!GitUtils.isValidCommitSha(commitSha = gitInfo.getCommit().getSha())) {
                log.error("Git commit SHA could not be resolved or is invalid: " + commitSha + " (can be provided via " + "DD_GIT_COMMIT_SHA" + " env var, " + "tags" + " config property or by embedding git metadata at build time; must be a full-length SHA_");
            }
        }
        return gitInfo;
    }

    @Override
    public int order() {
        return 0;
    }
}

