/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.dd.trace.common.writer.PayloadDispatcher;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.TraceProcessingWorker;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(RemoteWriter.class);
    protected final TraceProcessingWorker traceProcessingWorker;
    private final PayloadDispatcher dispatcher;
    private final boolean alwaysFlush;
    private final int flushTimeout;
    private final TimeUnit flushTimeoutUnit;
    private volatile boolean closed;
    public final HealthMetrics healthMetrics;

    protected RemoteWriter(TraceProcessingWorker traceProcessingWorker, PayloadDispatcher dispatcher, HealthMetrics healthMetrics, int flushTimeout, TimeUnit flushTimeoutUnit, boolean alwaysFlush) {
        this.traceProcessingWorker = traceProcessingWorker;
        this.dispatcher = dispatcher;
        this.healthMetrics = healthMetrics;
        this.flushTimeout = flushTimeout;
        this.flushTimeoutUnit = flushTimeoutUnit;
        this.alwaysFlush = alwaysFlush;
    }

    protected RemoteWriter(TraceProcessingWorker traceProcessingWorker, PayloadDispatcher dispatcher, HealthMetrics healthMetrics, boolean alwaysFlush) {
        this(traceProcessingWorker, dispatcher, healthMetrics, 1, TimeUnit.SECONDS, alwaysFlush);
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (!this.closed) {
            if (trace.isEmpty()) {
                this.handleDroppedTrace("Trace was empty", trace, -128);
            } else {
                DDSpan root = trace.get(0);
                int samplingPriority = root.samplingPriority();
                switch (this.traceProcessingWorker.publish(root, samplingPriority, trace)) {
                    case ENQUEUED_FOR_SERIALIZATION: {
                        log.debug("Enqueued for serialization: {}", trace);
                        this.healthMetrics.onPublish(trace, samplingPriority);
                        break;
                    }
                    case ENQUEUED_FOR_SINGLE_SPAN_SAMPLING: {
                        log.debug("Enqueued for single span sampling: {}", trace);
                        break;
                    }
                    case DROPPED_BY_POLICY: {
                        this.handleDroppedTrace("Dropping policy is active", trace, samplingPriority);
                        break;
                    }
                    case DROPPED_BUFFER_OVERFLOW: {
                        this.handleDroppedTrace("Trace written to overfilled buffer", trace, samplingPriority);
                    }
                }
            }
        } else {
            this.handleDroppedTrace("Trace written after shutdown.", trace, -128);
        }
        if (this.alwaysFlush) {
            this.flush();
        }
    }

    private void handleDroppedTrace(String reason, List<DDSpan> trace, int samplingPriority) {
        log.debug("{}. Counted but dropping trace: {}", (Object)reason, trace);
        this.healthMetrics.onFailedPublish(trace.isEmpty() ? 0 : trace.get(0).samplingPriority(), trace.size());
        this.incrementDropCounts(trace.size());
    }

    public final long getCapacity() {
        return this.traceProcessingWorker.getCapacity();
    }

    @Override
    public boolean flush() {
        if (!this.closed && this.traceProcessingWorker.flush(this.flushTimeout, this.flushTimeoutUnit)) {
            this.healthMetrics.onFlush(false);
            return true;
        }
        return false;
    }

    @Override
    public void start() {
        if (!this.closed) {
            this.traceProcessingWorker.start();
            this.healthMetrics.start();
            this.healthMetrics.onStart((int)this.getCapacity());
        }
    }

    @Override
    public void close() {
        boolean flushed = this.flush();
        this.closed = true;
        this.traceProcessingWorker.close();
        this.healthMetrics.onShutdown(flushed);
        this.healthMetrics.close();
    }

    @Override
    public void incrementDropCounts(int spanCount) {
        this.dispatcher.onDroppedTrace(spanCount);
    }

    public Collection<RemoteApi> getApis() {
        return this.dispatcher.getApis();
    }
}

