/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddagent;

import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.serialization.Codec;
import ddtrot.dd.communication.serialization.GrowableBuffer;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.communication.serialization.msgpack.MsgPackWriter;
import ddtrot.dd.trace.bootstrap.instrumentation.api.InstrumentationTags;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteMapper;
import ddtrot.dd.trace.common.writer.ddagent.TraceMapper;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.Metadata;
import ddtrot.dd.trace.core.MetadataConsumer;
import ddtrot.dd.trace.core.PendingTrace;
import ddtrot.okhttp3.RequestBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class TraceMapperV0_4
implements TraceMapper {
    private final int size;
    private final MetaWriter metaWriter = new MetaWriter();
    private final MetaStructWriter metaStructWriter = new MetaStructWriter();

    public TraceMapperV0_4(int size) {
        this.size = size;
    }

    public TraceMapperV0_4() {
        this(0x500000);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        writable.startArray(trace.size());
        for (int i = 0; i < trace.size(); ++i) {
            CoreSpan<?> span = trace.get(i);
            Map<String, Object> metaStruct = span.getMetaStruct();
            writable.startMap(metaStruct.isEmpty() ? 12 : 13);
            writable.writeUTF8(SERVICE);
            writable.writeString(span.getServiceName(), null);
            writable.writeUTF8(NAME);
            writable.writeObject(span.getOperationName(), null);
            writable.writeUTF8(RESOURCE);
            writable.writeObject(span.getResourceName(), null);
            writable.writeUTF8(TRACE_ID);
            writable.writeUnsignedLong(span.getTraceId().toLong());
            writable.writeUTF8(SPAN_ID);
            writable.writeUnsignedLong(span.getSpanId());
            writable.writeUTF8(PARENT_ID);
            writable.writeUnsignedLong(span.getParentId());
            writable.writeUTF8(START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeLong(PendingTrace.getDurationNano(span));
            writable.writeUTF8(TYPE);
            writable.writeString(span.getType(), null);
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable).withWriteSamplingPriority(i == 0 || i == trace.size() - 1));
            if (metaStruct.isEmpty()) continue;
            this.metaStructWriter.withWritable(writable).write(metaStruct);
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_4();
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
    }

    @Override
    public String endpoint() {
        return "v0.4";
    }

    private static class PayloadV0_4
    extends Payload {
        private PayloadV0_4() {
        }

        @Override
        public int sizeInBytes() {
            return this.msgpackArrayHeaderSize(this.traceCount()) + this.body.remaining();
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            ByteBuffer header = this.msgpackArrayHeader(this.traceCount());
            while (header.hasRemaining()) {
                channel.write(header);
            }
            while (this.body.hasRemaining()) {
                channel.write(this.body);
            }
        }

        @Override
        public RequestBody toRequest() {
            return OkHttpUtils.msgpackRequestBodyOf(Arrays.asList(this.msgpackArrayHeader(this.traceCount()), this.body));
        }
    }

    public static class MetaStructWriter {
        private static final UTF8BytesString META_STRUCT = UTF8BytesString.create("meta_struct");
        private static final int BUFFER_SIZE = 1024;
        private Writable writable;

        MetaStructWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        public void write(Map<String, Object> metaStruct) {
            this.writable.writeUTF8(META_STRUCT);
            this.writable.startMap(metaStruct.size());
            GrowableBuffer buffer = new GrowableBuffer(1024);
            MsgPackWriter metaStructWriter = new MsgPackWriter(Codec.INSTANCE, buffer);
            for (Map.Entry<String, Object> entry : metaStruct.entrySet()) {
                this.writeMetaStructEntry(metaStructWriter, buffer, entry.getKey(), entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeMetaStructEntry(MsgPackWriter writer, GrowableBuffer buffer, String key, Object value) {
            buffer.mark();
            try {
                writer.writeObject(value, null);
                writer.flush();
                this.writable.writeString(key, null);
                this.writable.writeBinary(buffer.slice());
            }
            finally {
                buffer.reset();
            }
        }
    }

    private static final class MetaWriter
    implements MetadataConsumer {
        private Writable writable;
        private boolean writeSamplingPriority;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        MetaWriter withWriteSamplingPriority(boolean writeSamplingPriority) {
            this.writeSamplingPriority = writeSamplingPriority;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int metaSize = metadata.getBaggage().size() + metadata.getTags().size() + (null == metadata.getHttpStatusCode() ? 0 : 1) + (null == metadata.getOrigin() ? 0 : 1) + 1;
            int metricsSize = (this.writeSamplingPriority && metadata.hasSamplingPriority() ? 1 : 0) + (metadata.measured() ? 1 : 0) + (metadata.topLevel() ? 1 : 0) + (metadata.longRunningVersion() != 0 ? 1 : 0) + 1;
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Number) {
                    ++metricsSize;
                    --metaSize;
                    continue;
                }
                if (!(value instanceof Map)) continue;
                --metaSize;
                metaSize += this.getFlatMapSize((Map)value);
            }
            this.writable.writeUTF8(RemoteMapper.METRICS);
            this.writable.startMap(metricsSize);
            if (this.writeSamplingPriority && metadata.hasSamplingPriority()) {
                this.writable.writeUTF8(TraceMapper.SAMPLING_PRIORITY_KEY);
                this.writable.writeInt(metadata.samplingPriority());
            }
            if (metadata.measured()) {
                this.writable.writeUTF8(InstrumentationTags.DD_MEASURED);
                this.writable.writeInt(1);
            }
            if (metadata.topLevel()) {
                this.writable.writeUTF8(InstrumentationTags.DD_TOP_LEVEL);
                this.writable.writeInt(1);
            }
            if (metadata.longRunningVersion() != 0) {
                if (metadata.longRunningVersion() > 0) {
                    this.writable.writeUTF8(InstrumentationTags.DD_PARTIAL_VERSION);
                    this.writable.writeInt(metadata.longRunningVersion());
                } else {
                    this.writable.writeUTF8(InstrumentationTags.DD_WAS_LONG_RUNNING);
                    this.writable.writeInt(1);
                }
            }
            this.writable.writeUTF8(TraceMapper.THREAD_ID);
            this.writable.writeLong(metadata.getThreadId());
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObject(entry.getValue(), null);
            }
            this.writable.writeUTF8(RemoteMapper.META);
            this.writable.startMap(metaSize);
            for (Map.Entry<String, Object> entry : metadata.getBaggage().entrySet()) {
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeString((CharSequence)entry.getValue(), null);
            }
            this.writable.writeUTF8(TraceMapper.THREAD_NAME);
            this.writable.writeUTF8(metadata.getThreadName());
            if (null != metadata.getHttpStatusCode()) {
                this.writable.writeUTF8(RemoteMapper.HTTP_STATUS);
                this.writable.writeUTF8(metadata.getHttpStatusCode());
            }
            if (null != metadata.getOrigin()) {
                this.writable.writeUTF8(TraceMapper.ORIGIN_KEY);
                this.writable.writeString(metadata.getOrigin(), null);
            }
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    this.writeFlatMap(key, (Map)value);
                    continue;
                }
                if (value instanceof Number) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObjectString(entry.getValue(), null);
            }
        }

        private int getFlatMapSize(Map<String, Object> map) {
            int size = 0;
            for (Object value : map.values()) {
                if (value instanceof Map) {
                    size += this.getFlatMapSize((Map)value);
                    continue;
                }
                ++size;
            }
            return size;
        }

        private void writeFlatMap(String key, Map<String, Object> mapValue) {
            for (Map.Entry<String, Object> entry : mapValue.entrySet()) {
                String newKey = key + '.' + entry.getKey();
                Object newValue = entry.getValue();
                if (newValue instanceof Map) {
                    this.writeFlatMap(newKey, (Map)newValue);
                    continue;
                }
                this.writable.writeString(newKey, null);
                this.writable.writeObjectString(newValue, null);
            }
        }
    }
}

