/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.naming.NamingSchema;
import ddtrot.dd.trace.api.naming.SpanNaming;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import java.util.Map;
import javax.annotation.Nonnull;

public class PeerServiceCalculator
implements TagsPostProcessor {
    private final NamingSchema.ForPeerService peerServiceNaming;
    private final Map<String, String> peerServiceMapping;
    private final boolean canRemap;

    public PeerServiceCalculator() {
        this(SpanNaming.instance().namingSchema().peerService(), Config.get().getPeerServiceMapping());
    }

    PeerServiceCalculator(@Nonnull NamingSchema.ForPeerService peerServiceNaming, @Nonnull Map<String, String> peerServiceMapping) {
        this.peerServiceNaming = peerServiceNaming;
        this.peerServiceMapping = peerServiceMapping;
        this.canRemap = !peerServiceMapping.isEmpty();
    }

    @Override
    public Map<String, Object> processTags(Map<String, Object> unsafeTags, DDSpanContext spanContext) {
        Object peerService = unsafeTags.get("peer.service");
        if (peerService != null) {
            if (this.canRemap) {
                return this.remapPeerService(unsafeTags, peerService);
            }
        } else if (this.peerServiceNaming.supports()) {
            this.peerServiceNaming.tags(unsafeTags);
            return this.remapPeerService(unsafeTags, this.canRemap ? unsafeTags.get("peer.service") : null);
        }
        return unsafeTags;
    }

    private Map<String, Object> remapPeerService(Map<String, Object> unsafeTags, Object value) {
        String mapped;
        if (value != null && (mapped = this.peerServiceMapping.get(value)) != null) {
            unsafeTags.put("peer.service", mapped);
            unsafeTags.put("_dd.peer.service.remapped_from", value);
        }
        return unsafeTags;
    }
}

