/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.util.Matcher;
import ddtrot.dd.trace.core.util.Matchers;
import java.util.HashMap;
import java.util.Map;

public final class TagsMatcher {
    private final Map<String, Matcher> matchers;

    public static TagsMatcher create(Map<String, String> tags) {
        HashMap<String, Matcher> matchers = new HashMap<String, Matcher>(tags.size());
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String tag = entry.getKey();
            String glob = entry.getValue();
            matchers.put(tag, Matchers.compileGlob(glob));
        }
        return new TagsMatcher(matchers);
    }

    public TagsMatcher(Map<String, Matcher> matchers) {
        this.matchers = matchers;
    }

    public <T extends CoreSpan<T>> boolean matches(T span) {
        for (Map.Entry<String, Matcher> entry : this.matchers.entrySet()) {
            String tag = entry.getKey();
            Matcher matcher = entry.getValue();
            Object value = span.getTag(tag);
            if (value != null && matcher.matches(value)) continue;
            return false;
        }
        return true;
    }
}

