/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public abstract class UnsafeUtils {
    private static final Logger log = LoggerFactory.getLogger(UnsafeUtils.class);
    private static final Unsafe UNSAFE = UnsafeUtils.getUnsafe();

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Throwable t) {
            log.debug("Unsafe is unavailable", t);
            return null;
        }
    }

    public static <T> T tryShallowClone(T original) {
        if (UNSAFE == null) {
            log.debug("Unsafe is unavailable, {} will not be cloned", original);
            return original;
        }
        try {
            Class<?> clazz;
            Object clone = UNSAFE.allocateInstance(clazz);
            for (clazz = original.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                UnsafeUtils.cloneFields(clazz, original, clone);
            }
            return (T)clone;
        }
        catch (Throwable t) {
            log.debug("Error while cloning {}: {}", original, (Object)t);
            return original;
        }
    }

    private static void cloneFields(Class<?> clazz, Object original, Object clone) throws Exception {
        for (Field field : clazz.getDeclaredFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            field.setAccessible(true);
            Object fieldValue = field.get(original);
            field.set(clone, fieldValue);
        }
    }
}

