/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider;

import datadog.trace.api.ConfigOrigin;
import ddtrot.dd.trace.bootstrap.config.provider.ConfigProvider;
import ddtrot.dd.trace.util.Strings;
import java.util.Properties;

final class PropertiesConfigSource
extends ConfigProvider.Source {
    static final String CONFIG_FILE_STATUS = "_dd.config.file.status";
    private final Properties props;
    private final boolean useSystemPropertyFormat;

    public PropertiesConfigSource(Properties props, boolean useSystemPropertyFormat) {
        assert (props != null);
        this.props = props;
        this.useSystemPropertyFormat = useSystemPropertyFormat;
    }

    public String getConfigFileStatus() {
        return this.props.getProperty(CONFIG_FILE_STATUS);
    }

    @Override
    protected String get(String key) {
        return this.props.getProperty(this.useSystemPropertyFormat ? Strings.propertyNameToSystemPropertyName(key) : key);
    }

    @Override
    public ConfigOrigin origin() {
        return ConfigOrigin.JVM_PROP;
    }
}

