/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import ddtrot.dd.trace.common.sampling.PrioritySampler;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.core.CoreSpan;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsmStandaloneSampler
implements Sampler,
PrioritySampler {
    private static final Logger log = LoggerFactory.getLogger(AsmStandaloneSampler.class);
    private static final int RATE_IN_MILLISECONDS = 60000;
    private final AtomicLong lastSampleTime;
    private final Clock clock;

    public AsmStandaloneSampler(Clock clock) {
        this.clock = clock;
        this.lastSampleTime = new AtomicLong(clock.millis() - 60000L);
    }

    @Override
    public <T extends CoreSpan<T>> boolean sample(T span) {
        return true;
    }

    @Override
    public <T extends CoreSpan<T>> void setSamplingPriority(T span) {
        if (this.shouldSample()) {
            log.debug("Set SAMPLER_KEEP for span {}", (Object)span.getSpanId());
            span.setSamplingPriority(1, 5);
        } else {
            log.debug("Set SAMPLER_DROP for span {}", (Object)span.getSpanId());
            span.setSamplingPriority(0, 5);
        }
    }

    private boolean shouldSample() {
        long now = this.clock.millis();
        return this.lastSampleTime.updateAndGet(lastTime -> now - lastTime >= 60000L ? now : lastTime) == now;
    }
}

