/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.common.sampling.DeterministicSampler;
import ddtrot.dd.trace.common.sampling.PrioritySampler;
import ddtrot.dd.trace.common.sampling.RateSampler;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.common.writer.RemoteResponseListener;
import ddtrot.dd.trace.core.CoreSpan;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateByServiceTraceSampler
implements Sampler,
PrioritySampler,
RemoteResponseListener {
    private static final Logger log = LoggerFactory.getLogger(RateByServiceTraceSampler.class);
    public static final String SAMPLING_AGENT_RATE = "_dd.agent_psr";
    private static final double DEFAULT_RATE = 1.0;
    private volatile RateSamplersByEnvAndService serviceRates = new RateSamplersByEnvAndService();

    @Override
    public <T extends CoreSpan<T>> boolean sample(T span) {
        return true;
    }

    @Override
    public <T extends CoreSpan<T>> void setSamplingPriority(T span) {
        String serviceName = span.getServiceName();
        RateSamplersByEnvAndService rates = this.serviceRates;
        String env = this.getSpanEnv(span);
        RateSampler sampler = rates.getSampler(env, serviceName);
        if (sampler.sample(span)) {
            span.setSamplingPriority(1, SAMPLING_AGENT_RATE, sampler.getSampleRate(), 1);
        } else {
            span.setSamplingPriority(0, SAMPLING_AGENT_RATE, sampler.getSampleRate(), 1);
        }
    }

    private <T extends CoreSpan<T>> String getSpanEnv(T span) {
        return span.getTag("env", (String)"");
    }

    @Override
    public void onResponse(String endpoint, Map<String, Map<String, Number>> responseJson) {
        Map<String, Number> newServiceRates = responseJson.get("rate_by_service");
        if (null == newServiceRates) {
            return;
        }
        log.debug("Update service sampler rates: {} -> {}", (Object)endpoint, responseJson);
        HashMap<String, Map<String, RateSampler>> updatedEnvServiceRates = new HashMap<String, Map<String, RateSampler>>(newServiceRates.size() * 2);
        RateSampler fallbackSampler = RateSamplersByEnvAndService.DEFAULT_SAMPLER;
        for (Map.Entry<String, Number> entry : newServiceRates.entrySet()) {
            if (entry.getValue() == null) continue;
            double rate = entry.getValue().doubleValue();
            EnvAndService envAndService = EnvAndService.fromString(entry.getKey());
            if (envAndService.isFallback()) {
                fallbackSampler = RateByServiceTraceSampler.createRateSampler(rate);
                continue;
            }
            Map serviceRates = updatedEnvServiceRates.computeIfAbsent(envAndService.lowerEnv, env -> new HashMap(newServiceRates.size() * 2));
            serviceRates.computeIfAbsent(envAndService.lowerService, service -> RateByServiceTraceSampler.createRateSampler(rate));
        }
        this.serviceRates = new RateSamplersByEnvAndService(updatedEnvServiceRates, fallbackSampler);
    }

    private static RateSampler createRateSampler(double sampleRate) {
        double sanitizedRate;
        if (sampleRate < 0.0) {
            log.error("SampleRate is negative or null, disabling the sampler");
            sanitizedRate = 1.0;
        } else {
            sanitizedRate = sampleRate > 1.0 ? 1.0 : sampleRate;
        }
        return new DeterministicSampler.TraceSampler(sanitizedRate);
    }

    static /* synthetic */ RateSampler access$300(double x0) {
        return RateByServiceTraceSampler.createRateSampler(x0);
    }

    private static final class EnvAndService {
        private static final DDCache<String, EnvAndService> CACHE = DDCaches.newFixedSizeCache(32);
        private static final Function<String, EnvAndService> PARSE = new Function<String, EnvAndService>(){

            @Override
            public EnvAndService apply(String key) {
                int serviceStart = key.indexOf(58) + 1;
                int serviceEnd = key.indexOf(44, serviceStart);
                int envStart = key.indexOf(58, serviceEnd) + 1;
                int envEnd = key.length();
                if (serviceStart == serviceEnd && envStart == envEnd || (serviceStart | serviceEnd | envStart) < 0) {
                    return FALLBACK;
                }
                String service = key.substring(serviceStart, serviceEnd);
                String env = key.substring(envStart);
                return new EnvAndService(env, service);
            }
        };
        static final EnvAndService FALLBACK = new EnvAndService("", "");
        private final String lowerEnv;
        private final String lowerService;

        public static EnvAndService fromString(String key) {
            return CACHE.computeIfAbsent(key, PARSE);
        }

        private EnvAndService(String env, String service) {
            this.lowerEnv = env.toLowerCase();
            this.lowerService = service.toLowerCase();
        }

        boolean isFallback() {
            return EnvAndService.isFallback(this.lowerEnv, this.lowerService);
        }

        private static final boolean isFallback(String env, String service) {
            return env.isEmpty() && service.isEmpty();
        }
    }

    private static final class RateSamplersByEnvAndService {
        private static final RateSampler DEFAULT_SAMPLER = RateByServiceTraceSampler.access$300(1.0);
        private final Map<String, Map<String, RateSampler>> envServiceRates;
        private final RateSampler fallbackSampler;

        RateSamplersByEnvAndService() {
            this(new HashMap<String, Map<String, RateSampler>>(0), DEFAULT_SAMPLER);
        }

        RateSamplersByEnvAndService(Map<String, Map<String, RateSampler>> envServiceRates, RateSampler fallbackSampler) {
            this.envServiceRates = envServiceRates;
            this.fallbackSampler = fallbackSampler;
        }

        RateSampler getSampler(EnvAndService envAndService) {
            return this.getSamplerImpl(envAndService.lowerEnv, envAndService.lowerService);
        }

        public RateSampler getSampler(String env, String service) {
            return this.getSamplerImpl(env.toLowerCase(), service.toLowerCase());
        }

        private RateSampler getSamplerImpl(String lowerEnv, String lowerService) {
            if (EnvAndService.isFallback(lowerEnv, lowerService)) {
                return this.fallbackSampler;
            }
            Map<String, RateSampler> serviceRates = this.envServiceRates.get(lowerEnv);
            if (serviceRates == null) {
                return this.fallbackSampler;
            }
            RateSampler sampler = serviceRates.get(lowerService);
            return null == sampler ? this.fallbackSampler : sampler;
        }
    }
}

