/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import datadog.trace.api.Platform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionUtils {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle IMMUTABLE_COPY_OF_SET = CollectionUtils.findCopyOf(Set.class, Collection.class);
    private static final MethodHandle IMMUTABLE_COPY_OF_LIST = CollectionUtils.findCopyOf(List.class, Collection.class);
    private static final MethodHandle IMMUTABLE_COPY_OF_MAP = CollectionUtils.findCopyOf(Map.class, Map.class);

    public static <T> Set<T> tryMakeImmutableSet(Collection<T> input) {
        if (null != IMMUTABLE_COPY_OF_SET) {
            try {
                return IMMUTABLE_COPY_OF_SET.invokeExact(input);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return input instanceof Set ? (Set<Object>)input : new HashSet<T>(input);
    }

    public static <T> List<T> tryMakeImmutableList(Collection<T> input) {
        if (null != IMMUTABLE_COPY_OF_LIST) {
            try {
                return IMMUTABLE_COPY_OF_LIST.invokeExact(input);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return input instanceof List ? (List<Object>)input : new ArrayList<T>(input);
    }

    public static <K, V> Map<K, V> tryMakeImmutableMap(Map<K, V> input) {
        if (null != IMMUTABLE_COPY_OF_MAP) {
            try {
                return IMMUTABLE_COPY_OF_MAP.invokeExact(input);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return input;
    }

    private static MethodHandle findCopyOf(Class<?> clazz, Class<?> arg) {
        if (Platform.isJavaVersionAtLeast(10)) {
            try {
                return LOOKUP.findStatic(clazz, "copyOf", MethodType.methodType(clazz, arg));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }
}

