/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.jnr.constants.platform.solaris;

import ddtrot.jnr.constants.Constant;
import java.util.EnumMap;
import java.util.Map;

public enum Errno implements Constant
{
    EPERM(1L),
    ENOENT(2L),
    ESRCH(3L),
    EINTR(4L),
    EIO(5L),
    ENXIO(6L),
    E2BIG(7L),
    ENOEXEC(8L),
    EBADF(9L),
    ECHILD(10L),
    EDEADLK(45L),
    ENOMEM(12L),
    EACCES(13L),
    EFAULT(14L),
    ENOTBLK(15L),
    EBUSY(16L),
    EEXIST(17L),
    EXDEV(18L),
    ENODEV(19L),
    ENOTDIR(20L),
    EISDIR(21L),
    EINVAL(22L),
    ENFILE(23L),
    EMFILE(24L),
    ENOTTY(25L),
    ETXTBSY(26L),
    EFBIG(27L),
    ENOSPC(28L),
    ESPIPE(29L),
    EROFS(30L),
    EMLINK(31L),
    EPIPE(32L),
    EDOM(33L),
    ERANGE(34L),
    EWOULDBLOCK(11L),
    EAGAIN(11L),
    EINPROGRESS(150L),
    EALREADY(149L),
    ENOTSOCK(95L),
    EDESTADDRREQ(96L),
    EMSGSIZE(97L),
    EPROTOTYPE(98L),
    ENOPROTOOPT(99L),
    EPROTONOSUPPORT(120L),
    ESOCKTNOSUPPORT(121L),
    EOPNOTSUPP(122L),
    EPFNOSUPPORT(123L),
    EAFNOSUPPORT(124L),
    EADDRINUSE(125L),
    EADDRNOTAVAIL(126L),
    ENETDOWN(127L),
    ENETUNREACH(128L),
    ENETRESET(129L),
    ECONNABORTED(130L),
    ECONNRESET(131L),
    ENOBUFS(132L),
    EISCONN(133L),
    ENOTCONN(134L),
    ESHUTDOWN(143L),
    ETOOMANYREFS(144L),
    ETIMEDOUT(145L),
    ECONNREFUSED(146L),
    ELOOP(90L),
    ENAMETOOLONG(78L),
    EHOSTDOWN(147L),
    EHOSTUNREACH(148L),
    ENOTEMPTY(93L),
    EUSERS(94L),
    EDQUOT(49L),
    ESTALE(151L),
    EREMOTE(66L),
    ENOLCK(46L),
    ENOSYS(89L),
    EOVERFLOW(79L),
    EIDRM(36L),
    ENOMSG(35L),
    EILSEQ(88L),
    EBADMSG(77L),
    EMULTIHOP(74L),
    ENODATA(61L),
    ENOLINK(67L),
    ENOSR(63L),
    ENOSTR(60L),
    EPROTO(71L),
    ETIME(62L),
    ECHRNG(37L),
    EL2NSYNC(38L),
    EL3HLT(39L),
    EL3RST(40L),
    ELNRNG(41L),
    EUNATCH(42L),
    ENOCSI(43L),
    EL2HLT(44L),
    EBADE(50L),
    EBADR(51L),
    EXFULL(52L),
    ENOANO(53L),
    EBADRQC(54L),
    EBADSLT(55L),
    EDEADLOCK(56L),
    EBFONT(57L),
    ENONET(64L),
    ENOPKG(65L),
    EADV(68L),
    ESRMNT(69L),
    ECOMM(70L),
    ENOTUNIQ(80L),
    EBADFD(81L),
    EREMCHG(82L),
    ELIBACC(83L),
    ELIBBAD(84L),
    ELIBSCN(85L),
    ELIBMAX(86L),
    ELIBEXEC(87L),
    ERESTART(91L),
    ESTRPIPE(92L),
    ECANCELED(47L),
    ENOTRECOVERABLE(59L),
    EOWNERDEAD(58L),
    ENOTSUP(48L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 151L;

    private Errno(long value) {
        this.value = value;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map = new EnumMap<Errno, String>(Errno.class);
            map.put(EPERM, "Not owner");
            map.put(ENOENT, "No such file or directory");
            map.put(ESRCH, "No such process");
            map.put(EINTR, "Interrupted system call");
            map.put(EIO, "I/O error");
            map.put(ENXIO, "No such device or address");
            map.put(E2BIG, "Arg list too long");
            map.put(ENOEXEC, "Exec format error");
            map.put(EBADF, "Bad file number");
            map.put(ECHILD, "No child processes");
            map.put(EDEADLK, "Deadlock situation detected/avoided");
            map.put(ENOMEM, "Not enough space");
            map.put(EACCES, "Permission denied");
            map.put(EFAULT, "Bad address");
            map.put(ENOTBLK, "Block device required");
            map.put(EBUSY, "Device busy");
            map.put(EEXIST, "File exists");
            map.put(EXDEV, "Cross-device link");
            map.put(ENODEV, "No such device");
            map.put(ENOTDIR, "Not a directory");
            map.put(EISDIR, "Is a directory");
            map.put(EINVAL, "Invalid argument");
            map.put(ENFILE, "File table overflow");
            map.put(EMFILE, "Too many open files");
            map.put(ENOTTY, "Inappropriate ioctl for device");
            map.put(ETXTBSY, "Text file busy");
            map.put(EFBIG, "File too large");
            map.put(ENOSPC, "No space left on device");
            map.put(ESPIPE, "Illegal seek");
            map.put(EROFS, "Read-only file system");
            map.put(EMLINK, "Too many links");
            map.put(EPIPE, "Broken pipe");
            map.put(EDOM, "Argument out of domain");
            map.put(ERANGE, "Result too large");
            map.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map.put(EAGAIN, "Resource temporarily unavailable");
            map.put(EINPROGRESS, "Operation now in progress");
            map.put(EALREADY, "Operation already in progress");
            map.put(ENOTSOCK, "Socket operation on non-socket");
            map.put(EDESTADDRREQ, "Destination address required");
            map.put(EMSGSIZE, "Message too long");
            map.put(EPROTOTYPE, "Protocol wrong type for socket");
            map.put(ENOPROTOOPT, "Option not supported by protocol");
            map.put(EPROTONOSUPPORT, "Protocol not supported");
            map.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map.put(EOPNOTSUPP, "Operation not supported on transport endpoint");
            map.put(EPFNOSUPPORT, "Protocol family not supported");
            map.put(EAFNOSUPPORT, "Address family not supported by protocol family");
            map.put(EADDRINUSE, "Address already in use");
            map.put(EADDRNOTAVAIL, "Cannot assign requested address");
            map.put(ENETDOWN, "Network is down");
            map.put(ENETUNREACH, "Network is unreachable");
            map.put(ENETRESET, "Network dropped connection because of reset");
            map.put(ECONNABORTED, "Software caused connection abort");
            map.put(ECONNRESET, "Connection reset by peer");
            map.put(ENOBUFS, "No buffer space available");
            map.put(EISCONN, "Transport endpoint is already connected");
            map.put(ENOTCONN, "Transport endpoint is not connected");
            map.put(ESHUTDOWN, "Cannot send after socket shutdown");
            map.put(ETOOMANYREFS, "Too many references: cannot splice");
            map.put(ETIMEDOUT, "Connection timed out");
            map.put(ECONNREFUSED, "Connection refused");
            map.put(ELOOP, "Number of symbolic links encountered during path name traversal exceeds MAXSYMLINKS");
            map.put(ENAMETOOLONG, "File name too long");
            map.put(EHOSTDOWN, "Host is down");
            map.put(EHOSTUNREACH, "No route to host");
            map.put(ENOTEMPTY, "Directory not empty");
            map.put(EUSERS, "Too many users");
            map.put(EDQUOT, "Disc quota exceeded");
            map.put(ESTALE, "Stale NFS file handle");
            map.put(EREMOTE, "Object is remote");
            map.put(ENOLCK, "No record locks available");
            map.put(ENOSYS, "Operation not applicable");
            map.put(EOVERFLOW, "Value too large for defined data type");
            map.put(EIDRM, "Identifier removed");
            map.put(ENOMSG, "No message of desired type");
            map.put(EILSEQ, "Illegal byte sequence");
            map.put(EBADMSG, "Not a data message");
            map.put(EMULTIHOP, "Multihop attempted");
            map.put(ENODATA, "No data available");
            map.put(ENOLINK, "Link has been severed");
            map.put(ENOSR, "Out of stream resources");
            map.put(ENOSTR, "Not a stream device");
            map.put(EPROTO, "Protocol error");
            map.put(ETIME, "Timer expired");
            map.put(ECHRNG, "Channel number out of range");
            map.put(EL2NSYNC, "Level 2 not synchronized");
            map.put(EL3HLT, "Level 3 halted");
            map.put(EL3RST, "Level 3 reset");
            map.put(ELNRNG, "Link number out of range");
            map.put(EUNATCH, "Protocol driver not attached");
            map.put(ENOCSI, "No CSI structure available");
            map.put(EL2HLT, "Level 2 halted");
            map.put(EBADE, "Checksum failure");
            map.put(EBADR, "Too fragmented");
            map.put(EXFULL, "Message tables full");
            map.put(ENOANO, "Cryptographic key not available");
            map.put(EBADRQC, "Bad request code");
            map.put(EBADSLT, "Invalid slot");
            map.put(EDEADLOCK, "File locking deadlock");
            map.put(EBFONT, "Bad font file format");
            map.put(ENONET, "Machine is not on the network");
            map.put(ENOPKG, "Package not installed");
            map.put(EADV, "Advertise error");
            map.put(ESRMNT, "Srmount error");
            map.put(ECOMM, "Communication error on send");
            map.put(ENOTUNIQ, "Name not unique on network");
            map.put(EBADFD, "File descriptor in bad state");
            map.put(EREMCHG, "Remote address changed");
            map.put(ELIBACC, "Can not access a needed shared library");
            map.put(ELIBBAD, "Accessing a corrupted shared library");
            map.put(ELIBSCN, ".lib section in a.out corrupted");
            map.put(ELIBMAX, "Attempting to link in more shared libraries than system limit");
            map.put(ELIBEXEC, "Can not exec a shared library directly");
            map.put(ERESTART, "Error 91");
            map.put(ESTRPIPE, "Error 92");
            map.put(ECANCELED, "Operation canceled");
            map.put(ENOTRECOVERABLE, "Lock is not recoverable");
            map.put(EOWNERDEAD, "Owner of the lock died");
            map.put(ENOTSUP, "Operation not supported");
            return map;
        }
    }
}

