/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.spark.connector.cql.MultipleRetryPolicy$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00015\u00111#T;mi&\u0004H.\u001a*fiJL\bk\u001c7jGfT!a\u0001\u0003\u0002\u0007\r\fHN\u0003\u0002\u0006\r\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u0011\u0011\fG/Y:uCbT\u0011aC\u0001\u0004G>l7\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]\u0011S\"\u0001\r\u000b\u0005eQ\u0012!\u0002:fiJL(BA\u000e\u001d\u0003\u0011\u0019wN]3\u000b\u0005uq\u0012aA1qS*\u0011q\u0004I\u0001\u0007IJLg/\u001a:\u000b\u0005\u0005B\u0011aA8tg&\u00111\u0005\u0007\u0002\f%\u0016$(/\u001f)pY&\u001c\u0017\u0010\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003\u001d\u0019wN\u001c;fqR\u0004\"aJ\u0015\u000e\u0003!R!!\n\u000e\n\u0005)B#!\u0004#sSZ,'oQ8oi\u0016DH\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003-\u0001(o\u001c4jY\u0016t\u0015-\\3\u0011\u00059\"dBA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002\u0014A\u0002)sK\u0012,g-\u0003\u00026m\t11\u000b\u001e:j]\u001eT!a\r\u0019\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\rQD(\u0010\t\u0003w\u0001i\u0011A\u0001\u0005\u0006K]\u0002\rA\n\u0005\u0006Y]\u0002\r!\f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u00035i\u0017\r\u001f*fiJL8i\\;oiV\t\u0011\t\u0005\u00020\u0005&\u00111\t\r\u0002\u0004\u0013:$\bBB#\u0001A\u0003%\u0011)\u0001\bnCb\u0014V\r\u001e:z\u0007>,h\u000e\u001e\u0011\t\u000b\u001d\u0003A\u0011\u0002%\u0002+I,GO]=NC:LH+[7fg>\u0013H\u000b\u001b:poR\u0011\u0011\n\u0014\t\u0003/)K!a\u0013\r\u0003\u001bI+GO]=EK\u000eL7/[8o\u0011\u0015ie\t1\u0001B\u0003\u001dq'MU3uefDQa\u0014\u0001\u0005BA\u000bQb\u001c8SK\u0006$G+[7f_V$HcB%R3~\u000b7\r\u001b\u0005\u0006%:\u0003\raU\u0001\be\u0016\fX/Z:u!\t!v+D\u0001V\u0015\t1&$A\u0004tKN\u001c\u0018n\u001c8\n\u0005a+&a\u0002*fcV,7\u000f\u001e\u0005\u00065:\u0003\raW\u0001\u0003G2\u0004\"\u0001X/\u000e\u0003iI!A\u0018\u000e\u0003!\r{gn]5ti\u0016t7-\u001f'fm\u0016d\u0007\"\u00021O\u0001\u0004\t\u0015\u0001\u00032m_\u000e\\gi\u001c:\t\u000b\tt\u0005\u0019A!\u0002\u0011I,7-Z5wK\u0012DQ\u0001\u001a(A\u0002\u0015\f1\u0002Z1uCB\u0013Xm]3oiB\u0011qFZ\u0005\u0003OB\u0012qAQ8pY\u0016\fg\u000eC\u0003j\u001d\u0002\u0007\u0011)\u0001\u0006sKR\u0014\u0018pQ8v]RDQa\u001b\u0001\u0005B1\fab\u001c8Xe&$X\rV5nK>,H\u000fF\u0004J[:|w\u000f_=\t\u000bIS\u0007\u0019A*\t\u000biS\u0007\u0019A.\t\u000bAT\u0007\u0019A9\u0002\u0013]\u0014\u0018\u000e^3UsB,\u0007C\u0001:v\u001b\u0005\u0019(B\u0001;\u001b\u00031\u0019XM\u001d<fe\u0016\u0014(o\u001c:t\u0013\t18OA\u0005Xe&$X\rV=qK\")\u0001M\u001ba\u0001\u0003\")!M\u001ba\u0001\u0003\")\u0011N\u001ba\u0001\u0003\")1\u0010\u0001C!y\u0006iqN\\+oCZ\f\u0017\u000e\\1cY\u0016$\u0002\"S?\u007f\u007f\u0006\r\u0011q\u0001\u0005\u0006%j\u0004\ra\u0015\u0005\u00065j\u0004\ra\u0017\u0005\u0007\u0003\u0003Q\b\u0019A!\u0002\u0011I,\u0017/^5sK\u0012Da!!\u0002{\u0001\u0004\t\u0015!B1mSZ,\u0007\"B5{\u0001\u0004\t\u0005bBA\u0006\u0001\u0011\u0005\u0013QB\u0001\u0011_:\u0014V-];fgR\f%m\u001c:uK\u0012$r!SA\b\u0003#\ti\u0003\u0003\u0004S\u0003\u0013\u0001\ra\u0015\u0005\t\u0003'\tI\u00011\u0001\u0002\u0016\u0005)QM\u001d:peB!\u0011qCA\u0014\u001d\u0011\tI\"a\t\u000f\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b\r\u0003\u0019a$o\\8u}%\t\u0011'C\u0002\u0002&A\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002*\u0005-\"!\u0003+ie><\u0018M\u00197f\u0015\r\t)\u0003\r\u0005\u0007S\u0006%\u0001\u0019A!\t\u000f\u0005E\u0002\u0001\"\u0011\u00024\u0005yqN\\#se>\u0014(+Z:q_:\u001cX\rF\u0004J\u0003k\t9$a\u0010\t\rI\u000by\u00031\u0001T\u0011!\t\u0019\"a\fA\u0002\u0005e\u0002c\u0001:\u0002<%\u0019\u0011QH:\u0003)\r{wN\u001d3j]\u0006$xN]#yG\u0016\u0004H/[8o\u0011\u0019I\u0017q\u0006a\u0001\u0003\"9\u00111\t\u0001\u0005B\u0005\u0015\u0013!B2m_N,GCAA$!\ry\u0013\u0011J\u0005\u0004\u0003\u0017\u0002$\u0001B+oSR<q!a\u0014\u0003\u0011\u0003\t\t&A\nNk2$\u0018\u000e\u001d7f%\u0016$(/\u001f)pY&\u001c\u0017\u0010E\u0002<\u0003'2a!\u0001\u0002\t\u0002\u0005U3\u0003BA*\u0003/\u00022aLA-\u0013\r\tY\u0006\r\u0002\u0007\u0003:L(+\u001a4\t\u000fa\n\u0019\u0006\"\u0001\u0002`Q\u0011\u0011\u0011\u000b\u0005\u000b\u0003G\n\u0019F1A\u0005\u0002\u0005\u0015\u0014!D'bqJ+GO]=D_VtG/\u0006\u0002\u0002hA!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002ni\taaY8oM&<\u0017\u0002BA9\u0003W\u0012A\u0002\u0012:jm\u0016\u0014x\n\u001d;j_:D\u0011\"!\u001e\u0002T\u0001\u0006I!a\u001a\u0002\u001d5\u000b\u0007PU3uef\u001cu.\u001e8uA!I\u0011\u0011PA*\u0005\u0004%\t\u0001Q\u0001\u0015\u001b\u0006D(+\u001a;ss\u000e{WO\u001c;EK\u001a\fW\u000f\u001c;\t\u0011\u0005u\u00141\u000bQ\u0001\n\u0005\u000bQ#T1y%\u0016$(/_\"pk:$H)\u001a4bk2$\b\u0005")
public class MultipleRetryPolicy
implements RetryPolicy {
    private final int maxRetryCount;

    public static int MaxRetryCountDefault() {
        return MultipleRetryPolicy$.MODULE$.MaxRetryCountDefault();
    }

    public static DriverOption MaxRetryCount() {
        return MultipleRetryPolicy$.MODULE$.MaxRetryCount();
    }

    private int maxRetryCount() {
        return this.maxRetryCount;
    }

    private RetryDecision retryManyTimesOrThrow(int nbRetry) {
        RetryDecision retryDecision;
        int n = this.maxRetryCount();
        switch (n) {
            default: {
                if (nbRetry < n) {
                    retryDecision = RetryDecision.RETRY_SAME;
                    break;
                }
                retryDecision = RetryDecision.RETHROW;
                break;
            }
            case -1: {
                retryDecision = RetryDecision.RETRY_SAME;
            }
        }
        return retryDecision;
    }

    public RetryDecision onReadTimeout(Request request, ConsistencyLevel cl, int blockFor, int received, boolean dataPresent, int retryCount) {
        return this.retryManyTimesOrThrow(retryCount);
    }

    public RetryDecision onWriteTimeout(Request request, ConsistencyLevel cl, WriteType writeType, int blockFor, int received, int retryCount) {
        return this.retryManyTimesOrThrow(retryCount);
    }

    public RetryDecision onUnavailable(Request request, ConsistencyLevel cl, int required, int alive, int retryCount) {
        return this.retryManyTimesOrThrow(retryCount);
    }

    public RetryDecision onRequestAborted(Request request, Throwable error, int retryCount) {
        return this.retryManyTimesOrThrow(retryCount);
    }

    public RetryDecision onErrorResponse(Request request, CoordinatorException error, int retryCount) {
        return RetryDecision.RETHROW;
    }

    public void close() {
    }

    public MultipleRetryPolicy(DriverContext context, String profileName) {
        this.maxRetryCount = context.getConfig().getProfile(profileName).getInt(MultipleRetryPolicy$.MODULE$.MaxRetryCount(), MultipleRetryPolicy$.MODULE$.MaxRetryCountDefault());
    }
}

