/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector;

import com.datastax.spark.connector.DStreamJavaFunctions;
import com.datastax.spark.connector.RDDJavaFunctions;
import com.datastax.spark.connector.SparkContextJavaFunctions;
import com.datastax.spark.connector.StreamingContextJavaFunctions;
import com.datastax.spark.connector.util.JavaApiHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.DStream;

public class CassandraJavaUtil {
    public static final Map<String, String> NO_OVERRIDE = new HashMap<String, String>();

    private CassandraJavaUtil() {
        assert (false);
    }

    public static SparkContextJavaFunctions javaFunctions(SparkContext sparkContext) {
        return new SparkContextJavaFunctions(sparkContext);
    }

    public static SparkContextJavaFunctions javaFunctions(JavaSparkContext javaSparkContext) {
        return new SparkContextJavaFunctions(JavaSparkContext.toSparkContext((JavaSparkContext)javaSparkContext));
    }

    public static StreamingContextJavaFunctions javaFunctions(StreamingContext streamingContext) {
        return new StreamingContextJavaFunctions(streamingContext);
    }

    public static StreamingContextJavaFunctions javaFunctions(JavaStreamingContext javaStreamingContext) {
        return new StreamingContextJavaFunctions(javaStreamingContext.ssc());
    }

    public static <T> RDDJavaFunctions javaFunctions(RDD<T> rDD, Class<T> clazz) {
        return new RDDJavaFunctions<T>(rDD, JavaApiHelper.getClassTag(clazz));
    }

    public static <T> RDDJavaFunctions javaFunctions(JavaRDD<T> javaRDD, Class<T> clazz) {
        return new RDDJavaFunctions<T>(javaRDD.rdd(), JavaApiHelper.getClassTag(clazz));
    }

    public static <T> DStreamJavaFunctions javaFunctions(DStream<T> dStream, Class<T> clazz) {
        return new DStreamJavaFunctions<T>(dStream, JavaApiHelper.getClassTag(clazz));
    }

    public static <T> DStreamJavaFunctions javaFunctions(JavaDStream<T> javaDStream, Class<T> clazz) {
        return new DStreamJavaFunctions<T>(javaDStream.dstream(), JavaApiHelper.getClassTag(clazz));
    }
}

