/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector;

import com.datastax.spark.connector.CassandraRow;
import com.datastax.spark.connector.SparkContextFunctions;
import com.datastax.spark.connector.mapper.ColumnMapper;
import com.datastax.spark.connector.rdd.CassandraJavaRDD;
import com.datastax.spark.connector.rdd.reader.ClassBasedRowReaderFactory;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import com.datastax.spark.connector.util.JavaApiHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkContext;
import scala.reflect.ClassTag;
import scala.reflect.api.TypeTags;

public class SparkContextJavaFunctions {
    public final SparkContext sparkContext;
    private final SparkContextFunctions scf;

    SparkContextJavaFunctions(SparkContext sparkContext) {
        this.sparkContext = sparkContext;
        this.scf = new SparkContextFunctions(sparkContext);
    }

    public <T extends Serializable> CassandraJavaRDD<T> cassandraTable(String string, String string2, RowReaderFactory<T> rowReaderFactory, Class<T> clazz) {
        ClassTag<T> classTag = JavaApiHelper.getClassTag(clazz);
        return this.scf.cassandraTable(string, string2, classTag, rowReaderFactory).toJavaRDD();
    }

    public CassandraJavaRDD<CassandraRow> cassandraTable(String string, String string2) {
        RowReaderFactory<CassandraRow> rowReaderFactory = JavaApiHelper.genericRowReaderFactory();
        return this.cassandraTable(string, string2, rowReaderFactory, CassandraRow.class);
    }

    public <T extends Serializable> CassandraJavaRDD<T> cassandraTable(String string, String string2, ColumnMapper<T> columnMapper, Class<T> clazz) {
        TypeTags.TypeTag<T> typeTag = JavaApiHelper.getTypeTag(clazz);
        ClassBasedRowReaderFactory<T> classBasedRowReaderFactory = new ClassBasedRowReaderFactory<T>(typeTag, columnMapper);
        return this.cassandraTable(string, string2, classBasedRowReaderFactory, clazz);
    }

    public <T extends Serializable> CassandraJavaRDD<T> cassandraTable(String string, String string2, Class<T> clazz) {
        ClassTag<T> classTag = JavaApiHelper.getClassTag(clazz);
        ColumnMapper<T> columnMapper = JavaApiHelper.javaBeanColumnMapper(classTag, new HashMap<String, String>());
        return this.cassandraTable(string, string2, columnMapper, clazz);
    }

    public <T extends Serializable> CassandraJavaRDD<T> cassandraTable(String string, String string2, Class<T> clazz, Map<String, String> map) {
        ClassTag<T> classTag = JavaApiHelper.getClassTag(clazz);
        ColumnMapper<T> columnMapper = JavaApiHelper.javaBeanColumnMapper(classTag, map);
        return this.cassandraTable(string, string2, columnMapper, clazz);
    }
}

