/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy;
import com.datastax.spark.connector.cql.MultipleRetryPolicy;
import com.datastax.spark.connector.cql.NoAuthConf$;
import com.datastax.spark.connector.cql.RefCountedCache;
import java.net.InetAddress;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CassandraConnector$
implements Logging,
Serializable {
    public static final CassandraConnector$ MODULE$;
    private final int keepAliveMillis;
    private final int minReconnectionDelay;
    private final int maxReconnectionDelay;
    private final int retryCount;
    private final RefCountedCache<CassandraConnectorConf, Session> com$datastax$spark$connector$cql$CassandraConnector$$sessionCache;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new CassandraConnector$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int keepAliveMillis() {
        return this.keepAliveMillis;
    }

    public int minReconnectionDelay() {
        return this.minReconnectionDelay;
    }

    public int maxReconnectionDelay() {
        return this.maxReconnectionDelay;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public RefCountedCache<CassandraConnectorConf, Session> com$datastax$spark$connector$cql$CassandraConnector$$sessionCache() {
        return this.com$datastax$spark$connector$cql$CassandraConnector$$sessionCache;
    }

    public Session com$datastax$spark$connector$cql$CassandraConnector$$createSession(CassandraConnectorConf conf) {
        this.logDebug((Function0<String>)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connecting to cluster: ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conf$1.hosts().mkString("{", ",", "}"), BoxesRunTime.boxToInteger((int)this.conf$1.nativePort())}));
            }
            {
                this.conf$1 = conf$1;
            }
        });
        Cluster cluster = Cluster.builder().addContactPoints((InetAddress[])conf.hosts().toSeq().toArray(ClassTag$.MODULE$.apply(InetAddress.class))).withPort(conf.nativePort()).withRetryPolicy((RetryPolicy)new MultipleRetryPolicy(this.retryCount())).withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy((long)this.minReconnectionDelay(), (long)this.maxReconnectionDelay())).withLoadBalancingPolicy((LoadBalancingPolicy)new LocalNodeFirstLoadBalancingPolicy(conf.hosts())).withAuthProvider(conf.authConf().authProvider()).build();
        String clusterName = cluster.getMetadata().getClusterName();
        this.logInfo((Function0<String>)new Serializable(clusterName){
            public static final long serialVersionUID = 0L;
            private final String clusterName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to Cassandra cluster: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterName$1}));
            }
            {
                this.clusterName$1 = clusterName$1;
            }
        });
        return cluster.connect();
    }

    public void com$datastax$spark$connector$cql$CassandraConnector$$destroySession(Session session) {
        Cluster cluster = session.getCluster();
        String clusterName = cluster.getMetadata().getClusterName();
        session.close();
        cluster.close();
        this.logInfo((Function0<String>)new Serializable(clusterName){
            public static final long serialVersionUID = 0L;
            private final String clusterName$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disconnected from Cassandra cluster: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterName$2}));
            }
            {
                this.clusterName$2 = clusterName$2;
            }
        });
    }

    public Set<CassandraConnectorConf> com$datastax$spark$connector$cql$CassandraConnector$$alternativeConnectionConfigs(CassandraConnectorConf conf, Session session) {
        Cluster cluster = session.getCluster();
        Set<Host> hosts = this.nodesInTheSameDC(conf.hosts(), (Set<Host>)JavaConversions$.MODULE$.asScalaSet(cluster.getMetadata().getAllHosts()).toSet());
        return (Set)((SetLike)hosts.map((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$2;

            public final CassandraConnectorConf apply(Host h) {
                return this.conf$2.copy((Set<InetAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{h.getAddress()}))), this.conf$2.copy$default$2(), this.conf$2.copy$default$3(), this.conf$2.copy$default$4());
            }
            {
                this.conf$2 = conf$2;
            }
        }, Set$.MODULE$.canBuildFrom())).$plus((Object)conf.copy((Set<InetAddress>)((Set)hosts.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InetAddress apply(Host x$3) {
                return x$3.getAddress();
            }
        }, Set$.MODULE$.canBuildFrom())), conf.copy$default$2(), conf.copy$default$3(), conf.copy$default$4()));
    }

    public Set<Host> nodesInTheSameDC(Set<InetAddress> contactPoints, Set<Host> allHosts) {
        Set contactNodes = (Set)allHosts.filter((Function1)new Serializable(contactPoints){
            public static final long serialVersionUID = 0L;
            private final Set contactPoints$1;

            public final boolean apply(Host h) {
                return this.contactPoints$1.contains((Object)h.getAddress());
            }
            {
                this.contactPoints$1 = contactPoints$1;
            }
        });
        Set contactDCs = ((Set)((TraversableLike)contactNodes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Host x$4) {
                return x$4.getDatacenter();
            }
        }, Set$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return x$5 != null;
            }
        })).toSet();
        return (Set)allHosts.filter((Function1)new Serializable(contactDCs){
            public static final long serialVersionUID = 0L;
            private final Set contactDCs$1;

            public final boolean apply(Host h) {
                return h.getDatacenter() == null || this.contactDCs$1.contains((Object)h.getDatacenter());
            }
            {
                this.contactDCs$1 = contactDCs$1;
            }
        });
    }

    public CassandraConnector apply(SparkConf conf) {
        return new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
    }

    public CassandraConnector apply(InetAddress host, int nativePort, int rpcPort, AuthConf authConf) {
        CassandraConnectorConf config = CassandraConnectorConf$.MODULE$.apply(host, nativePort, rpcPort, authConf);
        return new CassandraConnector(config);
    }

    public int apply$default$2() {
        return CassandraConnectorConf$.MODULE$.DefaultNativePort();
    }

    public int apply$default$3() {
        return CassandraConnectorConf$.MODULE$.DefaultRpcPort();
    }

    public AuthConf apply$default$4() {
        return NoAuthConf$.MODULE$;
    }

    public void evictCache() {
        this.com$datastax$spark$connector$cql$CassandraConnector$$sessionCache().evict();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraConnector$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.keepAliveMillis = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.cassandra.connection.keep_alive_ms", "250"))).toInt();
        this.minReconnectionDelay = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.cassandra.connection.reconnection_delay_ms.min", "1000"))).toInt();
        this.maxReconnectionDelay = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.cassandra.connection.reconnection_delay_ms.max", "60000"))).toInt();
        this.retryCount = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.cassandra.query.retry.count", "10"))).toInt();
        this.com$datastax$spark$connector$cql$CassandraConnector$$sessionCache = new RefCountedCache(new anonfun.4(), new anonfun.5(), new anonfun.6(), this.keepAliveMillis());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$sessionCache().shutdown();
            }
        }));
    }
}

