/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.ClusteringColumn;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.PartitionKeyColumn$;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.cql.TableDef$;
import com.datastax.spark.connector.types.ColumnType;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.DataFrame;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u0017\t\u0011B)\u0019;b\rJ\fW.\u001a$v]\u000e$\u0018n\u001c8t\u0015\t\u0019A!A\u0005d_:tWm\u0019;pe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\t\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\ti1#\u0003\u0002\u0015\u001d\ta1+\u001a:jC2L'0\u00192mK\"Aa\u0003\u0001B\u0001B\u0003%q#A\u0005eCR\fgI]1nKB\u0011\u0001\u0004I\u0007\u00023)\u0011!dG\u0001\u0004gFd'BA\u0003\u001d\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005J\"!\u0003#bi\u00064%/Y7f\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\u0011Qe\n\t\u0003M\u0001i\u0011A\u0001\u0005\u0006-\t\u0002\ra\u0006\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u00031\u0019\b/\u0019:l\u0007>tG/\u001a=u+\u0005Y\u0003C\u0001\u0017.\u001b\u0005Y\u0012B\u0001\u0018\u001c\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0019\u0001\u0004\u0001)A\u0005W\u0005i1\u000f]1sW\u000e{g\u000e^3yi\u0002BQA\r\u0001\u0005\u0002M\nAc\u0019:fCR,7)Y:tC:$'/\u0019+bE2,G#\u0002\u001b@\u0011*[FCA\u001b9!\tia'\u0003\u00028\u001d\t!QK\\5u\u0011\u001d\u0019\u0011\u0007%AA\u0004e\u0002\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0002\u0002\u0007\r\fH.\u0003\u0002?w\t\u00112)Y:tC:$'/Y\"p]:,7\r^8s\u0011\u0015\u0001\u0015\u00071\u0001B\u00031YW-_:qC\u000e,g*Y7f!\t\u0011UI\u0004\u0002\u000e\u0007&\u0011AID\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002E\u001d!)\u0011*\ra\u0001\u0003\u0006IA/\u00192mK:\u000bW.\u001a\u0005\b\u0017F\u0002\n\u00111\u0001M\u0003M\u0001\u0018M\u001d;ji&|gnS3z\u0007>dW/\u001c8t!\riQjT\u0005\u0003\u001d:\u0011aa\u00149uS>t\u0007c\u0001)Y\u0003:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005]s\u0011a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t9f\u0002C\u0004]cA\u0005\t\u0019\u0001'\u0002)\rdWo\u001d;fe&twmS3z\u0007>dW/\u001c8t\u0011\u001dq\u0006!%A\u0005\u0002}\u000bad\u0019:fCR,7)Y:tC:$'/\u0019+bE2,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003\u0001T#\u0001T1,\u0003\t\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\u0013Ut7\r[3dW\u0016$'BA4\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0003S\u0012\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001dY\u0007!%A\u0005\u0002}\u000bad\u0019:fCR,7)Y:tC:$'/\u0019+bE2,G\u0005Z3gCVdG\u000f\n\u001b\t\u000f5\u0004\u0011\u0013!C\u0001]\u0006q2M]3bi\u0016\u001c\u0015m]:b]\u0012\u0014\u0018\rV1cY\u0016$C-\u001a4bk2$H%\u000e\u000b\u0006_B\f(o\u001d\u0016\u0003s\u0005DQ\u0001\u00117A\u0002\u0005CQ!\u00137A\u0002\u0005CQa\u00137A\u00021CQ\u0001\u00187A\u00021\u0003")
public class DataFrameFunctions
implements Serializable {
    private final DataFrame dataFrame;
    private final SparkContext sparkContext;

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public void createCassandraTable(String keyspaceName, String tableName, Option<Seq<String>> partitionKeyColumns, Option<Seq<String>> clusteringKeyColumns, CassandraConnector connector) {
        TableDef rawTable = TableDef$.MODULE$.fromDataFrame(this.dataFrame, keyspaceName, tableName);
        Map<String, ColumnDef> columnMapping = rawTable.columnByName();
        Set columnNames2 = columnMapping.keys().toSet();
        Seq partitionKeyNames = (Seq)partitionKeyColumns.getOrElse((Function0)new Serializable(this, rawTable){
            public static final long serialVersionUID = 0L;
            private final TableDef rawTable$1;

            public final Seq<String> apply() {
                return (Seq)this.rawTable$1.partitionKey().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ColumnDef x$1) {
                        return x$1.columnName();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.rawTable$1 = rawTable$1;
            }
        });
        Seq clusteringKeyNames = (Seq)clusteringKeyColumns.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        Seq regularColumnNames = ((SetLike)columnNames2.$minus$minus((GenTraversableOnce)partitionKeyNames.$plus$plus((GenTraversableOnce)clusteringKeyNames, Seq$.MODULE$.canBuildFrom()))).toSeq();
        Seq x$19 = (Seq)((TraversableLike)partitionKeyNames.map((Function1)new Serializable(this, columnMapping){
            public static final long serialVersionUID = 0L;
            private final Map columnMapping$1;

            public final ColumnDef apply(String x$2) {
                return (ColumnDef)this.columnMapping$1.get((Object)x$2).get();
            }
            {
                this.columnMapping$1 = columnMapping$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(ColumnDef x$3) {
                PartitionKeyColumn$ x$7 = PartitionKeyColumn$.MODULE$;
                String x$8 = x$3.copy$default$1();
                ColumnType<?> x$9 = x$3.copy$default$3();
                boolean x$10 = x$3.copy$default$4();
                return x$3.copy(x$8, x$7, x$9, x$10);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq x$20 = (Seq)((TraversableLike)((IterableLike)clusteringKeyNames.map((Function1)new Serializable(this, columnMapping){
            public static final long serialVersionUID = 0L;
            private final Map columnMapping$1;

            public final ColumnDef apply(String x$4) {
                return (ColumnDef)this.columnMapping$1.get((Object)x$4).get();
            }
            {
                this.columnMapping$1 = columnMapping$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(Tuple2<ColumnDef, Object> x0$1) {
                Tuple2<ColumnDef, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    ColumnDef col = (ColumnDef)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    ClusteringColumn x$11 = new ClusteringColumn(index);
                    String x$12 = col.copy$default$1();
                    ColumnType<?> x$13 = col.copy$default$3();
                    boolean x$14 = col.copy$default$4();
                    ColumnDef columnDef = col.copy(x$12, x$11, x$13, x$14);
                    return columnDef;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq x$21 = (Seq)((TraversableLike)regularColumnNames.map((Function1)new Serializable(this, columnMapping){
            public static final long serialVersionUID = 0L;
            private final Map columnMapping$1;

            public final ColumnDef apply(String x$5) {
                return (ColumnDef)this.columnMapping$1.get((Object)x$5).get();
            }
            {
                this.columnMapping$1 = columnMapping$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(ColumnDef x$6) {
                RegularColumn$ x$15 = RegularColumn$.MODULE$;
                String x$16 = x$6.copy$default$1();
                ColumnType<?> x$17 = x$6.copy$default$3();
                boolean x$18 = x$6.copy$default$4();
                return x$6.copy(x$16, x$15, x$17, x$18);
            }
        }, Seq$.MODULE$.canBuildFrom());
        String x$22 = rawTable.copy$default$1();
        String x$23 = rawTable.copy$default$2();
        TableDef table = rawTable.copy(x$22, x$23, (Seq<ColumnDef>)x$19, (Seq<ColumnDef>)x$20, (Seq<ColumnDef>)x$21);
        connector.withSessionDo(new Serializable(this, table){
            public static final long serialVersionUID = 0L;
            private final TableDef table$1;

            public final ResultSet apply(Session session) {
                return session.execute(this.table$1.cql());
            }
            {
                this.table$1 = table$1;
            }
        });
    }

    public Option<Seq<String>> createCassandraTable$default$3() {
        return None$.MODULE$;
    }

    public Option<Seq<String>> createCassandraTable$default$4() {
        return None$.MODULE$;
    }

    public CassandraConnector createCassandraTable$default$5(String keyspaceName, String tableName, Option<Seq<String>> partitionKeyColumns, Option<Seq<String>> clusteringKeyColumns) {
        return CassandraConnector$.MODULE$.apply(this.sparkContext().getConf());
    }

    public DataFrameFunctions(DataFrame dataFrame) {
        this.dataFrame = dataFrame;
        this.sparkContext = dataFrame.sqlContext().sparkContext();
    }
}

