/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.KeyspaceDef;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.CassandraCatalog$;
import org.apache.spark.sql.cassandra.CassandraSQLContext;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceOptions$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.catalyst.CatalystConf;
import org.apache.spark.sql.catalyst.SimpleCatalystConf;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Catalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f!B\u0001\u0003\u0001\ta!\u0001E\"bgN\fg\u000e\u001a:b\u0007\u0006$\u0018\r\\8h\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\t\u0001i1c\u0007\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001C1oC2L8/[:\u000b\u0005a!\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005i)\"aB\"bi\u0006dwn\u001a\t\u00039ui\u0011AB\u0005\u0003=\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003#\u0003\r\u00197oY\u0002\u0001!\t\u0019C%D\u0001\u0003\u0013\t)#AA\nDCN\u001c\u0018M\u001c3sCN\u000bFjQ8oi\u0016DH\u000fC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0003S)\u0002\"a\t\u0001\t\u000b\u00012\u0003\u0019\u0001\u0012\t\u000f1\u0002!\u0019!C\u0001[\u0005i1-Y:f'\u0016t7/\u001b;jm\u0016,\u0012A\f\t\u0003\u001d=J!\u0001M\b\u0003\u000f\t{w\u000e\\3b]\"1!\u0007\u0001Q\u0001\n9\nabY1tKN+gn]5uSZ,\u0007\u0005\u0003\u00055\u0001\t\u0007I\u0011\u0001\u00026\u0003Y\u0019\u0017m\u00195fI\u0012\u000bG/Y*pkJ\u001cW\rV1cY\u0016\u001cX#\u0001\u001c\u0011\t]\u0002%)V\u0007\u0002q)\u0011\u0011HO\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003wq\naaY8n[>t'BA\u001f?\u0003\u00199wn\\4mK*\tq(A\u0002d_6L!!\u0011\u001d\u0003\u00191{\u0017\rZ5oO\u000e\u000b7\r[3\u0011\u0007\r[eJ\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011q)I\u0001\u0007yI|w\u000e\u001e \n\u0003AI!AS\b\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0004'\u0016\f(B\u0001&\u0010!\ty%K\u0004\u0002\u000f!&\u0011\u0011kD\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R\u001fA\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\bY><\u0017nY1m\u0015\tQv#A\u0003qY\u0006t7/\u0003\u0002]/\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0019q\u0006\u0001)A\u0005m\u000592-Y2iK\u0012$\u0015\r^1T_V\u00148-\u001a+bE2,7\u000f\t\u0005\u0006A\u0002!\t%Y\u0001\u000fY>|7.\u001e9SK2\fG/[8o)\r)&\r\u001a\u0005\u0006G~\u0003\rAQ\u0001\u0010i\u0006\u0014G.Z%eK:$\u0018NZ5fe\"9Qm\u0018I\u0001\u0002\u00041\u0017!B1mS\u0006\u001c\bc\u0001\bh\u001d&\u0011\u0001n\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b)\u0004A\u0011B6\u0002\u001b\t,\u0018\u000e\u001c3SK2\fG/[8o)\t)F\u000eC\u0003dS\u0002\u0007!\tC\u0003o\u0001\u0011%q.\u0001\fhKR\u001cE.^:uKJ$%\tV1cY\u0016t\u0015-\\3t)\t\u00018\u000fE\u0003\u000fc:se*\u0003\u0002s\u001f\t1A+\u001e9mKNBQaY7A\u0002\tCQ!\u001e\u0001\u0005\nY\faBZ;mYR\u000b'\r\\3JI\u0016tG\u000f\u0006\u0002Co\")1\r\u001ea\u0001\u0005\")\u0011\u0010\u0001C!u\u0006i!/Z4jgR,'\u000fV1cY\u0016$2a\u001f@\u0000!\tqA0\u0003\u0002~\u001f\t!QK\\5u\u0011\u0015\u0019\u0007\u00101\u0001C\u0011\u0019\t\t\u0001\u001fa\u0001+\u0006!\u0001\u000f\\1o\u0011\u001d\t)\u0001\u0001C!\u0003\u000f\tq\"\u001e8sK\u001eL7\u000f^3s)\u0006\u0014G.\u001a\u000b\u0004w\u0006%\u0001BB2\u0002\u0004\u0001\u0007!\tC\u0004\u0002\u000e\u0001!\t%a\u0004\u0002'Ut'/Z4jgR,'/\u00117m)\u0006\u0014G.Z:\u0015\u0003mDq!a\u0005\u0001\t\u0003\n)\"A\u0006uC\ndW-\u0012=jgR\u001cHc\u0001\u0018\u0002\u0018!11-!\u0005A\u0002\tCq!a\u0007\u0001\t\u0003\ni\"A\u0005hKR$\u0016M\u00197fgR!\u0011qDA\u0014!\u0011\u00195*!\t\u0011\u000b9\t\u0019C\u0014\u0018\n\u0007\u0005\u0015rB\u0001\u0004UkBdWM\r\u0005\b\u0003S\tI\u00021\u0001g\u00031!\u0017\r^1cCN,g*Y7f\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\tacZ3u)\u0006\u0014G.Z:Ge>l7)Y:tC:$'/\u0019\u000b\u0005\u0003?\t\t\u0004C\u0004\u0002*\u0005-\u0002\u0019\u00014\t\u000f\u0005U\u0002\u0001\"\u0001\u00028\u0005\u0011r-\u001a;UC\ndWm\u001d$s_6\u001c\u0015m\u00195f)\u0019\ty\"!\u000f\u0002<!9\u0011\u0011FA\u001a\u0001\u00041\u0007\"CA\u001f\u0003g\u0001\n\u00111\u0001g\u0003\u001d\u0019G.^:uKJDq!!\u0011\u0001\t\u0013\t\u0019%A\u000bhKR\u001c\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\u0015\t\u0005\u0015\u00131\f\t\u0005\u0003\u000f\n9&\u0004\u0002\u0002J)!\u00111JA'\u0003\r\u0019\u0017\u000f\u001c\u0006\u0005\u0003\u001f\n\t&A\u0005d_:tWm\u0019;pe*\u0019q!a\u0015\u000b\u0007\u0005Uc(\u0001\u0005eCR\f7\u000f^1y\u0013\u0011\tI&!\u0013\u0003%\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$xN\u001d\u0005\t\u0003;\ny\u00041\u0001\u0002`\u0005AA/\u00192mKJ+g\rE\u0002$\u0003CJ1!a\u0019\u0003\u0005!!\u0016M\u00197f%\u00164\u0007\"CA4\u0001\t\u0007I\u0011IA5\u0003\u0011\u0019wN\u001c4\u0016\u0005\u0005-\u0004\u0003BA7\u0003_j\u0011aF\u0005\u0004\u0003c:\"\u0001D\"bi\u0006d\u0017p\u001d;D_:4\u0007\u0002CA;\u0001\u0001\u0006I!a\u001b\u0002\u000b\r|gN\u001a\u0011\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|\u0005a!/\u001a4sKNDG+\u00192mKR\u001910! \t\u0011\u0005}\u0014q\u000fa\u0001\u0003\u0003\u000b!\u0002^1cY\u0016LE-\u001a8u!\u0011\ti'a!\n\u0007\u0005\u0015uCA\bUC\ndW-\u00133f]RLg-[3s\u0011%\tI\tAI\u0001\n\u0003\tY)\u0001\u000fhKR$\u0016M\u00197fg\u001a\u0013x.\\\"bG\",G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055%f\u00014\u0002\u0010.\u0012\u0011\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001c>\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty*!&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class CassandraCatalog
implements Catalog,
Logging {
    public final CassandraSQLContext org$apache$spark$sql$cassandra$CassandraCatalog$$csc;
    private final boolean caseSensitive;
    private final LoadingCache<Seq<String>, LogicalPlan> cachedDataSourceTables;
    private final CatalystConf conf;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Seq<String> processTableIdentifier(Seq<String> tableIdentifier) {
        return Catalog.class.processTableIdentifier((Catalog)this, tableIdentifier);
    }

    public String getDbTableName(Seq<String> tableIdent) {
        return Catalog.class.getDbTableName((Catalog)this, tableIdent);
    }

    public Tuple2<Option<String>, String> getDBTable(Seq<String> tableIdent) {
        return Catalog.class.getDBTable((Catalog)this, tableIdent);
    }

    public void checkTableIdentifier(Seq<String> tableIdentifier) {
        Catalog.class.checkTableIdentifier((Catalog)this, tableIdentifier);
    }

    public Option<String> lookupRelation$default$2() {
        return Catalog.class.lookupRelation$default$2((Catalog)this);
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public LoadingCache<Seq<String>, LogicalPlan> cachedDataSourceTables() {
        return this.cachedDataSourceTables;
    }

    public LogicalPlan lookupRelation(Seq<String> tableIdentifier, Option<String> alias) {
        Seq<String> tableIdent = this.fullTableIdent(tableIdentifier);
        LogicalPlan tableLogicPlan = (LogicalPlan)this.cachedDataSourceTables().get(tableIdent);
        return (LogicalPlan)alias.map((Function1)new Serializable(this, tableLogicPlan){
            public static final long serialVersionUID = 0L;
            private final LogicalPlan tableLogicPlan$1;

            public final Subquery apply(String a) {
                return new Subquery(a, this.tableLogicPlan$1);
            }
            {
                this.tableLogicPlan$1 = tableLogicPlan$1;
            }
        }).getOrElse((Function0)new Serializable(this, tableLogicPlan){
            public static final long serialVersionUID = 0L;
            private final LogicalPlan tableLogicPlan$1;

            public final LogicalPlan apply() {
                return this.tableLogicPlan$1;
            }
            {
                this.tableLogicPlan$1 = tableLogicPlan$1;
            }
        });
    }

    public LogicalPlan org$apache$spark$sql$cassandra$CassandraCatalog$$buildRelation(Seq<String> tableIdentifier) {
        Tuple3<String, String, String> tuple3 = this.getClusterDBTableNames(tableIdentifier);
        if (tuple3 != null) {
            Tuple3 tuple32;
            String cluster = (String)tuple3._1();
            String database = (String)tuple3._2();
            String table = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)cluster, (Object)database, (Object)table);
            String cluster2 = (String)tuple33._1();
            String database2 = (String)tuple33._2();
            String table2 = (String)tuple33._3();
            TableRef tableRef = new TableRef(table2, database2, (Option<String>)Option$.MODULE$.apply((Object)cluster2));
            CassandraSourceRelation sourceRelation = CassandraSourceRelation$.MODULE$.apply(tableRef, this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc, new CassandraSourceOptions(CassandraSourceOptions$.MODULE$.apply$default$1(), CassandraSourceOptions$.MODULE$.apply$default$2()), CassandraSourceRelation$.MODULE$.apply$default$4());
            return new Subquery(table2, (LogicalPlan)new LogicalRelation((BaseRelation)sourceRelation));
        }
        throw new MatchError(tuple3);
    }

    private Tuple3<String, String, String> getClusterDBTableNames(Seq<String> tableIdentifier) {
        Function1 id = ((PartialFunction)this.processTableIdentifier(tableIdentifier).reverse()).lift();
        String cluster = (String)((Option)id.apply((Object)BoxesRunTime.boxToInteger((int)2))).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String database = (String)((Option)id.apply((Object)BoxesRunTime.boxToInteger((int)1))).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getKeyspace();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String table = (String)((Option)id.apply((Object)BoxesRunTime.boxToInteger((int)0))).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing table name"})).s((Seq)Nil$.MODULE$));
            }
        });
        return new Tuple3((Object)cluster, (Object)database, (Object)table);
    }

    private Seq<String> fullTableIdent(Seq<String> tableIdentifier) {
        Tuple3<String, String, String> tuple3 = this.getClusterDBTableNames(tableIdentifier);
        if (tuple3 != null) {
            Tuple3 tuple32;
            String cluster = (String)tuple3._1();
            String database = (String)tuple3._2();
            String table = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)cluster, (Object)database, (Object)table);
            String cluster2 = (String)tuple33._1();
            String database2 = (String)tuple33._2();
            String table2 = (String)tuple33._3();
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cluster2, database2, table2}));
        }
        throw new MatchError(tuple3);
    }

    public void registerTable(Seq<String> tableIdentifier, LogicalPlan plan) {
        Seq<String> tableIdent = this.fullTableIdent(tableIdentifier);
        this.cachedDataSourceTables().put(tableIdent, (Object)plan);
    }

    public void unregisterTable(Seq<String> tableIdentifier) {
        Seq<String> tableIdent = this.fullTableIdent(tableIdentifier);
        this.cachedDataSourceTables().invalidate(tableIdent);
    }

    public void unregisterAllTables() {
        this.cachedDataSourceTables().invalidateAll();
    }

    public boolean tableExists(Seq<String> tableIdentifier) {
        Tuple3<String, String, String> tuple3 = this.getClusterDBTableNames(tableIdentifier);
        if (tuple3 != null) {
            boolean bl;
            Tuple3 tuple32;
            String cluster = (String)tuple3._1();
            String database = (String)tuple3._2();
            String table = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)cluster, (Object)database, (Object)table);
            String cluster2 = (String)tuple33._1();
            String database2 = (String)tuple33._2();
            String table2 = (String)tuple33._3();
            Seq<String> tableIdent = this.fullTableIdent(tableIdentifier);
            boolean cached = this.cachedDataSourceTables().asMap().containsKey(tableIdent);
            if (cached) {
                bl = true;
            } else {
                TableRef tableRef = new TableRef(table2, database2, (Option<String>)Option$.MODULE$.apply((Object)cluster2));
                Schema schema2 = Schema$.MODULE$.fromCassandra(this.getCassandraConnector(tableRef), Schema$.MODULE$.fromCassandra$default$2(), Schema$.MODULE$.fromCassandra$default$3());
                Option tabDef = schema2.keyspaceByName().get((Object)database2).flatMap((Function1)new Serializable(this, table2){
                    public static final long serialVersionUID = 0L;
                    private final String table$1;

                    public final Option<TableDef> apply(KeyspaceDef ksDef) {
                        return ksDef.tableByName().get((Object)this.table$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TableDef apply(TableDef tabDef) {
                                return tabDef;
                            }
                        });
                    }
                    {
                        this.table$1 = table$1;
                    }
                });
                bl = tabDef.nonEmpty();
            }
            return bl;
        }
        throw new MatchError(tuple3);
    }

    public Seq<Tuple2<String, Object>> getTables(Option<String> databaseName) {
        String cluster = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
        Seq tableNamesFromCache = (Seq)this.getTablesFromCache(databaseName, (Option<String>)Option$.MODULE$.apply((Object)cluster)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$4) {
                return (String)x$4._1();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Tuple2<String, Object>> tablesFromCassandra = this.getTablesFromCassandra(databaseName);
        Seq tablesOnlyInCache = (Seq)((TraversableLike)tableNamesFromCache.diff((GenSeq)tablesFromCassandra.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$5) {
                return (String)x$5._1();
            }
        }, Seq$.MODULE$.canBuildFrom()))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String name) {
                return new Tuple2((Object)name, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)tablesFromCassandra.$plus$plus((GenTraversableOnce)tablesOnlyInCache, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, Object>> getTablesFromCassandra(Option<String> databaseName) {
        String cluster = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
        TableRef tableRef = new TableRef("", (String)databaseName.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), (Option<String>)Option$.MODULE$.apply((Object)cluster));
        Schema schema2 = Schema$.MODULE$.fromCassandra(this.getCassandraConnector(tableRef), databaseName, Schema$.MODULE$.fromCassandra$default$3());
        return (Seq)schema2.keyspaces().toSeq().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, Object>> apply(KeyspaceDef ksDef) {
                return (Set)ksDef.tables().map((Function1)new Serializable(this, ksDef){
                    public static final long serialVersionUID = 0L;
                    private final KeyspaceDef ksDef$1;

                    public final Tuple2<String, Object> apply(TableDef tableDef) {
                        return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ksDef$1.keyspaceName(), tableDef.tableName()})), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    {
                        this.ksDef$1 = ksDef$1;
                    }
                }, Set$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, Object>> getTablesFromCache(Option<String> databaseName, Option<String> cluster) {
        String clusterName = (String)cluster.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return (Seq)JavaConversions$.MODULE$.asScalaSet(this.cachedDataSourceTables().asMap().keySet()).toSeq().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<String> check$ifrefutable$1) {
                Seq<String> seq = check$ifrefutable$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                boolean bl = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0;
                return bl;
            }
        }).withFilter((Function1)new Serializable(this, databaseName, clusterName){
            public static final long serialVersionUID = 0L;
            private final Option databaseName$1;
            private final String clusterName$1;

            public final boolean apply(Seq<String> x$7) {
                Seq<String> seq = x$7;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    String c = (String)((SeqLike)some.get()).apply(0);
                    String db = (String)((SeqLike)some.get()).apply(1);
                    String string = c;
                    String string2 = this.clusterName$1;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.databaseName$1.forall((Function1)new Serializable(this, db){
                        public static final long serialVersionUID = 0L;
                        private final String db$1;

                        public final boolean apply(String x$6) {
                            String string = x$6;
                            String string2 = this.db$1;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.db$1 = db$1;
                        }
                    });
                    return bl;
                }
                throw new MatchError(seq);
            }
            {
                this.databaseName$1 = databaseName$1;
                this.clusterName$1 = clusterName$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Seq<String> x$8) {
                Seq<String> seq = x$8;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    String db = (String)((SeqLike)some.get()).apply(1);
                    String table = (String)((SeqLike)some.get()).apply(2);
                    Tuple2 tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db, table})), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return tuple2;
                }
                throw new MatchError(seq);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> getTablesFromCache$default$2() {
        return None$.MODULE$;
    }

    private CassandraConnector getCassandraConnector(TableRef tableRef) {
        SparkConf sparkConf = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.sparkContext().getConf().clone();
        Map sqlConf = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getAllConfs();
        SparkConf conf = CassandraSourceRelation$.MODULE$.consolidateConfs(sparkConf, (Map<String, String>)sqlConf, tableRef, (Map<String, String>)Predef$.MODULE$.Map().empty());
        return new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
    }

    public CatalystConf conf() {
        return this.conf;
    }

    public void refreshTable(TableIdentifier tableIdent) {
        this.cachedDataSourceTables().refresh((Object)tableIdent.toSeq());
    }

    public CassandraCatalog(CassandraSQLContext csc) {
        this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc = csc;
        Catalog.class.$init$((Catalog)this);
        Logging.class.$init$((Logging)this);
        this.caseSensitive = true;
        $anon$1 cacheLoader = new $anon$1(this);
        this.cachedDataSourceTables = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)cacheLoader);
        this.conf = new SimpleCatalystConf(this.caseSensitive());
    }
}

