/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.package$;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ValidRDDType$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.UUIDType$;
import com.datastax.spark.connector.types.VarIntType$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.NameTools;
import com.datastax.spark.connector.util.NameTools$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.SqlRowWriter$Factory$;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.CassandraSQLRow;
import org.apache.spark.sql.cassandra.CassandraSQLRow$CassandraSQLRowReader$;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.DataTypeConverter$;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.cassandra.PredicatePushDown;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f!B\u0001\u0003\u0001\ta!aF\"bgN\fg\u000e\u001a:b'>,(oY3SK2\fG/[8o\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u000b\u0001i1CF\r\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011aB:pkJ\u001cWm]\u0005\u0003%=\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"A\u0004\u000b\n\u0005Uy!AE%og\u0016\u0014H/\u00192mKJ+G.\u0019;j_:\u0004\"AD\f\n\u0005ay!A\u0005)sk:,GMR5mi\u0016\u0014X\rZ*dC:\u0004\"AG\u000e\u000e\u0003\u0019I!\u0001\b\u0004\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005uC\ndWMU3g\u0007\u0001\u0001\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u0011Q\u000b'\r\\3SK\u001aD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.\u0019\t\u0004O)bS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r=\u0003H/[8o!\ti\u0003'D\u0001/\u0015\tyC!A\u0003usB,7/\u0003\u00022]\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011M\u0002!\u0011!Q\u0001\nQ\naBZ5mi\u0016\u0014\b+^:iI><h\u000e\u0005\u0002(k%\u0011a\u0007\u000b\u0002\b\u0005>|G.Z1o\u0011!A\u0004A!A!\u0002\u0013I\u0014\u0001\u0005;bE2,7+\u001b>f\u0013:\u0014\u0015\u0010^3t!\r9#F\u000f\t\u0003OmJ!\u0001\u0010\u0015\u0003\t1{gn\u001a\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f\u0005I1m\u001c8oK\u000e$xN\u001d\t\u0003\u0001&k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b1aY9m\u0015\tqDI\u0003\u0002\b\u000b*\u0011aiR\u0001\tI\u0006$\u0018m\u001d;bq*\t\u0001*A\u0002d_6L!AS!\u0003%\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$xN\u001d\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\u0006A!/Z1e\u0007>tg\r\u0005\u0002O#6\tqJ\u0003\u0002Q\u0007\u0006\u0019!\u000f\u001a3\n\u0005I{%\u0001\u0003*fC\u0012\u001cuN\u001c4\t\u0011Q\u0003!\u0011!Q\u0001\nU\u000b\u0011b\u001e:ji\u0016\u001cuN\u001c4\u0011\u0005YKV\"A,\u000b\u0005a\u001b\u0015AB<sSR,'/\u0003\u0002[/\nIqK]5uK\u000e{gN\u001a\u0005\t9\u0002\u0011)\u0019!C!;\u0006Q1/\u001d7D_:$X\r\u001f;\u0016\u0003y\u0003\"a\u00181\u000e\u0003\u0011I!!\u0019\u0003\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003_\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\t\u000b\u0015\u0004A\u0011\u00014\u0002\rqJg.\u001b;?)%9\u0007.\u001b6lY6tw\u000e\u0005\u0002\"\u0001!)a\u0004\u001aa\u0001A!)Q\u0005\u001aa\u0001M!)1\u0007\u001aa\u0001i!)\u0001\b\u001aa\u0001s!)a\b\u001aa\u0001\u007f!)A\n\u001aa\u0001\u001b\")A\u000b\u001aa\u0001+\")A\f\u001aa\u0001=\"1\u0011\u000f\u0001Q\u0001\nI\f\u0001\u0002^1cY\u0016$UM\u001a\t\u0003\u0001NL!\u0001^!\u0003\u0011Q\u000b'\r\\3EK\u001aDQA\u001e\u0001\u0005B]\faa]2iK6\fW#\u0001\u0017\t\u000be\u0004A\u0011\t>\u0002\r%t7/\u001a:u)\u0011Yh0a\u0002\u0011\u0005\u001db\u0018BA?)\u0005\u0011)f.\u001b;\t\r}D\b\u0019AA\u0001\u0003\u0011!\u0017\r^1\u0011\u0007}\u000b\u0019!C\u0002\u0002\u0006\u0011\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\r\u0005%\u0001\u00101\u00015\u0003%yg/\u001a:xe&$X\rC\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u0017ML'0Z%o\u0005f$Xm]\u000b\u0002u!I\u00111\u0003\u0001C\u0002\u0013\r\u0011QC\u0001\u0013G\u0006\u001c8/\u00198ee\u0006\u001cuN\u001c8fGR|'/F\u0001@\u0011\u001d\tI\u0002\u0001Q\u0001\n}\n1cY1tg\u0006tGM]1D_:tWm\u0019;pe\u0002B\u0011\"!\b\u0001\u0005\u0004%\u0019!a\b\u0002\u0011I,\u0017\rZ2p]\u001a,\u0012!\u0014\u0005\b\u0003G\u0001\u0001\u0015!\u0003N\u0003%\u0011X-\u00193d_:4\u0007\u0005\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0015\u0003\u001d\u0011\u0017m]3SI\u0012\u0004RATA\u0016\u0003_I1!!\fP\u0005U\u0019\u0015m]:b]\u0012\u0014\u0018\rV1cY\u0016\u001c6-\u00198S\t\u0012\u00032!IA\u0019\u0013\r\t\u0019D\u0001\u0002\u0010\u0007\u0006\u001c8/\u00198ee\u0006\u001c\u0016\u000b\u0014*po\"9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012!\u00032vS2$7kY1o)\t\tY\u0004\u0005\u0004\u0002>\u0005\u0005\u0013QI\u0007\u0003\u0003\u007fQ!\u0001\u0015\u0004\n\t\u0005\r\u0013q\b\u0002\u0004%\u0012#\u0005cA0\u0002H%\u0019\u0011\u0011\n\u0003\u0003\u0007I{w\u000fC\u0004\u00028\u0001!\t%!\u0014\u0015\r\u0005m\u0012qJA4\u0011!\t\t&a\u0013A\u0002\u0005M\u0013a\u0004:fcVL'/\u001a3D_2,XN\\:\u0011\u000b\u001d\n)&!\u0017\n\u0007\u0005]\u0003FA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\\\u0005\u0005dbA\u0014\u0002^%\u0019\u0011q\f\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019'!\u001a\u0003\rM#(/\u001b8h\u0015\r\ty\u0006\u000b\u0005\t\u0003S\nY\u00051\u0001\u0002l\u00059a-\u001b7uKJ\u001c\b#B\u0014\u0002V\u00055\u0004c\u0001\b\u0002p%\u0019\u0011\u0011O\b\u0003\r\u0019KG\u000e^3s\u000b\u0019\t)\b\u0001\u0003\u0002x\t9!\u000b\u0012#UsB,\u0007#\u0002(\u0002z\u0005=\u0012bAA>\u001f\na1)Y:tC:$'/\u0019*E\t\"9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0015aC7bs\n,7+\u001a7fGR$b!a!\u0002\b\u0006%\u0005\u0003BAC\u0003gj\u0011\u0001\u0001\u0005\b!\u0006u\u0004\u0019AAB\u0011!\t\t&! A\u0002\u0005M\u0003bBAG\u0001\u0011%\u0011qR\u0001\u0015[\u0006L(-\u001a)vg\"$wn\u001e8GS2$XM]:\u0015\r\u0005\r\u0015\u0011SAJ\u0011\u001d\u0001\u00161\u0012a\u0001\u0003\u0007C\u0001\"!\u001b\u0002\f\u0002\u0007\u0011Q\u0013\t\u0007\u0003/\u000b9+!\u001c\u000f\t\u0005e\u00151\u0015\b\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011qT\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013bAASQ\u00059\u0001/Y2lC\u001e,\u0017\u0002BAU\u0003W\u00131aU3r\u0015\r\t)\u000b\u000b\u0005\b\u0003_\u0003A\u0011BAY\u0003M1\u0017\u000e\u001c;feR{7)\u001d7B]\u00124\u0016\r\\;f)\u0011\t\u0019,!1\u0011\u000f\u001d\n),!\u0017\u0002:&\u0019\u0011q\u0017\u0015\u0003\rQ+\b\u000f\\33!\u0019\t9*a*\u0002<B\u0019q%!0\n\u0007\u0005}\u0006FA\u0002B]fD\u0001\"a1\u0002.\u0002\u0007\u00111X\u0001\u0007M&dG/\u001a:\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\u0006YAo\\\"rYZ\u000bG.^3t)\u0019\tI,a3\u0002P\"A\u0011QZAc\u0001\u0004\tI&\u0001\u0006d_2,XN\u001c(b[\u0016D\u0001\"!5\u0002F\u0002\u0007\u00111[\u0001\u0007m\u0006dW/Z:\u0011\u000b\u001d\n)&a/\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\u0006QAo\\\"rYZ\u000bG.^3\u0015\r\u0005m\u00161\\Ao\u0011!\ti-!6A\u0002\u0005e\u0003\u0002CAp\u0003+\u0004\r!a/\u0002\u000bY\fG.^3\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\u0006Yq\u000f[3sK\u000ec\u0017-^:f)\u0011\t\u0019,a:\t\u0011\u0005%\u0018\u0011\u001da\u0001\u0003s\u000bq\u0002];tQ\u0012|wO\u001c$jYR,'o]\u0004\b\u0003[\u0014\u0001\u0012AAx\u0003]\u0019\u0015m]:b]\u0012\u0014\u0018mU8ve\u000e,'+\u001a7bi&|g\u000eE\u0002\"\u0003c4a!\u0001\u0002\t\u0002\u0005M8\u0003BAy\u0003k\u00042aJA|\u0013\r\tI\u0010\u000b\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0015\f\t\u0010\"\u0001\u0002~R\u0011\u0011q\u001e\u0005\u000b\u0005\u0003\t\tP1A\u0005\u0002\t\r\u0011\u0001\u0005*fM\u0016\u0014XM\\2f'\u0016\u001cG/[8o+\t\u0011)\u0001\u0005\u0003\u0003\b\tEQB\u0001B\u0005\u0015\u0011\u0011YA!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001f\tAA[1wC&!\u00111\rB\u0005\u0011%\u0011)\"!=!\u0002\u0013\u0011)!A\tSK\u001a,'/\u001a8dKN+7\r^5p]\u0002B!B!\u0007\u0002r\n\u0007I\u0011\u0001B\u000e\u0003U!\u0016M\u00197f'&TX-\u00138CsR,7\u000fU1sC6,\"A!\b\u0011\u000b\t}!QE\u001d\u000e\u0005\t\u0005\"b\u0001B\u0012\u0007\u0006!Q\u000f^5m\u0013\u0011\u00119C!\t\u0003\u001f\r{gNZ5h!\u0006\u0014\u0018-\\3uKJD\u0011Ba\u000b\u0002r\u0002\u0006IA!\b\u0002-Q\u000b'\r\\3TSj,\u0017J\u001c\"zi\u0016\u001c\b+\u0019:b[\u0002B!Ba\f\u0002r\n\u0007I\u0011\u0001B\u0019\u0003)\u0001&o\u001c9feRLWm]\u000b\u0003\u0005g\u0001bA!\u000e\u0003<\tuQB\u0001B\u001c\u0015\r\u0011I\u0004K\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAU\u0005oA\u0011Ba\u0010\u0002r\u0002\u0006IAa\r\u0002\u0017A\u0013x\u000e]3si&,7\u000f\t\u0005\u000b\u0005\u0007\n\tP1A\u0005\u0002\t\r\u0011A\u00053fM\u0006,H\u000e^\"mkN$XM\u001d(b[\u0016D\u0011Ba\u0012\u0002r\u0002\u0006IA!\u0002\u0002'\u0011,g-Y;mi\u000ecWo\u001d;fe:\u000bW.\u001a\u0011\t\u0011\t-\u0013\u0011\u001fC\u0001\u0005\u001b\nQ!\u00199qYf$\u0012b\u001aB(\u0005#\u0012\u0019F!\u0018\t\ry\u0011I\u00051\u0001!\u0011\u0019a&\u0011\na\u0001=\"Q!Q\u000bB%!\u0003\u0005\rAa\u0016\u0002\u000f=\u0004H/[8ogB\u0019\u0011E!\u0017\n\u0007\tm#A\u0001\fDCN\u001c\u0018M\u001c3sCN{WO]2f\u001fB$\u0018n\u001c8t\u0011!1(\u0011\nI\u0001\u0002\u00041\u0003\u0002\u0003B1\u0003c$\tAa\u0019\u0002!\r|gn]8mS\u0012\fG/Z\"p]\u001a\u001cHC\u0003B3\u0005W\u0012yG!\u001f\u0003|A\u0019!Da\u001a\n\u0007\t%dAA\u0005Ta\u0006\u00148nQ8oM\"A!Q\u000eB0\u0001\u0004\u0011)'A\u0005ta\u0006\u00148nQ8oM\"A!\u0011\u000fB0\u0001\u0004\u0011\u0019(A\u0004tc2\u001cuN\u001c4\u0011\u0011\u0005m#QOA-\u00033JAAa\u001e\u0002f\t\u0019Q*\u00199\t\ry\u0011y\u00061\u0001!\u0011!\u0011iHa\u0018A\u0002\tM\u0014!\u0003;bE2,7i\u001c8g\u0011)\u0011\t)!=\u0012\u0002\u0013\u0005!1Q\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0011\u0016\u0005\u0005/\u00129i\u000b\u0002\u0003\nB!!1\u0012BK\u001b\t\u0011iI\u0003\u0003\u0003\u0010\nE\u0015!C;oG\",7m[3e\u0015\r\u0011\u0019\nK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BL\u0005\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011Y*!=\u0012\u0002\u0013\u0005!QT\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0014\u0016\u0004M\t\u001d\u0005")
public class CassandraSourceRelation
extends BaseRelation
implements InsertableRelation,
PrunedFilteredScan,
Logging {
    private final TableRef tableRef;
    private final Option<StructType> userSpecifiedSchema;
    private final boolean filterPushdown;
    private final Option<Object> tableSizeInBytes;
    private final CassandraConnector connector;
    private final WriteConf writeConf;
    private final SQLContext sqlContext;
    public final TableDef org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef;
    private final CassandraConnector cassandraConnector;
    private final ReadConf readconf;
    private final CassandraTableScanRDD<CassandraSQLRow> baseRdd;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Option<StructType> apply$default$4() {
        return CassandraSourceRelation$.MODULE$.apply$default$4();
    }

    public static CassandraSourceOptions apply$default$3() {
        return CassandraSourceRelation$.MODULE$.apply$default$3();
    }

    public static SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> map, TableRef tableRef, Map<String, String> map2) {
        return CassandraSourceRelation$.MODULE$.consolidateConfs(sparkConf, map, tableRef, map2);
    }

    public static CassandraSourceRelation apply(TableRef tableRef, SQLContext sQLContext, CassandraSourceOptions cassandraSourceOptions, Option<StructType> option) {
        return CassandraSourceRelation$.MODULE$.apply(tableRef, sQLContext, cassandraSourceOptions, option);
    }

    public static String defaultClusterName() {
        return CassandraSourceRelation$.MODULE$.defaultClusterName();
    }

    public static Seq<ConfigParameter<Option<Object>>> Properties() {
        return CassandraSourceRelation$.MODULE$.Properties();
    }

    public static ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return CassandraSourceRelation$.MODULE$.TableSizeInBytesParam();
    }

    public static String ReferenceSection() {
        return CassandraSourceRelation$.MODULE$.ReferenceSection();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        return (StructType)this.userSpecifiedSchema.getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final StructType apply() {
                return StructType$.MODULE$.apply((Seq)this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columns().map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(ColumnDef column) {
                        return DataTypeConverter$.MODULE$.toStructField(column);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void insert(DataFrame data, boolean overwrite) {
        Object object;
        if (overwrite) {
            String keyspace = Quote$.MODULE$.quote(this.tableRef.keyspace());
            String table = Quote$.MODULE$.quote(this.tableRef.table());
            object = this.connector.withSessionDo(new scala.Serializable(this, keyspace, table){
                public static final long serialVersionUID = 0L;
                private final String keyspace$1;
                private final String table$1;

                public final ResultSet apply(Session session) {
                    return session.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyspace$1, this.table$1})));
                }
                {
                    this.keyspace$1 = keyspace$1;
                    this.table$1 = table$1;
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        SqlRowWriter$Factory$ rwf = SqlRowWriter$Factory$.MODULE$;
        SomeColumns columns = new SomeColumns((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])data.columns()).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnRef apply(String x) {
                return package$.MODULE$.toNamedColumnRef(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class)))));
        package$.MODULE$.toRDDFunctions(data.rdd()).saveToCassandra(this.tableRef.keyspace(), this.tableRef.table(), columns, this.writeConf, this.cassandraConnector(), rwf);
    }

    public long sizeInBytes() {
        return BoxesRunTime.unboxToLong((Object)this.tableSizeInBytes.getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.sqlContext().conf().defaultSizeInBytes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public CassandraConnector cassandraConnector() {
        return this.cassandraConnector;
    }

    public ReadConf readconf() {
        return this.readconf;
    }

    public RDD<Row> buildScan() {
        return this.baseRdd;
    }

    public RDD<Row> buildScan(String[] requiredColumns2, Filter[] filters) {
        CassandraRDD<Row> cassandraRDD;
        CassandraRDD<Row> prunedRdd = this.maybeSelect(this.baseRdd, requiredColumns2);
        this.logInfo((Function0<String>)new scala.Serializable(this, filters){
            public static final long serialVersionUID = 0L;
            private final Filter[] filters$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"filters: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.filters$1).mkString(", ")}));
            }
            {
                this.filters$1 = filters$1;
            }
        });
        if (this.filterPushdown) {
            PredicatePushDown<Filter> filterPushdown = new PredicatePushDown<Filter>(Predef$.MODULE$.refArrayOps((Object[])filters).toSet(), this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef, PredicateOps$FilterOps$.MODULE$);
            Seq pushdownFilters = filterPushdown.predicatesToPushDown().toSeq();
            this.logInfo((Function0<String>)new scala.Serializable(this, pushdownFilters){
                public static final long serialVersionUID = 0L;
                private final Seq pushdownFilters$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pushdown filters: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pushdownFilters$1.toString()}));
                }
                {
                    this.pushdownFilters$1 = pushdownFilters$1;
                }
            });
            CassandraRDD<CassandraSQLRow> filteredRdd = this.maybePushdownFilters(prunedRdd, (Seq<Filter>)pushdownFilters);
            cassandraRDD = filteredRdd;
        } else {
            cassandraRDD = prunedRdd;
        }
        CassandraRDD<Row> prunedFilteredRdd = cassandraRDD;
        return prunedFilteredRdd;
    }

    private CassandraRDD<CassandraSQLRow> maybeSelect(CassandraRDD<CassandraSQLRow> rdd, String[] requiredColumns2) {
        return Predef$.MODULE$.refArrayOps((Object[])requiredColumns2).nonEmpty() ? rdd.select((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns2).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnRef apply(String column) {
                return package$.MODULE$.toNamedColumnRef(column);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class))))) : rdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CassandraRDD<CassandraSQLRow> maybePushdownFilters(CassandraRDD<CassandraSQLRow> rdd, Seq<Filter> filters) {
        Tuple2<String, Seq<Object>> tuple2 = this.whereClause(filters);
        if (tuple2 == null) return rdd;
        String cql2 = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        if (!values.nonEmpty()) return rdd;
        return rdd.where(cql2, (Seq<Object>)values);
    }

    public Tuple2<String, Seq<Object>> org$apache$spark$sql$cassandra$CassandraSourceRelation$$filterToCqlAndValue(Object filter) {
        block8: {
            Tuple2 tuple2;
            block3: {
                Object object;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    object = filter;
                                    if (!(object instanceof EqualTo)) break block2;
                                    EqualTo equalTo = (EqualTo)object;
                                    String attribute = equalTo.attribute();
                                    Object value2 = equalTo.value();
                                    tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value2)})));
                                    break block3;
                                }
                                if (!(object instanceof LessThan)) break block4;
                                LessThan lessThan = (LessThan)object;
                                String attribute = lessThan.attribute();
                                Object value3 = lessThan.value();
                                tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value3)})));
                                break block3;
                            }
                            if (!(object instanceof LessThanOrEqual)) break block5;
                            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)object;
                            String attribute = lessThanOrEqual.attribute();
                            Object value4 = lessThanOrEqual.value();
                            tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <= ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value4)})));
                            break block3;
                        }
                        if (!(object instanceof GreaterThan)) break block6;
                        GreaterThan greaterThan = (GreaterThan)object;
                        String attribute = greaterThan.attribute();
                        Object value5 = greaterThan.value();
                        tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value5)})));
                        break block3;
                    }
                    if (!(object instanceof GreaterThanOrEqual)) break block7;
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)object;
                    String attribute = greaterThanOrEqual.attribute();
                    Object value6 = greaterThanOrEqual.value();
                    tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value6)})));
                    break block3;
                }
                if (!(object instanceof In)) break block8;
                In in = (In)object;
                String attribute = in.attribute();
                Object[] values = in.values();
                tuple2 = new Tuple2((Object)new StringBuilder().append((Object)Quote$.MODULE$.quote(attribute)).append((Object)" IN ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$2) {
                        return "?";
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("(", ", ", ")")).toString(), this.toCqlValues(attribute, values));
            }
            return tuple2;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It's not a valid filter ", " to be pushed down, only >, <, >=, <= and In are allowed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter})));
    }

    private Seq<Object> toCqlValues(String columnName2, Object[] values) {
        return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new scala.Serializable(this, columnName2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;
            private final String columnName$1;

            public final Object apply(Object x$3) {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(this.columnName$1, x$3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnName$1 = columnName$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
    }

    public Object org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(String columnName2, Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof Decimal) {
            Decimal decimal = (Decimal)object2;
            ColumnType<?> columnType = ((ColumnDef)this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columnByName().apply((Object)columnName2)).columnType();
            VarIntType$ varIntType$ = VarIntType$.MODULE$;
            boolean isVarIntColumn = !(columnType != null ? !columnType.equals(varIntType$) : varIntType$ != null);
            object = isVarIntColumn ? decimal.toJavaBigDecimal().toBigInteger() : decimal;
        } else if (object2 instanceof UTF8String) {
            Serializable serializable;
            ColumnType<?> columnType;
            UTF8String uTF8String = (UTF8String)object2;
            ColumnType<?> columnType2 = columnType = ((ColumnDef)this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columnByName().apply((Object)columnName2)).columnType();
            InetType$ inetType$ = InetType$.MODULE$;
            if (!(columnType2 != null ? !columnType2.equals(inetType$) : inetType$ != null)) {
                serializable = InetAddress.getByName(uTF8String.toString());
            } else {
                ColumnType<?> columnType3 = columnType;
                UUIDType$ uUIDType$ = UUIDType$.MODULE$;
                serializable = !(columnType3 != null ? !columnType3.equals(uUIDType$) : uUIDType$ != null) ? UUID.fromString(uTF8String.toString()) : uTF8String;
            }
            object = serializable;
        } else {
            object = object2;
        }
        return object;
    }

    private Tuple2<String, Seq<Object>> whereClause(Seq<Object> pushdownFilters) {
        Seq cqlValue = (Seq)pushdownFilters.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final Tuple2<String, Seq<Object>> apply(Object filter) {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$filterToCqlAndValue(filter);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String cql2 = ((TraversableOnce)cqlValue.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Seq<Object>> x$4) {
                return (String)x$4._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        Seq args = (Seq)cqlValue.flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<String, Seq<Object>> x$5) {
                return (Seq)x$5._2();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)cql2, (Object)args);
    }

    /*
     * WARNING - void declaration
     */
    public CassandraSourceRelation(TableRef tableRef, Option<StructType> userSpecifiedSchema, boolean filterPushdown, Option<Object> tableSizeInBytes, CassandraConnector connector, ReadConf readConf, WriteConf writeConf, SQLContext sqlContext) {
        this.tableRef = tableRef;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.filterPushdown = filterPushdown;
        this.tableSizeInBytes = tableSizeInBytes;
        this.connector = connector;
        this.writeConf = writeConf;
        this.sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
        String tableName = tableRef.table();
        String keyspaceName = tableRef.keyspace();
        Option option = Schema$.MODULE$.fromCassandra(connector, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (option instanceof Some) {
            TableDef t;
            TableDef tableDef;
            Some some = (Some)option;
            this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef = tableDef = (t = (TableDef)some.x());
            this.cassandraConnector = connector;
            this.readconf = readConf;
            this.baseRdd = package$.MODULE$.toSparkContextFunctions(sqlContext.sparkContext()).cassandraTable(tableRef.keyspace(), tableRef.table(), this.cassandraConnector(), this.readconf(), ClassTag$.MODULE$.apply(CassandraSQLRow.class), CassandraSQLRow$CassandraSQLRowReader$.MODULE$, ValidRDDType$.MODULE$.javaSerializableAsValidRDDType());
            return;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            void var9_9;
            void var10_10;
            Metadata metadata = (Metadata)connector.withClusterDo(new $anonfun$1(this));
            Option<NameTools.Suggestions> suggestions = NameTools$.MODULE$.getSuggestions(metadata, (String)var10_10, (String)var9_9);
            String errorMessage = NameTools$.MODULE$.getErrorString((String)var10_10, (String)var9_9, suggestions);
            throw new IOException(errorMessage);
        }
        throw new MatchError((Object)option);
    }
}

