/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.util;

import com.datastax.spark.connector.cql.AuthConfFactory;
import com.datastax.spark.connector.cql.AuthConfFactory$;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.types.ColumnTypeConf$;
import com.datastax.spark.connector.util.ConfigCheck;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.writer.WriteConf$;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.CassandraSQLContext$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class ConfigCheck$ {
    public static final ConfigCheck$ MODULE$;
    private final double MatchThreshold;
    private final String Prefix;
    private final Set<ConfigParameter<?>> validStaticProperties;
    private final Set<String> validStaticPropertyNames;

    static {
        new ConfigCheck$();
    }

    public double MatchThreshold() {
        return this.MatchThreshold;
    }

    public String Prefix() {
        return this.Prefix;
    }

    public Set<ConfigParameter<?>> validStaticProperties() {
        return this.validStaticProperties;
    }

    public Set<String> validStaticPropertyNames() {
        return this.validStaticPropertyNames;
    }

    public void checkConfig(SparkConf conf) {
        CassandraConnectionFactory connectionFactory = CassandraConnectionFactory$.MODULE$.fromSparkConf(conf);
        AuthConfFactory authConfFactory = AuthConfFactory$.MODULE$.fromSparkConf(conf);
        Set extraProps = (Set)connectionFactory.properties().$plus$plus(authConfFactory.properties());
        Seq<String> unknownProps = this.unknownProperties(conf, (Set<String>)extraProps);
        if (unknownProps.nonEmpty()) {
            Seq suggestions = (Seq)unknownProps.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Seq<String>> apply(String u) {
                    return new Tuple2((Object)u, ConfigCheck$.MODULE$.suggestedProperties(u, ConfigCheck$.MODULE$.suggestedProperties$default$2()));
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw new ConfigCheck.ConnectorConfigurationException(unknownProps, (Map<String, Seq<String>>)suggestions.toMap(Predef$.MODULE$.conforms()));
        }
    }

    public Seq<String> unknownProperties(SparkConf conf, Set<String> extraProps) {
        Set validProps = (Set)this.validStaticPropertyNames().$plus$plus(extraProps);
        String[] scEnv = (String[])Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$2) {
                Tuple2<String, String> tuple2 = x$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    boolean bl = key.startsWith(ConfigCheck$.MODULE$.Prefix());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x$3) {
                Tuple2<String, String> tuple2 = x$3;
                if (tuple2 != null) {
                    String key;
                    String string = key = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])scEnv).withFilter((Function1)new Serializable(validProps){
            public static final long serialVersionUID = 0L;
            private final Set validProps$1;

            public final boolean apply(String key) {
                return !this.validProps$1.contains((Object)key);
            }
            {
                this.validProps$1 = validProps$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String key) {
                return key;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Set<String> unknownProperties$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public Seq<String> suggestedProperties(String unknownProp, Set<String> extraProps) {
        Set validProps = (Set)this.validStaticPropertyNames().$plus$plus(extraProps);
        String[] unknownFragments = new StringOps(Predef$.MODULE$.augmentString(unknownProp)).stripPrefix(this.Prefix()).split("\\.");
        return (Seq)validProps.toSeq().filter((Function1)new Serializable(unknownFragments){
            public static final long serialVersionUID = 0L;
            private final String[] unknownFragments$1;

            public final boolean apply(String knownProp) {
                String[] knownFragments = new StringOps(Predef$.MODULE$.augmentString(knownProp)).stripPrefix(ConfigCheck$.MODULE$.Prefix()).split("\\.");
                return Predef$.MODULE$.refArrayOps((Object[])this.unknownFragments$1).forall((Function1)new Serializable(this, knownFragments){
                    public static final long serialVersionUID = 0L;
                    private final String[] knownFragments$1;

                    public final boolean apply(String unknown) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.knownFragments$1).exists((Function1)new Serializable(this, unknown){
                            public static final long serialVersionUID = 0L;
                            private final String unknown$1;

                            public final boolean apply(String known) {
                                double matchScore = StringUtils.getJaroWinklerDistance((CharSequence)this.unknown$1, (CharSequence)known);
                                return matchScore >= ConfigCheck$.MODULE$.MatchThreshold();
                            }
                            {
                                this.unknown$1 = unknown$1;
                            }
                        });
                    }
                    {
                        this.knownFragments$1 = knownFragments$1;
                    }
                });
            }
            {
                this.unknownFragments$1 = unknownFragments$1;
            }
        });
    }

    public Set<String> suggestedProperties$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private ConfigCheck$() {
        MODULE$ = this;
        this.MatchThreshold = 0.85;
        this.Prefix = "spark.cassandra.";
        this.validStaticProperties = (Set)WriteConf$.MODULE$.Properties().$plus$plus(ReadConf$.MODULE$.Properties()).$plus$plus(CassandraConnectorConf$.MODULE$.Properties()).$plus$plus(AuthConfFactory$.MODULE$.Properties()).$plus$plus(CassandraConnectionFactory$.MODULE$.Properties()).$plus$plus(CassandraSQLContext$.MODULE$.Properties()).$plus$plus(CassandraSourceRelation$.MODULE$.Properties()).$plus$plus(ColumnTypeConf$.MODULE$.Properties());
        this.validStaticPropertyNames = (Set)this.validStaticProperties().map((Function1)new anonfun.1(), Set$.MODULE$.canBuildFrom());
    }
}

