/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.KeyspaceDef;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.CassandraCatalog$;
import org.apache.spark.sql.cassandra.CassandraSQLContext;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceOptions$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.catalyst.CatalystConf;
import org.apache.spark.sql.catalyst.SimpleCatalystConf;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Catalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.sources.BaseRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]e!B\u0001\u0003\u0001\ta!\u0001E\"bgN\fg\u000e\u001a:b\u0007\u0006$\u0018\r\\8h\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\t\u0001i1c\u0007\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001C1oC2L8/[:\u000b\u0005a!\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005i)\"aB\"bi\u0006dwn\u001a\t\u00039ui\u0011AB\u0005\u0003=\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003#\u0003\r\u00197oY\u0002\u0001!\t\u0019C%D\u0001\u0003\u0013\t)#AA\nDCN\u001c\u0018M\u001c3sCN\u000bFjQ8oi\u0016DH\u000fC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0003S)\u0002\"a\t\u0001\t\u000b\u00012\u0003\u0019\u0001\u0012\t\u000f1\u0002!\u0019!C\u0001[\u0005i1-Y:f'\u0016t7/\u001b;jm\u0016,\u0012A\f\t\u0003\u001d=J!\u0001M\b\u0003\u000f\t{w\u000e\\3b]\"1!\u0007\u0001Q\u0001\n9\nabY1tKN+gn]5uSZ,\u0007\u0005\u0003\u00055\u0001\t\u0007I\u0011\u0001\u00026\u0003Y\u0019\u0017m\u00195fI\u0012\u000bG/Y*pkJ\u001cW\rV1cY\u0016\u001cX#\u0001\u001c\u0011\t]\u0002%IR\u0007\u0002q)\u0011\u0011HO\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003wq\naaY8n[>t'BA\u001f?\u0003\u00199wn\\4mK*\tq(A\u0002d_6L!!\u0011\u001d\u0003\u00191{\u0017\rZ5oO\u000e\u000b7\r[3\u0011\u0005\r#U\"A\f\n\u0005\u0015;\"a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u0017^\tQ\u0001\u001d7b]NL!!\u0014%\u0003\u00171{w-[2bYBc\u0017M\u001c\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002\u001c\u0002/\r\f7\r[3e\t\u0006$\u0018mU8ve\u000e,G+\u00192mKN\u0004\u0003\"B)\u0001\t\u0003\u0012\u0016A\u00047p_.,\bOU3mCRLwN\u001c\u000b\u0004\rN+\u0006\"\u0002+Q\u0001\u0004\u0011\u0015A\u0003;bE2,\u0017\nZ3oi\"9a\u000b\u0015I\u0001\u0002\u00049\u0016!B1mS\u0006\u001c\bc\u0001\bY5&\u0011\u0011l\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005msfB\u0001\b]\u0013\tiv\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/\u0010\u0011\u0015\u0011\u0007\u0001\"\u0003d\u00035\u0011W/\u001b7e%\u0016d\u0017\r^5p]R\u0011a\t\u001a\u0005\u0006K\u0006\u0004\rAQ\u0001\u0010i\u0006\u0014G.Z%eK:$\u0018NZ5fe\")q\r\u0001C\u0005Q\u00061r-\u001a;DYV\u001cH/\u001a:E\u0005R\u000b'\r\\3OC6,7\u000f\u0006\u0002jYB)aB\u001b.[5&\u00111n\u0004\u0002\u0007)V\u0004H.Z\u001a\t\u000bQ3\u0007\u0019\u0001\"\t\u000b9\u0004A\u0011I8\u0002\u001bI,w-[:uKJ$\u0016M\u00197f)\r\u00018\u000f\u001e\t\u0003\u001dEL!A]\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006)6\u0004\rA\u0011\u0005\u0006k6\u0004\rAR\u0001\u0005a2\fg\u000eC\u0003x\u0001\u0011\u0005\u00030A\bv]J,w-[:uKJ$\u0016M\u00197f)\t\u0001\u0018\u0010C\u0003Um\u0002\u0007!\tC\u0003|\u0001\u0011\u0005C0A\nv]J,w-[:uKJ\fE\u000e\u001c+bE2,7\u000fF\u0001q\u0011\u0015q\b\u0001\"\u0011\u0000\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\u0015\u00079\n\t\u0001C\u0003U{\u0002\u0007!\tC\u0004\u0002\u0006\u0001!\t%a\u0002\u0002\u0013\u001d,G\u000fV1cY\u0016\u001cH\u0003BA\u0005\u0003O\u0001b!a\u0003\u0002\u001c\u0005\u0005b\u0002BA\u0007\u0003/qA!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'\t\u0013A\u0002\u001fs_>$h(C\u0001\u0011\u0013\r\tIbD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti\"a\b\u0003\u0007M+\u0017OC\u0002\u0002\u001a=\u0001RADA\u00125:J1!!\n\u0010\u0005\u0019!V\u000f\u001d7fe!9\u0011\u0011FA\u0002\u0001\u00049\u0016\u0001\u00043bi\u0006\u0014\u0017m]3OC6,\u0007bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0017O\u0016$H+\u00192mKN4%o\\7DCN\u001c\u0018M\u001c3sCR!\u0011\u0011BA\u0019\u0011\u001d\tI#a\u000bA\u0002]Cq!!\u000e\u0001\t\u0003\t9$\u0001\nhKR$\u0016M\u00197fg\u001a\u0013x.\\\"bG\",GCBA\u0005\u0003s\tY\u0004C\u0004\u0002*\u0005M\u0002\u0019A,\t\u0013\u0005u\u00121\u0007I\u0001\u0002\u00049\u0016aB2mkN$XM\u001d\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0003U9W\r^\"bgN\fg\u000e\u001a:b\u0007>tg.Z2u_J$B!!\u0012\u0002\\A!\u0011qIA,\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013aA2rY*!\u0011qJA)\u0003%\u0019wN\u001c8fGR|'OC\u0002\b\u0003'R1!!\u0016?\u0003!!\u0017\r^1ti\u0006D\u0018\u0002BA-\u0003\u0013\u0012!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\"A\u0011QLA \u0001\u0004\ty&\u0001\u0005uC\ndWMU3g!\r\u0019\u0013\u0011M\u0005\u0004\u0003G\u0012!\u0001\u0003+bE2,'+\u001a4\t\u0013\u0005\u001d\u0004A1A\u0005B\u0005%\u0014\u0001B2p]\u001a,\"!a\u001b\u0011\u0007\r\u000bi'C\u0002\u0002p]\u0011AbQ1uC2L8\u000f^\"p]\u001aD\u0001\"a\u001d\u0001A\u0003%\u00111N\u0001\u0006G>tg\r\t\u0005\b\u0003o\u0002A\u0011IA=\u00031\u0011XM\u001a:fg\"$\u0016M\u00197f)\r\u0001\u00181\u0010\u0005\u0007)\u0006U\u0004\u0019\u0001\"\t\u0013\u0005}\u0004!%A\u0005\u0002\u0005\u0005\u0015\u0001H4fiR\u000b'\r\\3t\rJ|WnQ1dQ\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0007S3aVACW\t\t9\t\u0005\u0003\u0002\n\u0006MUBAAF\u0015\u0011\ti)a$\u0002\u0013Ut7\r[3dW\u0016$'bAAI\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00151\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class CassandraCatalog
implements Catalog,
Logging {
    public final CassandraSQLContext org$apache$spark$sql$cassandra$CassandraCatalog$$csc;
    private final boolean caseSensitive;
    private final LoadingCache<TableIdentifier, LogicalPlan> cachedDataSourceTables;
    private final CatalystConf conf;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String getTableName(TableIdentifier tableIdent) {
        return Catalog.class.getTableName((Catalog)this, (TableIdentifier)tableIdent);
    }

    public Option<String> lookupRelation$default$2() {
        return Catalog.class.lookupRelation$default$2((Catalog)this);
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public LoadingCache<TableIdentifier, LogicalPlan> cachedDataSourceTables() {
        return this.cachedDataSourceTables;
    }

    public LogicalPlan lookupRelation(TableIdentifier tableIdent, Option<String> alias) {
        LogicalPlan tableLogicPlan = (LogicalPlan)this.cachedDataSourceTables().get((Object)tableIdent);
        return (LogicalPlan)alias.map((Function1)new Serializable(this, tableLogicPlan){
            public static final long serialVersionUID = 0L;
            private final LogicalPlan tableLogicPlan$1;

            public final Subquery apply(String a) {
                return new Subquery(a, this.tableLogicPlan$1);
            }
            {
                this.tableLogicPlan$1 = tableLogicPlan$1;
            }
        }).getOrElse((Function0)new Serializable(this, tableLogicPlan){
            public static final long serialVersionUID = 0L;
            private final LogicalPlan tableLogicPlan$1;

            public final LogicalPlan apply() {
                return this.tableLogicPlan$1;
            }
            {
                this.tableLogicPlan$1 = tableLogicPlan$1;
            }
        });
    }

    public LogicalPlan org$apache$spark$sql$cassandra$CassandraCatalog$$buildRelation(TableIdentifier tableIdentifier) {
        Tuple3<String, String, String> tuple3 = this.getClusterDBTableNames(tableIdentifier);
        if (tuple3 != null) {
            Tuple3 tuple32;
            String cluster = (String)tuple3._1();
            String database = (String)tuple3._2();
            String table = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)cluster, (Object)database, (Object)table);
            String cluster2 = (String)tuple33._1();
            String database2 = (String)tuple33._2();
            String table2 = (String)tuple33._3();
            TableRef tableRef = new TableRef(table2, database2, (Option<String>)Option$.MODULE$.apply((Object)cluster2));
            CassandraSourceRelation sourceRelation = CassandraSourceRelation$.MODULE$.apply(tableRef, this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc, new CassandraSourceOptions(CassandraSourceOptions$.MODULE$.apply$default$1(), CassandraSourceOptions$.MODULE$.apply$default$2()), CassandraSourceRelation$.MODULE$.apply$default$4());
            return new Subquery(table2, (LogicalPlan)new LogicalRelation((BaseRelation)sourceRelation, LogicalRelation$.MODULE$.apply$default$2()));
        }
        throw new MatchError(tuple3);
    }

    private Tuple3<String, String, String> getClusterDBTableNames(TableIdentifier tableIdent) {
        String database = (String)tableIdent.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getKeyspace();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String table = tableIdent.table();
        return new Tuple3((Object)this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster(), (Object)database, (Object)table);
    }

    public void registerTable(TableIdentifier tableIdent, LogicalPlan plan) {
        this.cachedDataSourceTables().put((Object)tableIdent, (Object)plan);
    }

    public void unregisterTable(TableIdentifier tableIdent) {
        this.cachedDataSourceTables().invalidate((Object)tableIdent);
    }

    public void unregisterAllTables() {
        this.cachedDataSourceTables().invalidateAll();
    }

    public boolean tableExists(TableIdentifier tableIdent) {
        Tuple3<String, String, String> tuple3 = this.getClusterDBTableNames(tableIdent);
        if (tuple3 != null) {
            boolean bl;
            Tuple3 tuple32;
            String cluster = (String)tuple3._1();
            String database = (String)tuple3._2();
            String table = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)cluster, (Object)database, (Object)table);
            String cluster2 = (String)tuple33._1();
            String database2 = (String)tuple33._2();
            String table2 = (String)tuple33._3();
            boolean cached = this.cachedDataSourceTables().asMap().containsKey(tableIdent);
            if (cached) {
                bl = true;
            } else {
                TableRef tableRef = new TableRef(table2, database2, (Option<String>)Option$.MODULE$.apply((Object)cluster2));
                Schema schema2 = Schema$.MODULE$.fromCassandra(this.getCassandraConnector(tableRef), Schema$.MODULE$.fromCassandra$default$2(), Schema$.MODULE$.fromCassandra$default$3());
                Option tabDef = schema2.keyspaceByName().get((Object)database2).flatMap((Function1)new Serializable(this, table2){
                    public static final long serialVersionUID = 0L;
                    private final String table$1;

                    public final Option<TableDef> apply(KeyspaceDef ksDef) {
                        return ksDef.tableByName().get((Object)this.table$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TableDef apply(TableDef tabDef) {
                                return tabDef;
                            }
                        });
                    }
                    {
                        this.table$1 = table$1;
                    }
                });
                bl = tabDef.nonEmpty();
            }
            return bl;
        }
        throw new MatchError(tuple3);
    }

    public Seq<Tuple2<String, Object>> getTables(Option<String> databaseName) {
        String cluster = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
        Seq tableNamesFromCache = (Seq)this.getTablesFromCache(databaseName, (Option<String>)Option$.MODULE$.apply((Object)cluster)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$3) {
                return (String)x$3._1();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Tuple2<String, Object>> tablesFromCassandra = this.getTablesFromCassandra(databaseName);
        Seq tablesOnlyInCache = (Seq)((TraversableLike)tableNamesFromCache.diff((GenSeq)tablesFromCassandra.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$4) {
                return (String)x$4._1();
            }
        }, Seq$.MODULE$.canBuildFrom()))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String name) {
                return new Tuple2((Object)name, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)tablesFromCassandra.$plus$plus((GenTraversableOnce)tablesOnlyInCache, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, Object>> getTablesFromCassandra(Option<String> databaseName) {
        String cluster = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
        TableRef tableRef = new TableRef("", (String)databaseName.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), (Option<String>)Option$.MODULE$.apply((Object)cluster));
        Schema schema2 = Schema$.MODULE$.fromCassandra(this.getCassandraConnector(tableRef), databaseName, Schema$.MODULE$.fromCassandra$default$3());
        return (Seq)schema2.keyspaces().toSeq().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, Object>> apply(KeyspaceDef ksDef) {
                return (Set)ksDef.tables().map((Function1)new Serializable(this, ksDef){
                    public static final long serialVersionUID = 0L;
                    private final KeyspaceDef ksDef$1;

                    public final Tuple2<String, Object> apply(TableDef tableDef) {
                        return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ksDef$1.keyspaceName(), tableDef.tableName()})), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    {
                        this.ksDef$1 = ksDef$1;
                    }
                }, Set$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, Object>> getTablesFromCache(Option<String> databaseName, Option<String> cluster) {
        String clusterName = (String)cluster.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return (Seq)JavaConversions$.MODULE$.asScalaSet(this.cachedDataSourceTables().asMap().keySet()).toSeq().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TableIdentifier check$ifrefutable$1) {
                Seq seq;
                Some some;
                TableIdentifier tableIdentifier = check$ifrefutable$1;
                boolean bl = tableIdentifier instanceof Seq && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)tableIdentifier)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0;
                return bl;
            }
        }).withFilter((Function1)new Serializable(this, databaseName, clusterName){
            public static final long serialVersionUID = 0L;
            private final Option databaseName$1;
            private final String clusterName$1;

            public final boolean apply(TableIdentifier x$6) {
                Seq seq;
                Some some;
                TableIdentifier tableIdentifier = x$6;
                if (tableIdentifier instanceof Seq && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)tableIdentifier)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object c = ((SeqLike)some.get()).apply(0);
                    Object db = ((SeqLike)some.get()).apply(1);
                    Object object = c;
                    String string = this.clusterName$1;
                    boolean bl = !(object != null ? !object.equals(string) : string != null) && this.databaseName$1.forall((Function1)new Serializable(this, db){
                        public static final long serialVersionUID = 0L;
                        private final Object db$1;

                        public final boolean apply(String x$5) {
                            String string = x$5;
                            Object object = this.db$1;
                            return !(string != null ? !string.equals(object) : object != null);
                        }
                        {
                            this.db$1 = db$1;
                        }
                    });
                    return bl;
                }
                throw new MatchError((Object)tableIdentifier);
            }
            {
                this.databaseName$1 = databaseName$1;
                this.clusterName$1 = clusterName$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(TableIdentifier x$7) {
                Seq seq;
                Some some;
                TableIdentifier tableIdentifier = x$7;
                if (tableIdentifier instanceof Seq && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)tableIdentifier)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object db = ((SeqLike)some.get()).apply(1);
                    Object table = ((SeqLike)some.get()).apply(2);
                    Tuple2 tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db, table})), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return tuple2;
                }
                throw new MatchError((Object)tableIdentifier);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> getTablesFromCache$default$2() {
        return None$.MODULE$;
    }

    private CassandraConnector getCassandraConnector(TableRef tableRef) {
        SparkConf sparkConf = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.sparkContext().getConf().clone();
        Map sqlConf = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getAllConfs();
        SparkConf conf = CassandraSourceRelation$.MODULE$.consolidateConfs(sparkConf, (Map<String, String>)sqlConf, tableRef, (Map<String, String>)Predef$.MODULE$.Map().empty());
        return new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
    }

    public CatalystConf conf() {
        return this.conf;
    }

    public void refreshTable(TableIdentifier tableIdent) {
        this.cachedDataSourceTables().refresh((Object)tableIdent);
    }

    public CassandraCatalog(CassandraSQLContext csc) {
        this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc = csc;
        Catalog.class.$init$((Catalog)this);
        Logging.class.$init$((Logging)this);
        this.caseSensitive = true;
        $anon$1 cacheLoader = new $anon$1(this);
        this.cachedDataSourceTables = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)cacheLoader);
        this.conf = new SimpleCatalystConf(this.caseSensitive());
    }
}

