/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ValidRDDType$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.UUIDType$;
import com.datastax.spark.connector.types.VarIntType$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.NameTools;
import com.datastax.spark.connector.util.NameTools$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.util.ReflectionUtil$;
import com.datastax.spark.connector.writer.SqlRowWriter$Factory$;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.BasicCassandraPredicatePushDown;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSQLRow;
import org.apache.spark.sql.cassandra.CassandraSQLRow$CassandraSQLRowReader$;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.DataTypeConverter$;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r%a!B\u0001\u0003\u0001\ta!aF\"bgN\fg\u000e\u001a:b'>,(oY3SK2\fG/[8o\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u000b\u0001i1CF\r\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011aB:pkJ\u001cWm]\u0005\u0003%=\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"A\u0004\u000b\n\u0005Uy!AE%og\u0016\u0014H/\u00192mKJ+G.\u0019;j_:\u0004\"AD\f\n\u0005ay!A\u0005)sk:,GMR5mi\u0016\u0014X\rZ*dC:\u0004\"AG\u000e\u000e\u0003\u0019I!\u0001\b\u0004\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005uC\ndWMU3g\u0007\u0001\u0001\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u0011Q\u000b'\r\\3SK\u001aD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.\u0019\t\u0004O)bS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r=\u0003H/[8o!\ti\u0003'D\u0001/\u0015\tyC!A\u0003usB,7/\u0003\u00022]\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011M\u0002!\u0011!Q\u0001\nQ\naBZ5mi\u0016\u0014\b+^:iI><h\u000e\u0005\u0002(k%\u0011a\u0007\u000b\u0002\b\u0005>|G.Z1o\u0011!A\u0004A!A!\u0002\u0013I\u0014\u0001\u0005;bE2,7+\u001b>f\u0013:\u0014\u0015\u0010^3t!\r9#F\u000f\t\u0003OmJ!\u0001\u0010\u0015\u0003\t1{gn\u001a\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f\u0005I1m\u001c8oK\u000e$xN\u001d\t\u0003\u0001&k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b1aY9m\u0015\tqDI\u0003\u0002\b\u000b*\u0011aiR\u0001\tI\u0006$\u0018m\u001d;bq*\t\u0001*A\u0002d_6L!AS!\u0003%\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$xN\u001d\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\u0006A!/Z1e\u0007>tg\r\u0005\u0002O#6\tqJ\u0003\u0002Q\u0007\u0006\u0019!\u000f\u001a3\n\u0005I{%\u0001\u0003*fC\u0012\u001cuN\u001c4\t\u0011Q\u0003!\u0011!Q\u0001\nU\u000b\u0011b\u001e:ji\u0016\u001cuN\u001c4\u0011\u0005YKV\"A,\u000b\u0005a\u001b\u0015AB<sSR,'/\u0003\u0002[/\nIqK]5uK\u000e{gN\u001a\u0005\t9\u0002\u0011)\u0019!C!;\u0006Q1/\u001d7D_:$X\r\u001f;\u0016\u0003y\u0003\"a\u00181\u000e\u0003\u0011I!!\u0019\u0003\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003_\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\t\u000b\u0015\u0004A\u0011\u00014\u0002\rqJg.\u001b;?)%9\u0007.\u001b6lY6tw\u000e\u0005\u0002\"\u0001!)a\u0004\u001aa\u0001A!)Q\u0005\u001aa\u0001M!)1\u0007\u001aa\u0001i!)\u0001\b\u001aa\u0001s!)a\b\u001aa\u0001\u007f!)A\n\u001aa\u0001\u001b\")A\u000b\u001aa\u0001+\")A\f\u001aa\u0001=\"1\u0011\u000f\u0001Q\u0001\nI\f\u0001\u0002^1cY\u0016$UM\u001a\t\u0003\u0001NL!\u0001^!\u0003\u0011Q\u000b'\r\\3EK\u001aDQA\u001e\u0001\u0005B]\faa]2iK6\fW#\u0001\u0017\t\u000be\u0004A\u0011\t>\u0002\r%t7/\u001a:u)\u0011Yh0a\u0002\u0011\u0005\u001db\u0018BA?)\u0005\u0011)f.\u001b;\t\r}D\b\u0019AA\u0001\u0003\u0011!\u0017\r^1\u0011\u0007}\u000b\u0019!C\u0002\u0002\u0006\u0011\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\r\u0005%\u0001\u00101\u00015\u0003%yg/\u001a:xe&$X\rC\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u0017ML'0Z%o\u0005f$Xm]\u000b\u0002u!I\u00111\u0003\u0001C\u0002\u0013\r\u0011QC\u0001\u0013G\u0006\u001c8/\u00198ee\u0006\u001cuN\u001c8fGR|'/F\u0001@\u0011\u001d\tI\u0002\u0001Q\u0001\n}\n1cY1tg\u0006tGM]1D_:tWm\u0019;pe\u0002B\u0011\"!\b\u0001\u0005\u0004%\u0019!a\b\u0002\u0011I,\u0017\rZ2p]\u001a,\u0012!\u0014\u0005\b\u0003G\u0001\u0001\u0015!\u0003N\u0003%\u0011X-\u00193d_:4\u0007\u0005\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0015\u0003\u001d\u0011\u0017m]3SI\u0012\u0004RATA\u0016\u0003_I1!!\fP\u0005U\u0019\u0015m]:b]\u0012\u0014\u0018\rV1cY\u0016\u001c6-\u00198S\t\u0012\u00032!IA\u0019\u0013\r\t\u0019D\u0001\u0002\u0010\u0007\u0006\u001c8/\u00198ee\u0006\u001c\u0016\u000b\u0014*po\"9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012!\u00032vS2$7kY1o)\t\tY\u0004\u0005\u0004\u0002>\u0005\u0005\u0013QI\u0007\u0003\u0003\u007fQ!\u0001\u0015\u0004\n\t\u0005\r\u0013q\b\u0002\u0004%\u0012#\u0005cA0\u0002H%\u0019\u0011\u0011\n\u0003\u0003\u0007I{w\u000fC\u0004\u0002N\u0001!\t%a\u0014\u0002!Ut\u0007.\u00198eY\u0016$g)\u001b7uKJ\u001cH\u0003BA)\u0003;\u0002RaJA*\u0003/J1!!\u0016)\u0005\u0015\t%O]1z!\rq\u0011\u0011L\u0005\u0004\u00037z!A\u0002$jYR,'\u000f\u0003\u0005\u0002`\u0005-\u0003\u0019AA)\u0003\u001d1\u0017\u000e\u001c;feND!\"a\u0019\u0001\u0011\u000b\u0007I\u0011AA3\u0003=\tG\rZ5uS>t\u0017\r\u001c*vY\u0016\u001cXCAA4!\u0019\tI'!\u001f\u0002\u00009!\u00111NA;\u001d\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9?\u00051AH]8pizJ\u0011!K\u0005\u0004\u0003oB\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003w\niHA\u0002TKFT1!a\u001e)!\r\t\u0013\u0011Q\u0005\u0004\u0003\u0007\u0013!aF\"bgN\fg\u000e\u001a:b!J,G-[2bi\u0016\u0014V\u000f\\3t\u0011)\t9\t\u0001E\u0001B\u0003&\u0011qM\u0001\u0011C\u0012$\u0017\u000e^5p]\u0006d'+\u001e7fg\u0002Bq!a#\u0001\t\u0013\ti)A\tqe\u0016$\u0017nY1uKB+8\u000f\u001b#po:$B!a$\u0002\u0016B\u0019\u0011%!%\n\u0007\u0005M%A\u0001\nB]\u0006d\u0017P_3e!J,G-[2bi\u0016\u001c\b\u0002CA0\u0003\u0013\u0003\r!!\u0015\t\u000f\u0005]\u0002\u0001\"\u0011\u0002\u001aR1\u00111HAN\u0003_C\u0001\"!(\u0002\u0018\u0002\u0007\u0011qT\u0001\u0010e\u0016\fX/\u001b:fI\u000e{G.^7ogB)q%a\u0015\u0002\"B!\u00111UAU\u001d\r9\u0013QU\u0005\u0004\u0003OC\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00065&AB*ue&twMC\u0002\u0002(\"B\u0001\"a\u0018\u0002\u0018\u0002\u0007\u0011\u0011K\u0003\u0007\u0003g\u0003A!!.\u0003\u000fI#E\tV=qKB)a*a.\u00020%\u0019\u0011\u0011X(\u0003\u0019\r\u000b7o]1oIJ\f'\u000b\u0012#\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\u0006YQ.Y=cKN+G.Z2u)\u0019\t\t-!2\u0002HB!\u00111YAY\u001b\u0005\u0001\u0001b\u0002)\u0002<\u0002\u0007\u0011\u0011\u0019\u0005\t\u0003;\u000bY\f1\u0001\u0002 \"9\u00111\u001a\u0001\u0005\n\u00055\u0017\u0001F7bs\n,\u0007+^:iI><hNR5mi\u0016\u00148\u000f\u0006\u0004\u0002B\u0006=\u0017\u0011\u001b\u0005\b!\u0006%\u0007\u0019AAa\u0011!\ty&!3A\u0002\u0005M\u0007CBA5\u0003s\n9\u0006C\u0004\u0002X\u0002!I!!7\u0002'\u0019LG\u000e^3s)>\u001c\u0015\u000f\\!oIZ\u000bG.^3\u0015\t\u0005m\u0017\u0011\u001e\t\bO\u0005u\u0017\u0011UAq\u0013\r\ty\u000e\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0005%\u0014\u0011PAr!\r9\u0013Q]\u0005\u0004\u0003OD#aA!os\"A\u00111^Ak\u0001\u0004\t\u0019/\u0001\u0004gS2$XM\u001d\u0005\b\u0003_\u0004A\u0011BAy\u0003-!xnQ9m-\u0006dW/Z:\u0015\r\u0005\u0005\u00181_A|\u0011!\t)0!<A\u0002\u0005\u0005\u0016AC2pYVlgNT1nK\"A\u0011\u0011`Aw\u0001\u0004\tY0\u0001\u0004wC2,Xm\u001d\t\u0006O\u0005M\u00131\u001d\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0003)!xnQ9m-\u0006dW/\u001a\u000b\u0007\u0003G\u0014\u0019A!\u0002\t\u0011\u0005U\u0018Q a\u0001\u0003CC\u0001Ba\u0002\u0002~\u0002\u0007\u00111]\u0001\u0006m\u0006dW/\u001a\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0003-9\b.\u001a:f\u00072\fWo]3\u0015\t\u0005m'q\u0002\u0005\t\u0005#\u0011I\u00011\u0001\u0002b\u0006y\u0001/^:iI><hNR5mi\u0016\u00148oB\u0004\u0003\u0016\tA\tAa\u0006\u0002/\r\u000b7o]1oIJ\f7k\\;sG\u0016\u0014V\r\\1uS>t\u0007cA\u0011\u0003\u001a\u00191\u0011A\u0001E\u0001\u00057\u0019BA!\u0007\u0003\u001eA\u0019qEa\b\n\u0007\t\u0005\u0002F\u0001\u0004B]f\u0014VM\u001a\u0005\bK\neA\u0011\u0001B\u0013)\t\u00119\u0002\u0003\u0006\u0003*\te!\u0019!C\u0001\u0005W\t\u0001CU3gKJ,gnY3TK\u000e$\u0018n\u001c8\u0016\u0005\t5\u0002\u0003\u0002B\u0018\u0005si!A!\r\u000b\t\tM\"QG\u0001\u0005Y\u0006twM\u0003\u0002\u00038\u0005!!.\u0019<b\u0013\u0011\tYK!\r\t\u0013\tu\"\u0011\u0004Q\u0001\n\t5\u0012!\u0005*fM\u0016\u0014XM\\2f'\u0016\u001cG/[8oA!Q!\u0011\tB\r\u0005\u0004%\tAa\u0011\u0002+Q\u000b'\r\\3TSj,\u0017J\u001c\"zi\u0016\u001c\b+\u0019:b[V\u0011!Q\t\t\u0006\u0005\u000f\u0012i%O\u0007\u0003\u0005\u0013R1Aa\u0013D\u0003\u0011)H/\u001b7\n\t\t=#\u0011\n\u0002\u0010\u0007>tg-[4QCJ\fW.\u001a;fe\"I!1\u000bB\rA\u0003%!QI\u0001\u0017)\u0006\u0014G.Z*ju\u0016LeNQ=uKN\u0004\u0016M]1nA!Q!q\u000bB\r\u0005\u0004%\tA!\u0017\u0002K\u0005#G-\u001b;j_:\fGnQ1tg\u0006tGM]1QkNDGi\\<o%VdWm\u001d)be\u0006lWC\u0001B.!\u0019\u00119E!\u0014\u0003^A1\u0011\u0011\u000eB0\u0003\u007fJAA!\u0019\u0002~\t!A*[:u\u0011%\u0011)G!\u0007!\u0002\u0013\u0011Y&\u0001\u0014BI\u0012LG/[8oC2\u001c\u0015m]:b]\u0012\u0014\u0018\rU;tQ\u0012{wO\u001c*vY\u0016\u001c\b+\u0019:b[\u0002B!B!\u001b\u0003\u001a\t\u0007I\u0011\u0001B6\u0003)\u0001&o\u001c9feRLWm]\u000b\u0003\u0005[\u0002bAa\u001c\u0003v\t]TB\u0001B9\u0015\r\u0011\u0019\bK\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA>\u0005c\u0002DA!\u001f\u0003\u0000A1!q\tB'\u0005w\u0002BA! \u0003\u00001\u0001Aa\u0003BA\u0001\u0005\u0005\t\u0011!B\u0001\u0005\u0007\u0013AaX\u001a8kE!!Q\u0011BK%\u0015\u00119)\u000fBF\r\u0019\u0011I\t\u0001\u0001\u0003\u0006\naAH]3gS:,W.\u001a8u}A1!Q\u0012BJ\u0003\u007fj!Aa$\u000b\t\tE%\u0011O\u0001\nS6lW\u000f^1cY\u0016LAA!\u0019\u0003\u0010J1!q\u0013BM\u0005?3aA!#\u0001\u0001\tU\u0005cA\u0014\u0003\u001c&\u0019!Q\u0014\u0015\u0003\u000fA\u0013x\u000eZ;diB!!q\u0006BQ\u0013\u0011\u0011\u0019K!\r\u0003\r=\u0013'.Z2u\u0011%\u00119K!\u0007!\u0002\u0013\u0011i'A\u0006Qe>\u0004XM\u001d;jKN\u0004\u0003B\u0003BV\u00053\u0011\r\u0011\"\u0001\u0003,\u0005\u0011B-\u001a4bk2$8\t\\;ti\u0016\u0014h*Y7f\u0011%\u0011yK!\u0007!\u0002\u0013\u0011i#A\neK\u001a\fW\u000f\u001c;DYV\u001cH/\u001a:OC6,\u0007\u0005\u0003\u0005\u00034\neA\u0011\u0001B[\u0003\u0015\t\u0007\u000f\u001d7z)%9'q\u0017B]\u0005w\u0013)\r\u0003\u0004\u001f\u0005c\u0003\r\u0001\t\u0005\u00079\nE\u0006\u0019\u00010\t\u0015\tu&\u0011\u0017I\u0001\u0002\u0004\u0011y,A\u0004paRLwN\\:\u0011\u0007\u0005\u0012\t-C\u0002\u0003D\n\u0011acQ1tg\u0006tGM]1T_V\u00148-Z(qi&|gn\u001d\u0005\tm\nE\u0006\u0013!a\u0001M!A!\u0011\u001aB\r\t\u0003\u0011Y-\u0001\td_:\u001cx\u000e\\5eCR,7i\u001c8ggRQ!Q\u001aBj\u0005/\u0014\tOa9\u0011\u0007i\u0011y-C\u0002\u0003R\u001a\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\tU'q\u0019a\u0001\u0005\u001b\f\u0011b\u001d9be.\u001cuN\u001c4\t\u0011\te'q\u0019a\u0001\u00057\fqa]9m\u0007>tg\r\u0005\u0005\u0002$\nu\u0017\u0011UAQ\u0013\u0011\u0011y.!,\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u001f\u0005\u000f\u0004\r\u0001\t\u0005\t\u0005K\u00149\r1\u0001\u0003\\\u0006IA/\u00192mK\u000e{gN\u001a\u0005\u000b\u0005S\u0014I\"%A\u0005\u0002\t-\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t5(\u0006\u0002B`\u0005_\\#A!=\u0011\t\tM(Q`\u0007\u0003\u0005kTAAa>\u0003z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005wD\u0013AC1o]>$\u0018\r^5p]&!!q B{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0007\u0007\u0011I\"%A\u0005\u0002\r\u0015\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u001d!f\u0001\u0014\u0003p\u0002")
public class CassandraSourceRelation
extends BaseRelation
implements InsertableRelation,
PrunedFilteredScan,
Logging {
    private final TableRef tableRef;
    private final Option<StructType> userSpecifiedSchema;
    private final boolean filterPushdown;
    private final Option<Object> tableSizeInBytes;
    private final CassandraConnector connector;
    private final WriteConf writeConf;
    private final SQLContext sqlContext;
    public final TableDef org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef;
    private final CassandraConnector cassandraConnector;
    private final ReadConf readconf;
    private final CassandraTableScanRDD<CassandraSQLRow> baseRdd;
    private Seq<CassandraPredicateRules> additionalRules;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Option<StructType> apply$default$4() {
        return CassandraSourceRelation$.MODULE$.apply$default$4();
    }

    public static CassandraSourceOptions apply$default$3() {
        return CassandraSourceRelation$.MODULE$.apply$default$3();
    }

    public static SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> map, TableRef tableRef, Map<String, String> map2) {
        return CassandraSourceRelation$.MODULE$.consolidateConfs(sparkConf, map, tableRef, map2);
    }

    public static CassandraSourceRelation apply(TableRef tableRef, SQLContext sQLContext, CassandraSourceOptions cassandraSourceOptions, Option<StructType> option) {
        return CassandraSourceRelation$.MODULE$.apply(tableRef, sQLContext, cassandraSourceOptions, option);
    }

    public static String defaultClusterName() {
        return CassandraSourceRelation$.MODULE$.defaultClusterName();
    }

    public static Seq<ConfigParameter<? extends Product>> Properties() {
        return CassandraSourceRelation$.MODULE$.Properties();
    }

    public static ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam() {
        return CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam();
    }

    public static ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return CassandraSourceRelation$.MODULE$.TableSizeInBytesParam();
    }

    public static String ReferenceSection() {
        return CassandraSourceRelation$.MODULE$.ReferenceSection();
    }

    private Seq additionalRules$lzycompute() {
        CassandraSourceRelation cassandraSourceRelation = this;
        synchronized (cassandraSourceRelation) {
            Option option;
            block7: {
                if (!this.bitmap$0) {
                    Seq seq;
                    SparkContext sc = this.sqlContext().sparkContext();
                    Option userClasses = sc.getConf().getOption(CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().name()).orElse((Function0)new scala.Serializable(this, sc){
                        public static final long serialVersionUID = 0L;
                        private final SparkContext sc$1;

                        public final Option<String> apply() {
                            return Option$.MODULE$.apply((Object)this.sc$1.getLocalProperty(CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().name()));
                        }
                        {
                            this.sc$1 = sc$1;
                        }
                    });
                    option = userClasses;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String classes = (String)some.x();
                        seq = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])classes.trim().split("\\s*,\\s*")).map((Function1)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final CassandraPredicateRules apply(String objectName) {
                                JavaUniverse $u = package$.MODULE$.universe();
                                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CassandraSourceRelation.class.getClassLoader());
                                return (CassandraPredicateRules)ReflectionUtil$.MODULE$.findGlobalObject(objectName, ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                        Universe $u = $m$untyped.universe();
                                        Mirror<U> $m = $m$untyped;
                                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.sql.cassandra.CassandraPredicateRules")).asType()).toTypeConstructor();
                                    }
                                }));
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CassandraPredicateRules.class)))).reverse());
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                        seq = (Seq)CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().default();
                    }
                    this.additionalRules = seq;
                    this.bitmap$0 = true;
                }
                return this.additionalRules;
            }
            throw new MatchError((Object)option);
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        return (StructType)this.userSpecifiedSchema.getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final StructType apply() {
                return StructType$.MODULE$.apply((Seq)this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columns().map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(ColumnDef column) {
                        return DataTypeConverter$.MODULE$.toStructField(column);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void insert(DataFrame data, boolean overwrite) {
        Object object;
        if (overwrite) {
            String keyspace = Quote$.MODULE$.quote(this.tableRef.keyspace());
            String table = Quote$.MODULE$.quote(this.tableRef.table());
            object = this.connector.withSessionDo(new scala.Serializable(this, keyspace, table){
                public static final long serialVersionUID = 0L;
                private final String keyspace$1;
                private final String table$1;

                public final ResultSet apply(Session session) {
                    return session.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyspace$1, this.table$1})));
                }
                {
                    this.keyspace$1 = keyspace$1;
                    this.table$1 = table$1;
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        SqlRowWriter$Factory$ rwf = SqlRowWriter$Factory$.MODULE$;
        SomeColumns columns = new SomeColumns((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])data.columns()).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnRef apply(String x) {
                return com.datastax.spark.connector.package$.MODULE$.toNamedColumnRef(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class)))));
        com.datastax.spark.connector.package$.MODULE$.toRDDFunctions(data.rdd()).saveToCassandra(this.tableRef.keyspace(), this.tableRef.table(), columns, this.writeConf, this.cassandraConnector(), rwf);
    }

    public long sizeInBytes() {
        return BoxesRunTime.unboxToLong((Object)this.tableSizeInBytes.getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.sqlContext().conf().defaultSizeInBytes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public CassandraConnector cassandraConnector() {
        return this.cassandraConnector;
    }

    public ReadConf readconf() {
        return this.readconf;
    }

    public RDD<Row> buildScan() {
        return this.baseRdd;
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        boolean bl;
        block4: {
            Filter[] filterArray;
            block3: {
                block2: {
                    bl = this.filterPushdown;
                    if (!bl) break block2;
                    filterArray = (Filter[])this.predicatePushDown(filters).handledBySpark().toArray(ClassTag$.MODULE$.apply(Filter.class));
                    break block3;
                }
                if (bl) break block4;
                filterArray = filters;
            }
            return filterArray;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public Seq<CassandraPredicateRules> additionalRules() {
        return this.bitmap$0 ? this.additionalRules : this.additionalRules$lzycompute();
    }

    private AnalyzedPredicates predicatePushDown(Filter[] filters) {
        this.logInfo((Function0<String>)new scala.Serializable(this, filters){
            public static final long serialVersionUID = 0L;
            private final Filter[] filters$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input Predicates: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.filters$1).mkString(", ")}));
            }
            {
                this.filters$1 = filters$1;
            }
        });
        BasicCassandraPredicatePushDown<Filter> bcpp = new BasicCassandraPredicatePushDown<Filter>(Predef$.MODULE$.refArrayOps((Object[])filters).toSet(), this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef, PredicateOps$FilterOps$.MODULE$);
        AnalyzedPredicates basicPushdown = new AnalyzedPredicates(bcpp.predicatesToPushDown(), bcpp.predicatesToPreserve());
        this.logDebug((Function0<String>)new scala.Serializable(this, basicPushdown){
            public static final long serialVersionUID = 0L;
            private final AnalyzedPredicates basicPushdown$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Basic Rules Applied:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.basicPushdown$1}));
            }
            {
                this.basicPushdown$1 = basicPushdown$1;
            }
        });
        AnalyzedPredicates finalPushdown = (AnalyzedPredicates)this.additionalRules().foldRight((Object)basicPushdown, (Function2)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            /*
             * WARNING - void declaration
             */
            public final AnalyzedPredicates apply(CassandraPredicateRules rules, AnalyzedPredicates pushdowns) {
                void var3_3;
                AnalyzedPredicates pd = rules.apply(pushdowns, this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef);
                this.$outer.logDebug((Function0<String>)new scala.Serializable(this, rules, pd){
                    public static final long serialVersionUID = 0L;
                    private final CassandraPredicateRules rules$1;
                    private final AnalyzedPredicates pd$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Applied ", " Pushdown Filters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rules$1.getClass().getSimpleName(), this.pd$1}));
                    }
                    {
                        this.rules$1 = rules$1;
                        this.pd$1 = pd$1;
                    }
                });
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new scala.Serializable(this, finalPushdown){
            public static final long serialVersionUID = 0L;
            private final AnalyzedPredicates finalPushdown$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final Pushdown filters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.finalPushdown$1}));
            }
            {
                this.finalPushdown$1 = finalPushdown$1;
            }
        });
        return finalPushdown;
    }

    public RDD<Row> buildScan(String[] requiredColumns2, Filter[] filters) {
        CassandraRDD<Row> cassandraRDD;
        CassandraRDD<Row> prunedRdd = this.maybeSelect(this.baseRdd, requiredColumns2);
        if (this.filterPushdown) {
            Filter[] pushdownFilters = (Filter[])this.predicatePushDown(filters).handledByCassandra().toArray(ClassTag$.MODULE$.apply(Filter.class));
            CassandraRDD<CassandraSQLRow> filteredRdd = this.maybePushdownFilters(prunedRdd, (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])pushdownFilters));
            cassandraRDD = filteredRdd;
        } else {
            cassandraRDD = prunedRdd;
        }
        CassandraRDD<Row> prunedFilteredRdd = cassandraRDD;
        return prunedFilteredRdd;
    }

    private CassandraRDD<CassandraSQLRow> maybeSelect(CassandraRDD<CassandraSQLRow> rdd, String[] requiredColumns2) {
        return Predef$.MODULE$.refArrayOps((Object[])requiredColumns2).nonEmpty() ? rdd.select((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns2).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnRef apply(String column) {
                return com.datastax.spark.connector.package$.MODULE$.toNamedColumnRef(column);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class))))) : rdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CassandraRDD<CassandraSQLRow> maybePushdownFilters(CassandraRDD<CassandraSQLRow> rdd, Seq<Filter> filters) {
        Tuple2<String, Seq<Object>> tuple2 = this.whereClause(filters);
        if (tuple2 == null) return rdd;
        String cql2 = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        if (!values.nonEmpty()) return rdd;
        return rdd.where(cql2, (Seq<Object>)values);
    }

    public Tuple2<String, Seq<Object>> org$apache$spark$sql$cassandra$CassandraSourceRelation$$filterToCqlAndValue(Object filter) {
        block8: {
            Tuple2 tuple2;
            block3: {
                Object object;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    object = filter;
                                    if (!(object instanceof EqualTo)) break block2;
                                    EqualTo equalTo = (EqualTo)object;
                                    String attribute = equalTo.attribute();
                                    Object value2 = equalTo.value();
                                    tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value2)})));
                                    break block3;
                                }
                                if (!(object instanceof LessThan)) break block4;
                                LessThan lessThan = (LessThan)object;
                                String attribute = lessThan.attribute();
                                Object value3 = lessThan.value();
                                tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value3)})));
                                break block3;
                            }
                            if (!(object instanceof LessThanOrEqual)) break block5;
                            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)object;
                            String attribute = lessThanOrEqual.attribute();
                            Object value4 = lessThanOrEqual.value();
                            tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <= ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value4)})));
                            break block3;
                        }
                        if (!(object instanceof GreaterThan)) break block6;
                        GreaterThan greaterThan = (GreaterThan)object;
                        String attribute = greaterThan.attribute();
                        Object value5 = greaterThan.value();
                        tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value5)})));
                        break block3;
                    }
                    if (!(object instanceof GreaterThanOrEqual)) break block7;
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)object;
                    String attribute = greaterThanOrEqual.attribute();
                    Object value6 = greaterThanOrEqual.value();
                    tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value6)})));
                    break block3;
                }
                if (!(object instanceof In)) break block8;
                In in = (In)object;
                String attribute = in.attribute();
                Object[] values = in.values();
                tuple2 = new Tuple2((Object)new StringBuilder().append((Object)Quote$.MODULE$.quote(attribute)).append((Object)" IN ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$2) {
                        return "?";
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("(", ", ", ")")).toString(), this.toCqlValues(attribute, values));
            }
            return tuple2;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It's not a valid filter ", " to be pushed down, only >, <, >=, <= and In are allowed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter})));
    }

    private Seq<Object> toCqlValues(String columnName2, Object[] values) {
        return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new scala.Serializable(this, columnName2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;
            private final String columnName$1;

            public final Object apply(Object x$3) {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(this.columnName$1, x$3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnName$1 = columnName$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
    }

    public Object org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(String columnName2, Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof Decimal) {
            Decimal decimal = (Decimal)object2;
            ColumnType<?> columnType = ((ColumnDef)this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columnByName().apply((Object)columnName2)).columnType();
            VarIntType$ varIntType$ = VarIntType$.MODULE$;
            boolean isVarIntColumn = !(columnType != null ? !columnType.equals(varIntType$) : varIntType$ != null);
            object = isVarIntColumn ? decimal.toJavaBigDecimal().toBigInteger() : decimal;
        } else if (object2 instanceof UTF8String) {
            Serializable serializable;
            ColumnType<?> columnType;
            UTF8String uTF8String = (UTF8String)object2;
            ColumnType<?> columnType2 = columnType = ((ColumnDef)this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columnByName().apply((Object)columnName2)).columnType();
            InetType$ inetType$ = InetType$.MODULE$;
            if (!(columnType2 != null ? !columnType2.equals(inetType$) : inetType$ != null)) {
                serializable = InetAddress.getByName(uTF8String.toString());
            } else {
                ColumnType<?> columnType3 = columnType;
                UUIDType$ uUIDType$ = UUIDType$.MODULE$;
                serializable = !(columnType3 != null ? !columnType3.equals(uUIDType$) : uUIDType$ != null) ? UUID.fromString(uTF8String.toString()) : uTF8String;
            }
            object = serializable;
        } else {
            object = object2;
        }
        return object;
    }

    private Tuple2<String, Seq<Object>> whereClause(Seq<Object> pushdownFilters) {
        Seq cqlValue = (Seq)pushdownFilters.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final Tuple2<String, Seq<Object>> apply(Object filter) {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$filterToCqlAndValue(filter);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String cql2 = ((TraversableOnce)cqlValue.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Seq<Object>> x$4) {
                return (String)x$4._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        Seq args = (Seq)cqlValue.flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<String, Seq<Object>> x$5) {
                return (Seq)x$5._2();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)cql2, (Object)args);
    }

    /*
     * WARNING - void declaration
     */
    public CassandraSourceRelation(TableRef tableRef, Option<StructType> userSpecifiedSchema, boolean filterPushdown, Option<Object> tableSizeInBytes, CassandraConnector connector, ReadConf readConf, WriteConf writeConf, SQLContext sqlContext) {
        this.tableRef = tableRef;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.filterPushdown = filterPushdown;
        this.tableSizeInBytes = tableSizeInBytes;
        this.connector = connector;
        this.writeConf = writeConf;
        this.sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
        String tableName = tableRef.table();
        String keyspaceName = tableRef.keyspace();
        Option option = Schema$.MODULE$.fromCassandra(connector, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (option instanceof Some) {
            TableDef t;
            TableDef tableDef;
            Some some = (Some)option;
            this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef = tableDef = (t = (TableDef)some.x());
            this.cassandraConnector = connector;
            this.readconf = readConf;
            this.baseRdd = com.datastax.spark.connector.package$.MODULE$.toSparkContextFunctions(sqlContext.sparkContext()).cassandraTable(tableRef.keyspace(), tableRef.table(), this.cassandraConnector(), this.readconf(), ClassTag$.MODULE$.apply(CassandraSQLRow.class), CassandraSQLRow$CassandraSQLRowReader$.MODULE$, ValidRDDType$.MODULE$.javaSerializableAsValidRDDType());
            return;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            void var9_9;
            void var10_10;
            Metadata metadata = (Metadata)connector.withClusterDo(new $anonfun$1(this));
            Option<NameTools.Suggestions> suggestions = NameTools$.MODULE$.getSuggestions(metadata, (String)var10_10, (String)var9_9);
            String errorMessage = NameTools$.MODULE$.getErrorString((String)var10_10, (String)var9_9, suggestions);
            throw new IOException(errorMessage);
        }
        throw new MatchError((Object)option);
    }
}

