/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jpa2ddl;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class FileResolver {
    private static final Pattern FILENAME_PATTERN = Pattern.compile("v([0-9]+)__.+\\.sql", 2);
    private static final Pattern SCHEMA_FILENAME_PATTERN = Pattern.compile("v([0-9]+)__jpa2ddl.*\\.sql", 2);

    FileResolver() {
    }

    static File resolveNextMigrationFile(File migrationDir) {
        Optional lastFile = FileResolver.resolveExistingMigrations(migrationDir, true, false).stream().findFirst();
        Long fileIndex = lastFile.map(input -> FILENAME_PATTERN.matcher(input.getFileName().toString())).map(matcher -> {
            if (matcher.find()) {
                return Long.valueOf(matcher.group(1));
            }
            return 0L;
        }).orElse(0L);
        fileIndex = fileIndex + 1L;
        return migrationDir.toPath().resolve("v" + fileIndex + "__jpa2ddl.sql").toFile();
    }

    static List<Path> resolveExistingMigrations(File migrationsDir, boolean reversed, boolean onlySchemaMigrations) {
        File[] files;
        if (!migrationsDir.exists()) {
            migrationsDir.mkdirs();
        }
        if ((files = migrationsDir.listFiles()) == null) {
            return Collections.emptyList();
        }
        Comparator<Path> pathComparator = Comparator.comparingLong(FileResolver::compareVersionedMigrations);
        if (reversed) {
            pathComparator = pathComparator.reversed();
        }
        return Arrays.stream(files).map(File::toPath).filter(path -> !onlySchemaMigrations || SCHEMA_FILENAME_PATTERN.matcher(path.getFileName().toString()).matches()).sorted(pathComparator).collect(Collectors.toList());
    }

    static Set<String> listClassNamesInPackage(final String packageName) throws Exception {
        final HashSet<String> classes = new HashSet<String>();
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(packageName.replace('.', File.separatorChar));
        if (!resources.hasMoreElements()) {
            throw new IllegalStateException("No package found: " + packageName);
        }
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:*.class");
        while (resources.hasMoreElements()) {
            final URL resource = resources.nextElement();
            Files.walkFileTree(Paths.get(resource.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    if (pathMatcher.matches(path.getFileName())) {
                        try {
                            String className = Paths.get(resource.toURI()).relativize(path).toString().replace(File.separatorChar, '.');
                            classes.add(packageName + '.' + className.substring(0, className.length() - 6));
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return classes;
    }

    private static Long compareVersionedMigrations(Path path) {
        Matcher filenameMatcher = FILENAME_PATTERN.matcher(path.getFileName().toString());
        if (filenameMatcher.find()) {
            return Long.valueOf(filenameMatcher.group(1));
        }
        return Long.MIN_VALUE;
    }
}

