/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import java.lang.reflect.Method;
import java.util.Properties;

public final class EclipseJdtFormatterStep {
    private static final String NAME = "eclipse jdt formatter";
    private static final String FORMATTER_CLASS_OLD = "com.diffplug.gradle.spotless.java.eclipse.EclipseFormatterStepImpl";
    private static final String FORMATTER_CLASS = "com.diffplug.spotless.extra.eclipse.java.EclipseJdtFormatterStepImpl";
    private static final String MAVEN_GROUP_ARTIFACT = "com.diffplug.spotless:spotless-eclipse-jdt";
    private static final String FORMATTER_METHOD = "format";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support((String)"eclipse jdt formatter").add(8, (Object)"4.19.0").add(11, (Object)"4.21.0");

    private EclipseJdtFormatterStep() {
    }

    public static String defaultVersion() {
        return (String)JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)EclipseJdtFormatterStep::apply));
    }

    private static FormatterFunc apply(EclipseBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = EclipseJdtFormatterStep.getClass(state);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return JVM_SUPPORT.suggestLaterVersionOnError((Object)state.getSemanticVersion(), input -> (String)method.invoke(formatter, input));
    }

    private static Class<?> getClass(EclipseBasedStepBuilder.State state) {
        if (state.getMavenCoordinate(MAVEN_GROUP_ARTIFACT).isPresent()) {
            return state.loadClass(FORMATTER_CLASS);
        }
        return state.loadClass(FORMATTER_CLASS_OLD);
    }
}

