/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.glue.groovy;

import dev.equo.solstice.NestedJars;
import dev.equo.solstice.ShimIdeBootstrapServices;
import dev.equo.solstice.Solstice;
import dev.equo.solstice.p2.CacheLocations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.IGroovyLogger;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferencesOnStore;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.BundleContext;

public class GrEclipseFormatterStepImpl {
    public static final String IGNORE_FORMATTER_PROBLEMS = "ignoreFormatterProblems";
    private final FormatterPreferencesOnStore preferencesStore;
    private final boolean ignoreFormatterProblems;

    public GrEclipseFormatterStepImpl(Properties properties) throws Exception {
        PreferenceStore preferences = GrEclipseFormatterStepImpl.createPreferences(properties);
        this.preferencesStore = new FormatterPreferencesOnStore((IPreferenceStore)preferences);
        this.ignoreFormatterProblems = Boolean.parseBoolean(properties.getProperty(IGNORE_FORMATTER_PROBLEMS, "false"));
    }

    public String format(String raw) throws Exception {
        Document doc = new Document(raw);
        GroovyErrorListener errorListener = new GroovyErrorListener();
        TextSelection selectAll = new TextSelection((IDocument)doc, 0, doc.getLength());
        DefaultGroovyFormatter codeFormatter = new DefaultGroovyFormatter((ITextSelection)selectAll, (IDocument)doc, (IFormatterPreferences)this.preferencesStore, false);
        TextEdit edit = codeFormatter.format();
        if (!this.ignoreFormatterProblems && errorListener.errorsDetected()) {
            throw new IllegalArgumentException(errorListener.toString());
        }
        edit.apply((IDocument)doc);
        return doc.get();
    }

    private static PreferenceStore createPreferences(Properties properties) throws IOException {
        PreferenceStore preferences = new PreferenceStore();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        properties.store(output, null);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        preferences.load((InputStream)input);
        return preferences;
    }

    static {
        NestedJars.setToWarnOnly();
        NestedJars.onClassPath().confirmAllNestedJarsArePresentOnClasspath(CacheLocations.p2nestedJars());
        try {
            Solstice solstice = Solstice.findBundlesOnClasspath();
            solstice.warnAndModifyManifestsToFix();
            Map<String, String> props = Map.of("osgi.nl", "en_US", "org.osgi.framework.storage.clean", "onFirstInit", "osgi.instance.area", Files.createTempDirectory("spotless-groovy", new FileAttribute[0]).toAbsolutePath().toString());
            solstice.openShim(props);
            ShimIdeBootstrapServices.apply(props, (BundleContext)solstice.getContext());
            solstice.start("org.apache.felix.scr");
            solstice.startAllWithLazy(false);
            solstice.start("org.codehaus.groovy.eclipse.core");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class GroovyErrorListener
    implements ILogListener,
    IGroovyLogger {
        private final List<Throwable> errors = Collections.synchronizedList(new ArrayList());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GroovyErrorListener() {
            ILog groovyLogger = GroovyCoreActivator.getDefault().getLog();
            groovyLogger.addLogListener((ILogListener)this);
            GroovyLogManager groovyLogManager = GroovyLogManager.manager;
            synchronized (groovyLogManager) {
                GroovyLogManager.manager.addLogger((IGroovyLogger)this);
            }
        }

        public void logging(IStatus status, String plugin) {
            this.errors.add(status.getException());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean errorsDetected() {
            ILog groovyLogger = GroovyCoreActivator.getDefault().getLog();
            groovyLogger.removeLogListener((ILogListener)this);
            GroovyLogManager groovyLogManager = GroovyLogManager.manager;
            synchronized (groovyLogManager) {
                GroovyLogManager.manager.removeLogger((IGroovyLogger)this);
            }
            return 0 != this.errors.size();
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            if (1 < this.errors.size()) {
                string.append("Multiple problems detected during step execution:");
            } else if (0 == this.errors.size()) {
                string.append("Step sucesfully executed.");
            }
            for (Throwable error : this.errors) {
                error.printStackTrace();
                string.append(System.lineSeparator());
                string.append(error.getMessage());
            }
            return string.toString();
        }

        public boolean isCategoryEnabled(TraceCategory cat) {
            return TraceCategory.COMPILER.equals((Object)cat);
        }

        public void log(TraceCategory arg0, String arg1) {
            try {
                throw new RuntimeException(arg1);
            }
            catch (RuntimeException e) {
                this.errors.add(e);
                return;
            }
        }
    }
}

