/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.glue.jdt;

import com.diffplug.spotless.extra.glue.jdt.EclipseJdtSortMembers;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EclipseJdtFormatterStepImpl {
    public static final String LINE_DELIMITER = "\n";
    private final CodeFormatter codeFormatter;
    private final EclipseJdtSortMembers.SortProperties sortProperties;

    public EclipseJdtFormatterStepImpl(Properties formatterSettings, Map<String, String> sortProperties) {
        Map options = formatterSettings.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
        this.codeFormatter = new DefaultCodeFormatter(options);
        this.sortProperties = EclipseJdtSortMembers.SortProperties.from(sortProperties);
    }

    public String format(String raw, File file) throws Exception {
        raw = this.sort(raw);
        int kind = (file.getName().equals("module-info.java") ? 128 : 8) | 0x1000;
        TextEdit edit = this.codeFormatter.format(kind, raw, 0, raw.length(), 0, LINE_DELIMITER);
        if (edit == null) {
            throw new IllegalArgumentException("Invalid java syntax for formatting.");
        }
        Document doc = new Document(raw);
        edit.apply((IDocument)doc);
        return doc.get();
    }

    public String sort(String raw) {
        return EclipseJdtSortMembers.sortMember(raw, this.sortProperties);
    }
}

