/*
 * Copyright 2016 DiffPlug
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.diffplug.spotless.sql.dbeaver;

/**
 * Forked from
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2017 Serge Rider (serge@jkiss.org)
 *
 * Based on SQLConstants from https://github.com/serge-rider/dbeaver,
 * which itself is licensed under the Apache 2.0 license.
 */
class SQLConstants {

	static final String ML_COMMENT_START = "/*";
	static final String ML_COMMENT_END = "*/";
	static final String SL_COMMENT = "--";

	private static final String KEYWORD_SELECT = "SELECT";
	private static final String KEYWORD_ON = "ON";

	static final String[] SQL2003_RESERVED_KEYWORDS = {
			"ALL",
			"ALLOCATE",
			"ALTER",
			"AND",
			"ANY",
			"ARE",
			"ARRAY",
			"AS",
			"ASENSITIVE",
			"ASYMMETRIC",
			"AT",
			"ATOMIC",
			"AUTHORIZATION",
			"BEGIN",
			"BETWEEN",
			//"BIGINT",
			"BINARY",
			"BOTH",
			"BY",
			"CALL",
			"CALLED",
			"CARDINALITY",
			"CASCADE",
			"CASCADED",
			"CASE",
			"CAST",
			"CEIL",
			"CEILING",
			"CHARACTER",
			"CHECK",
			"CLOSE",
			"COALESCE",
			"COLLATE",
			"COLLECT",
			"COLUMN",
			"COMMIT",
			"CONDITION",
			"CONNECT",
			"CONSTRAINT",
			"CONVERT",
			"CORR",
			"CORRESPONDING",
			"COVAR_POP",
			"COVAR_SAMP",
			"CREATE",
			"CROSS",
			"CUBE",
			"CUME_DIST",
			"CURRENT",
			"CURSOR",
			"CYCLE",
			"DAY",
			"DEALLOCATE",
			"DEC",
			"DECLARE",
			"DEFAULT",
			"DELETE",
			"DENSE_RANK",
			"DEREF",
			"DESCRIBE",
			"DETERMINISTIC",
			"DISCONNECT",
			"DISTINCT",
			"DROP",
			"DYNAMIC",
			"EACH",
			"ELEMENT",
			"ELSE",
			"END",
			"END-EXEC",
			"ESCAPE",
			"EVERY",
			"EXCEPT",
			"EXEC",
			"EXECUTE",
			"EXISTS",
			"EXP",
			"EXTERNAL",
			"EXTRACT",
			"FALSE",
			"FETCH",
			"FILTER",
			"FOR",
			"FOREIGN",
			"FREE",
			"FROM",
			"FULL",
			"FUNCTION",
			"FUSION",
			"GET",
			"GLOBAL",
			"GRANT",
			"GROUP",
			"GROUPING",
			"HAVING",
			"HOLD",
			"HOUR",
			"IDENTITY",
			"IF",
			"IN",
			"INDEX",
			"INDICATOR",
			"INNER",
			"INOUT",
			"INSENSITIVE",
			"INSERT",
			"INTERSECT",
			"INTERSECTION",
			"INTERVAL",
			"INTO",
			"IS",
			"JOIN",
			"LANGUAGE",
			"LARGE",
			"LATERAL",
			"LEFT",
			"LIKE",
			"LN",
			"LOCAL",
			"LOCALTIME",
			"LOCALTIMESTAMP",
			"MATCH",
			"MEMBER",
			"MERGE",
			"METHOD",
			"MINUTE",
			"MOD",
			"MODIFIES",
			//        "MODULE", // too common for column names
			"MONTH",
			"MULTISET",
			"NATIONAL",
			"NATURAL",
			//"NCHAR",
			//"NCLOB",
			"NEW",
			"NO",
			"NONE",
			"NORMALIZE",
			"NOT",
			"NULL",
			"NULLIF",
			"NUMERIC",
			"OF",
			"OLD",
			KEYWORD_ON,
			"ONLY",
			"OPEN",
			"OR",
			"ORDER",
			"OUT",
			"OUTER",
			"OVER",
			"OVERLAPS",
			"OVERLAY",
			"PARAMETER",
			"PARTITION",
			"POSITION",
			"PRECISION",
			"PREPARE",
			"PRIMARY",
			"PROCEDURE",
			"RANGE",
			"RANK",
			"READS",
			"REAL",
			"RECURSIVE",
			"REF",
			"REFERENCES",
			"REFERENCING",
			"RELEASE",
			"RENAME",
			"RESULT",
			"RETURN",
			"RETURNS",
			"REVOKE",
			"RIGHT",
			"ROLLBACK",
			"ROLLUP",
			"ROW",
			"ROW_NUMBER",
			"ROWS",
			"SAVEPOINT",
			"SCOPE",
			"SCROLL",
			"SEARCH",
			"SECOND",
			KEYWORD_SELECT,
			"SENSITIVE",
			"SESSION_USER",
			"SET",
			"SIMILAR",
			"SMALLINT",
			"SOME",
			"SPECIFIC",
			"SPECIFICTYPE",
			"SQL",
			"SQLEXCEPTION",
			"SQLSTATE",
			"SQLWARNING",
			"START",
			"STATIC",
			"STDDEV_POP",
			"STDDEV_SAMP",
			"SUBMULTISET",
			"SYMMETRIC",
			"SYSTEM",
			"SYSTEM_USER",
			"TABLE",
			"TABLESAMPLE",
			"THEN",
			"TIMEZONE_HOUR",
			"TIMEZONE_MINUTE",
			"TO",
			"TRAILING",
			"TRANSLATE",
			"TRANSLATION",
			"TREAT",
			"TRIGGER",
			"TRUE",
			"UNION",
			"UNIQUE",
			"UNKNOWN",
			"UNNEST",
			"UPDATE",
			"USER",
			"USING",
			//"VALUE", // too common for column names
			"VALUES",
			"VAR_POP",
			"VAR_SAMP",
			//"VARCHAR",
			"VARYING",
			"WHEN",
			"WHENEVER",
			"WHERE",
			"WIDTH_BUCKET",
			"WINDOW",
			"WITH",
			"WITHIN",
			"WITHOUT",
			"YEAR",

			"NULLS",
			"FIRST",
			"LAST",

			"FOLLOWING",
			"PRECEDING",
			"UNBOUNDED",

			"LENGTH",
			"KEY",
			"LEVEL",

			"VIEW",
			"SEQUENCE",
			"SCHEMA",
			"ROLE",
			"RESTRICT",
			"ASC",
			"DESC",

			// Not actually standard but widely used
			"LIMIT",

			// Extended keywords
			//        "A",
			"ABSOLUTE",
			"ACTION",
			//        "ADA",
			"ADD",
			//        "ADMIN",
			"AFTER",
			"ALWAYS",
			//        "ASC",
			"ASSERTION",
			"ASSIGNMENT",
			"ATTRIBUTE",
			"ATTRIBUTES",
			"BEFORE",
			//        "BERNOULLI",
			//        "BREADTH",
			//        "C",
			"CASCADE",
			"CATALOG",
			//        "CATALOG_NAME",
			"CHAIN",
			//        "CHARACTER_SET_CATALOG",
			//        "CHARACTER_SET_NAME",
			//        "CHARACTER_SET_SCHEMA",
			"CHARACTERISTICS",
			"CHARACTERS",
			//        "CLASS_ORIGIN",
			//        "COBOL",
			"COLLATION",
			//        "COLLATION_CATALOG",
			//        "COLLATION_NAME",
			//        "COLLATION_SCHEMA",
			//        "COLUMN_NAME",
			//        "COMMAND_FUNCTION",
			//        "COMMAND_FUNCTION_CODE",
			"COMMITTED",
			//        "CONDITION_NUMBER",
			"CONNECTION",
			//        "CONNECTION_NAME",
			//        "CONSTRAINT_CATALOG",
			//        "CONSTRAINT_NAME",
			//        "CONSTRAINT_SCHEMA",
			"CONSTRAINTS",
			"CONSTRUCTOR",
			"CONTAINS",
			"CONTINUE",
			"CURSOR_NAME",
			"DATA",
			//        "DATETIME_INTERVAL_CODE",
			//        "DATETIME_INTERVAL_PRECISION",
			"DEFAULTS",
			"DEFERRABLE",
			"DEFERRED",
			"DEFINED",
			"DEFINER",
			"DEGREE",
			"DEPTH",
			"DERIVED",
			//        "DESC",
			"DESCRIPTOR",
			"DIAGNOSTICS",
			"DISPATCH",
			"DOMAIN",
			//        "DYNAMIC_FUNCTION",
			//        "DYNAMIC_FUNCTION_CODE",
			"EQUALS",
			"EXCEPTION",
			"EXCLUDE",
			"EXCLUDING",
			"FINAL",
			"FIRST",
			//        "FORTRAN",
			"FOUND",
			//        "G",
			"GENERAL",
			"GENERATED",
			"GO",
			"GOTO",
			"GRANTED",
			"HIERARCHY",
			"IMMEDIATE",
			"IMPLEMENTATION",
			"INCLUDING",
			"INCREMENT",
			"INITIALLY",
			"INPUT",
			"INSTANCE",
			"INSTANTIABLE",
			"INVOKER",
			"ISOLATION",
			//        "K",
			//        "KEY_MEMBER",
			"KEY_TYPE",
			"LAST",
			"LOCATOR",
			//        "M",
			"MAP",
			"MATCHED",
			"MAXVALUE",
			//        "MESSAGE_LENGTH",
			//        "MESSAGE_OCTET_LENGTH",
			//        "MESSAGE_TEXT",
			"MINVALUE",
			"MORE",
			"MUMPS",
			//        "NAME",
			//        "NAMES",
			"NESTING",
			"NEXT",
			"NORMALIZED",
			//        "NULLABLE",
			//        "NULLS",
			//        "NUMBER",
			"OBJECT",
			"OCTETS",
			"OPTION",
			"OPTIONS",
			"ORDERING",
			"ORDINALITY",
			"OTHERS",
			"OUTPUT",
			"OVERRIDING",
			"PAD",
			//        "PARAMETER_MODE",
			//        "PARAMETER_NAME",
			//        "PARAMETER_ORDINAL_POSITION",
			//        "PARAMETER_SPECIFIC_CATALOG",
			//        "PARAMETER_SPECIFIC_NAME",
			//        "PARAMETER_SPECIFIC_SCHEMA",
			"PARTIAL",
			//        "PASCAL",
			"PATH",
			"PLACING",
			//        "PLI",
			"PRESERVE",
			"PRIOR",
			"PRIVILEGES",
			//        "PUBLIC",
			"READ",
			"RELATIVE",
			"REPEATABLE",
			"RESTART",
			//        "RETURNED_CARDINALITY",
			//        "RETURNED_LENGTH",
			//        "RETURNED_OCTET_LENGTH",
			//        "RETURNED_SQLSTATE",
			"ROUTINE",
			//        "ROUTINE_CATALOG",
			//        "ROUTINE_NAME",
			//        "ROUTINE_SCHEMA",
			//        "ROW_COUNT",
			"SCALE",
			//        "SCHEMA_NAME",
			//        "SCOPE_CATALOG",
			//        "SCOPE_NAME",
			//        "SCOPE_SCHEMA",
			"SECTION",
			"SECURITY",
			"SELF",
			"SERIALIZABLE",
			//        "SERVER_NAME",
			"SESSION",
			"SETS",
			//        "SIMPLE",
			"SIZE",
			"SOURCE",
			"SPACE",
			//        "SPECIFIC_NAME",
			//        "STATE", // too common for column names
			"STATEMENT",
			"STRUCTURE",
			"STYLE",
			//        "SUBCLASS_ORIGIN",
			//        "TABLE_NAME",
			"TEMPORARY",
			"TIES",
			//        "TOP_LEVEL_COUNT",
			"TRANSACTION",
			//        "TRANSACTION_ACTIVE",
			//        "TRANSACTIONS_COMMITTED",
			//        "TRANSACTIONS_ROLLED_BACK",
			"TRANSFORM",
			"TRANSFORMS",
			//        "TRIGGER_CATALOG",
			//        "TRIGGER_NAME",
			//        "TRIGGER_SCHEMA",
			"TYPE",
			"UNCOMMITTED",
			"UNDER",
			"UNNAMED",
			"USAGE",
			//        "USER_DEFINED_TYPE_CATALOG",
			//        "USER_DEFINED_TYPE_CODE",
			//        "USER_DEFINED_TYPE_NAME",
			//        "USER_DEFINED_TYPE_SCHEMA",
			"WORK",
			"WRITE",
			"ZONE"
	};

	static final String[] SQL2003_FUNCTIONS = {
			"ABS",
			"AVG",
			"CHAR_LENGTH",
			"CHARACTER_LENGTH",
			"COUNT",
			"CURRENT_DATE",
			"CURRENT_DEFAULT_TRANSFORM_GROUP",
			"CURRENT_PATH",
			"CURRENT_ROLE",
			"CURRENT_TIME",
			"CURRENT_TIMESTAMP",
			"CURRENT_TRANSFORM_GROUP_FOR_TYPE",
			"CURRENT_USER",
			"FLOOR",
			"LEADING",
			"LOWER",
			"MAX",
			"MIN",
			"OCTET_LENGTH",
			"PERCENT_RANK",
			"PERCENTILE_CONT",
			"PERCENTILE_DISC",
			"POWER",
			"REGR_AVGX",
			"REGR_AVGY",
			"REGR_COUNT",
			"REGR_INTERCEPT",
			"REGR_R2",
			"REGR_SLOPE",
			"REGR_SXX",
			"REGR_SXY",
			"REGR_SYY",
			"SQRT",
			"SUBSTRING",
			"SUM",
			"TRIM",
			"UESCAPE",
			"UPPER",
	};

	static final String[] SQL_EX_KEYWORDS = {
			"CHANGE",
			"MODIFY",
	};
	static final String[] DEFAULT_TYPES = {
			"BOOLEAN",
			"CHAR",
			"VARCHAR",
			"BINARY",
			"VARBINARY",
			"INT",
			"INTEGER",
			"SMALLINT",
			"BIGINT",
			"NUMBER",
			"NUMERIC",
			"DECIMAL",
			"FLOAT",
			"DOUBLE",
			"DATE",
			"TIME",
			"TIMESTAMP",
			"CLOB",
			"BLOB",
	};

	static final char STRUCT_SEPARATOR = '.'; //$NON-NLS-1$

}
