/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktlint;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot31Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot32Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot34Dot2Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot45Dot2Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot46Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot47Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatAdapter;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class KtlintFormatterFunc
implements FormatterFunc.NeedsFile {
    private final Map<String, String> userData;
    private final boolean isScript;
    @NotNull
    private final KtLintCompatAdapter adapter;
    private final boolean useExperimental;
    private final Map<String, Object> editorConfigOverrideMap;

    public KtlintFormatterFunc(String version, boolean isScript, boolean useExperimental, Map<String, String> userData, Map<String, Object> editorConfigOverrideMap) {
        int minorVersion = Integer.parseInt(version.split("\\.")[1]);
        this.adapter = minorVersion >= 47 ? new KtLintCompat0Dot47Dot0Adapter() : (minorVersion >= 46 ? new KtLintCompat0Dot46Dot0Adapter() : (version.equals("0.45.2") ? new KtLintCompat0Dot45Dot2Adapter() : (minorVersion >= 34 ? new KtLintCompat0Dot34Dot2Adapter() : (minorVersion >= 32 ? new KtLintCompat0Dot32Dot0Adapter() : new KtLintCompat0Dot31Dot0Adapter()))));
        this.useExperimental = useExperimental;
        this.editorConfigOverrideMap = editorConfigOverrideMap;
        this.userData = userData;
        this.isScript = isScript;
    }

    @Override
    public String applyWithFile(String unix, File file) throws Exception {
        return this.adapter.format(unix, file.getName(), this.isScript, this.useExperimental, this.userData, this.editorConfigOverrideMap);
    }
}

