/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.java.CleanthatJavaStep;
import com.diffplug.spotless.java.GoogleJavaFormatStep;
import java.util.Arrays;
import java.util.Objects;

public class RemoveUnusedImportsStep {
    static final String NAME = "removeUnusedImports";
    static final String GJF = "google-java-format";
    static final String CLEANTHAT = "cleanthat-javaparser-unnecessaryimport";
    private static final String CLEANTHAT_MUTATOR = "UnnecessaryImport";

    private RemoveUnusedImportsStep() {
    }

    public static final String defaultFormatter() {
        return GJF;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return RemoveUnusedImportsStep.create(GJF, provisioner);
    }

    public static FormatterStep create(String unusedImportRemover, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner");
        if (GJF.equals(unusedImportRemover)) {
            return FormatterStep.createLazy(NAME, () -> new GoogleJavaFormatStep.State(NAME, GoogleJavaFormatStep.defaultVersion(), provisioner), GoogleJavaFormatStep.State::createRemoveUnusedImportsOnly);
        }
        if (CLEANTHAT.equals(unusedImportRemover)) {
            return FormatterStep.createLazy(NAME, () -> new CleanthatJavaStep.JavaRefactorerState(NAME, CleanthatJavaStep.defaultGroupArtifact(), CleanthatJavaStep.defaultVersion(), "99.9", Arrays.asList(CLEANTHAT_MUTATOR), Arrays.asList(new String[0]), false, provisioner), CleanthatJavaStep.JavaRefactorerState::createFormat);
        }
        throw new IllegalArgumentException("Invalid unusedImportRemover: " + unusedImportRemover);
    }
}

