/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LibPreconditions;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.LintState;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.ValuePerStep;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Formatter
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    private LineEnding.Policy lineEndingsPolicy;
    private Charset encoding;
    private List<FormatterStep> steps;
    private static final Logger logger = LoggerFactory.getLogger(Formatter.class);
    public static final File NO_FILE_SENTINEL = new File("NO_FILE_SENTINEL");

    private Formatter(LineEnding.Policy lineEndingsPolicy, Charset encoding, List<FormatterStep> steps) {
        this.lineEndingsPolicy = Objects.requireNonNull(lineEndingsPolicy, "lineEndingsPolicy");
        this.encoding = Objects.requireNonNull(encoding, "encoding");
        this.steps = LibPreconditions.requireElementsNonNull(new ArrayList<FormatterStep>(steps));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.lineEndingsPolicy);
        out.writeObject(this.encoding.name());
        out.writeObject(this.steps);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.lineEndingsPolicy = (LineEnding.Policy)in.readObject();
        this.encoding = Charset.forName((String)in.readObject());
        this.steps = (List)in.readObject();
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new UnsupportedOperationException();
    }

    public LineEnding.Policy getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public List<FormatterStep> getSteps() {
        return this.steps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String computeLineEndings(String unix, File file) {
        Objects.requireNonNull(unix, "unix");
        Objects.requireNonNull(file, "file");
        String ending = this.lineEndingsPolicy.getEndingFor(file);
        if (!ending.equals(LineEnding.UNIX.str())) {
            return unix.replace(LineEnding.UNIX.str(), ending);
        }
        return unix;
    }

    public String compute(String unix, File file) {
        ValuePerStep<Throwable> exceptionPerStep = new ValuePerStep<Throwable>(this);
        String result = this.computeWithLint(unix, file, exceptionPerStep);
        Formatter.legacyErrorBehavior(this, file, exceptionPerStep);
        return result;
    }

    static void legacyErrorBehavior(Formatter formatter, File file, ValuePerStep<Throwable> exceptionPerStep) {
        for (int i = 0; i < formatter.getSteps().size(); ++i) {
            Throwable exception = exceptionPerStep.get(i);
            if (exception == null || exception == LintState.formatStepCausedNoChange()) continue;
            logger.error("Step '{}' found problem in '{}':\n{}", new Object[]{formatter.getSteps().get(i).getName(), file.getName(), exception.getMessage(), exception});
            throw ThrowingEx.asRuntimeRethrowError(exception);
        }
    }

    String computeWithLint(String unix, File file, ValuePerStep<Throwable> exceptionPerStep) {
        Objects.requireNonNull(unix, "unix");
        Objects.requireNonNull(file, "file");
        for (int i = 0; i < this.steps.size(); ++i) {
            Throwable storeForStep;
            FormatterStep step = this.steps.get(i);
            try {
                String formatted = step.format(unix, file);
                if (formatted == null) {
                    storeForStep = LintState.formatStepCausedNoChange();
                } else {
                    String clean = LineEnding.toUnix(formatted);
                    if (clean.equals(unix)) {
                        storeForStep = LintState.formatStepCausedNoChange();
                    } else {
                        storeForStep = null;
                        unix = LineEnding.toUnix(formatted);
                    }
                }
            }
            catch (Throwable e) {
                storeForStep = e;
            }
            exceptionPerStep.set(i, storeForStep);
        }
        return unix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.encoding.hashCode();
        result = 31 * result + this.lineEndingsPolicy.hashCode();
        result = 31 * result + this.steps.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Formatter other = (Formatter)obj;
        return this.encoding.equals(other.encoding) && this.lineEndingsPolicy.equals(other.lineEndingsPolicy) && this.steps.equals(other.steps);
    }

    @Override
    public void close() {
        for (FormatterStep step : this.steps) {
            try {
                step.close();
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
        }
    }

    static void checkNotSentinel(File file) {
        if (file == NO_FILE_SENTINEL) {
            throw new IllegalArgumentException("This step requires the underlying file. If this is a test, use StepHarnessWithFile");
        }
    }

    public static class Builder {
        private LineEnding.Policy lineEndingsPolicy;
        private Charset encoding;
        private List<FormatterStep> steps;

        private Builder() {
        }

        public Builder lineEndingsPolicy(LineEnding.Policy lineEndingsPolicy) {
            this.lineEndingsPolicy = lineEndingsPolicy;
            return this;
        }

        public Builder encoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder steps(List<FormatterStep> steps) {
            this.steps = steps;
            return this;
        }

        public Formatter build() {
            return new Formatter(this.lineEndingsPolicy, this.encoding, this.steps);
        }
    }
}

