/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.gherkin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.gherkin.GherkinUtilsConfig;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class GherkinUtilsStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAVEN_COORDINATE = "io.cucumber:gherkin-utils:";
    private static final String DEFAULT_VERSION = "9.2.0";
    public static final String NAME = "gherkinUtils";
    private final JarState.Promised jarState;
    private final GherkinUtilsConfig gherkinSimpleConfig;

    private GherkinUtilsStep(JarState.Promised jarState, GherkinUtilsConfig gherkinSimpleConfig) {
        this.jarState = jarState;
        this.gherkinSimpleConfig = gherkinSimpleConfig;
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static FormatterStep create(GherkinUtilsConfig gherkinSimpleConfig, String formatterVersion, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.create(NAME, new GherkinUtilsStep(JarState.promise(() -> JarState.from(MAVEN_COORDINATE + formatterVersion, provisioner)), gherkinSimpleConfig), GherkinUtilsStep::equalityState, State::toFormatter);
    }

    private State equalityState() {
        return new State(this.jarState.get(), this.gherkinSimpleConfig);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final GherkinUtilsConfig gherkinSimpleConfig;
        private final JarState jarState;

        State(JarState jarState, GherkinUtilsConfig gherkinSimpleConfig) {
            this.jarState = jarState;
            this.gherkinSimpleConfig = gherkinSimpleConfig;
        }

        FormatterFunc toFormatter() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.gherkin.GherkinUtilsFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(GherkinUtilsConfig.class);
            return (FormatterFunc)constructor.newInstance(this.gherkinSimpleConfig);
        }
    }
}

