/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.go;

import com.diffplug.spotless.ForeignExe;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public class GofmtFormatStep {
    private final String version;
    @Nullable
    private final String pathToExe;

    public static String name() {
        return "gofmt";
    }

    public static String defaultVersion() {
        return "go1.20.0";
    }

    private GofmtFormatStep(String version, String pathToExe) {
        this.version = version;
        this.pathToExe = pathToExe;
    }

    public static GofmtFormatStep withVersion(String version) {
        return new GofmtFormatStep(version, null);
    }

    public GofmtFormatStep withGoExecutable(String pathToExe) {
        return new GofmtFormatStep(this.version, pathToExe);
    }

    public FormatterStep create() {
        return FormatterStep.createLazy(GofmtFormatStep.name(), this::createRountrip, rec$ -> ((RoundtripState)rec$).toEquality(), EqualityState::toFunc);
    }

    private RoundtripState createRountrip() throws IOException, InterruptedException {
        String howToInstall = "gofmt is a part of standard go distribution. If spotless can't discover it automatically, you can point Spotless to the go binary with {@code pathToExe('/path/to/go')}";
        ForeignExe exe = ForeignExe.nameAndVersion("go", this.version).pathToExe(this.pathToExe).versionFlag("version").fixCantFind(howToInstall).fixWrongVersion("You can tell Spotless to use the version you already have with {@code gofmt('{versionFound}')}or you can install the currently specified Go version, {version}.\n" + howToInstall);
        return new RoundtripState(this.version, exe);
    }

    static class RoundtripState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String version;
        final ForeignExe exe;

        RoundtripState(String version, ForeignExe exe) {
            this.version = version;
            this.exe = exe;
        }

        private EqualityState toEquality() {
            return new EqualityState(this.version, this.exe);
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class EqualityState
    implements Serializable {
        private static final long serialVersionUID = -1825662355363926318L;
        final String version;
        final transient ForeignExe exe;

        public EqualityState(String version, ForeignExe goExecutable) {
            this.version = version;
            this.exe = Objects.requireNonNull(goExecutable);
        }

        String format(ProcessRunner runner, String input, File file) throws IOException, InterruptedException {
            ArrayList<String> processArgs = new ArrayList<String>();
            String pathToGoBinary = this.exe.confirmVersionAndGetAbsolutePath();
            Path goBasePath = Path.of(pathToGoBinary, new String[0]).getParent();
            if (goBasePath == null) {
                throw new IllegalStateException("Unable to resolve base path of Go installation directory");
            }
            String pathToGoFmt = goBasePath.resolve("gofmt").toString();
            processArgs.add(pathToGoFmt);
            return runner.exec(input.getBytes(StandardCharsets.UTF_8), processArgs).assertExitZero(StandardCharsets.UTF_8);
        }

        FormatterFunc.Closeable toFunc() {
            ProcessRunner runner = new ProcessRunner();
            return FormatterFunc.Closeable.of(runner, this::format);
        }
    }
}

