/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.Lint;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

class PrettierMissingParserException
extends RuntimeException
implements Lint.Has {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> EXTENSIONS_TO_PLUGINS;
    private final File file;

    public PrettierMissingParserException(@Nonnull File file, Exception cause) {
        super("Prettier could not infer a parser for file '" + String.valueOf(file) + "'. Maybe you need to include a prettier plugin in devDependencies?\n\n" + PrettierMissingParserException.recommendPlugin(file), cause);
        this.file = Objects.requireNonNull(file);
    }

    @Override
    public List<Lint> getLints() {
        return List.of(Lint.atUndefinedLine("no-parser", "Could not infer a parser. Maybe you need to include a prettier plugin in devDependencies? e.g. " + PrettierMissingParserException.recommendPlugin(this.file)));
    }

    private static String recommendPlugin(File file) {
        String pluginName = PrettierMissingParserException.guessPlugin(file);
        return "A good candidate for file '" + String.valueOf(file) + "' is '" + pluginName + "\nSee if you can find it on <https://prettier.io/docs/en/plugins.html#official-plugins>\nor search on npmjs.com for a plugin matching that name: " + String.format("<https://www.npmjs.com/search?ranking=popularity&q=%s>", pluginName) + "\n\nFor instructions on how to include plugins for prettier in spotless see our documentation:\n- for Gradle <https://github.com/diffplug/spotless/tree/main/plugin-gradle#prettier-plugins>\n- for Maven <https://github.com/diffplug/spotless/tree/main/plugin-maven#prettier-plugins>";
    }

    private static String guessPlugin(File file) {
        return EXTENSIONS_TO_PLUGINS.entrySet().stream().filter(entry -> file.getName().endsWith((String)entry.getKey())).findFirst().map(entry -> (String)entry.getValue()).orElse("prettier-plugin-" + PrettierMissingParserException.extension(file));
    }

    public String fileType() {
        return PrettierMissingParserException.extension(this.file);
    }

    private static String extension(File file) {
        return file.getName().substring(file.getName().lastIndexOf(46) + 1);
    }

    static {
        HashMap<String, String> plugins = new HashMap<String, String>();
        plugins.put(".php", "@prettier/plugin-php");
        plugins.put(".pug", "@prettier/plugin-pug");
        plugins.put(".rb", "@prettier/plugin-ruby");
        plugins.put(".xml", "@prettier/plugin-xml");
        plugins.put(".trigger", "prettier-plugin-apex");
        plugins.put(".cls", "prettier-plugin-apex");
        plugins.put(".html.erb", "prettier-plugin-erb");
        Arrays.asList(".glsl", ".fp", ".frag", ".frg", ".fs", ".fsh", ".fshader", ".geo", ".geom", ".glslf", ".glslv", ".gs", ".gshader", ".rchit", ".rmiss", ".shader", ".tesc", ".tese", ".vert", ".vrx", ".vsh", ".vshader").forEach(ext -> plugins.put((String)ext, "prettier-plugin-glsl"));
        Arrays.asList(".go.html", ".gohtml", ".gotmpl", ".go.tmpl", ".tmpl", ".tpl", ".html.tmpl", ".html.tpl").forEach(ext -> plugins.put((String)ext, "prettier-plugin-go-template"));
        plugins.put(".kt", "kotlin");
        plugins.put(".mo", "motoko");
        Arrays.asList(".nginx", ".nginxconf").forEach(ext -> plugins.put((String)ext, "prettier-plugin-nginx"));
        plugins.put(".sol", "prettier-plugin-solidity");
        EXTENSIONS_TO_PLUGINS = Collections.unmodifiableMap(plugins);
    }
}

