/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.biome;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiomeSettings {
    private static final Logger logger = LoggerFactory.getLogger(BiomeSettings.class);
    private static final String CONFIG_NAME = "biome.json";
    private static final String DEFAULT_VERSION = "1.2.0";
    private static final String DOWNLOAD_FILE_PATTERN = "biome-%s-%s-%s";
    private static final String SHORT_NAME = "biome";
    private static final String URL_PATTERN_1X = "https://github.com/biomejs/biome/releases/download/cli%%2Fv%s/biome-%s";
    private static final String URL_PATTERN_2X = "https://github.com/biomejs/biome/releases/download/%%40biomejs%%2Fbiome%%40%s/biome-%s";

    private BiomeSettings() {
    }

    public static String configName() {
        return CONFIG_NAME;
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static String getDownloadFilePattern() {
        return DOWNLOAD_FILE_PATTERN;
    }

    public static String getUrlPattern(String version) {
        if (version != null && version.startsWith("1.")) {
            return URL_PATTERN_1X;
        }
        return URL_PATTERN_2X;
    }

    public static String shortName() {
        return SHORT_NAME;
    }

    public static boolean versionHigherThanOrEqualTo(String version, int major, int minor, int patch) {
        try {
            String[] versionParts = version.split("\\.");
            if (versionParts.length < 3) {
                return false;
            }
            int actualMajor = Integer.parseInt(versionParts[0]);
            int actualMinor = Integer.parseInt(versionParts[1]);
            int actualPatch = Integer.parseInt(versionParts[2]);
            if (actualMajor > major) {
                return true;
            }
            if (actualMajor == major && actualMinor > minor) {
                return true;
            }
            if (actualMajor == major && actualMinor == minor && actualPatch > patch) {
                return true;
            }
            return actualMajor == major && actualMinor == minor && actualPatch == patch;
        }
        catch (Exception e) {
            logger.warn("Failed to parse biome version string '{}'. Expected format is 'major.minor.patch'.", (Object)version, (Object)e);
            return false;
        }
    }
}

