/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.NpmResourceHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class NodeServerLayout {
    private static final Pattern PACKAGE_JSON_NAME_PATTERN = Pattern.compile("\"name\"\\s*:\\s*\"([^\"]+)\"");
    static final String NODE_MODULES = "node_modules";
    private final File nodeModulesDir;
    private final File packageJsonFile;
    private final File packageLockJsonFile;
    private final File serveJsFile;
    private final File npmrcFile;

    NodeServerLayout(File buildDir, String packageJsonContent, String serveJsContent) {
        this.nodeModulesDir = new File(buildDir, NodeServerLayout.nodeModulesDirName(packageJsonContent, serveJsContent));
        this.packageJsonFile = new File(this.nodeModulesDir, "package.json");
        this.packageLockJsonFile = new File(this.nodeModulesDir, "package-lock.json");
        this.serveJsFile = new File(this.nodeModulesDir, "serve.js");
        this.npmrcFile = new File(this.nodeModulesDir, ".npmrc");
    }

    private static String nodeModulesDirName(String packageJsonContent, String serveJsContent) {
        String md5Hash = NpmResourceHelper.md5(packageJsonContent, serveJsContent);
        Matcher matcher = PACKAGE_JSON_NAME_PATTERN.matcher(packageJsonContent);
        if (!matcher.find()) {
            throw new IllegalArgumentException("package.json must contain a name property");
        }
        String packageName = matcher.group(1);
        return "%s-node-modules-%s".formatted(packageName, md5Hash);
    }

    File nodeModulesDir() {
        return this.nodeModulesDir;
    }

    File packageJsonFile() {
        return this.packageJsonFile;
    }

    File serveJsFile() {
        return this.serveJsFile;
    }

    public File npmrcFile() {
        return this.npmrcFile;
    }

    public boolean isLayoutPrepared() {
        if (!this.nodeModulesDir().isDirectory()) {
            return false;
        }
        if (!this.packageJsonFile().isFile()) {
            return false;
        }
        if (!this.packageLockJsonFile.isFile()) {
            return false;
        }
        return this.serveJsFile().isFile();
    }

    public boolean isNodeModulesPrepared() {
        Path nodeModulesInstallDirPath = new File(this.nodeModulesDir(), NODE_MODULES).toPath();
        if (!Files.isDirectory(nodeModulesInstallDirPath, new LinkOption[0])) {
            return false;
        }
        return ThrowingEx.get(() -> {
            try (Stream<Path> entries = Files.list(nodeModulesInstallDirPath);){
                Boolean bl = entries.findFirst().isPresent();
                return bl;
            }
        });
    }

    public String toString() {
        return "NodeServerLayout[nodeModulesDir=%s, packageJsonFile=%s, serveJsFile=%s, npmrcFile=%s]".formatted(this.nodeModulesDir, this.packageJsonFile, this.serveJsFile, this.npmrcFile);
    }
}

