/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.npm;

import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.npm.NpmPathResolver;
import java.io.File;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractNpmFormatterStepFactory
implements FormatterStepFactory {
    public static final String SPOTLESS_NPM_INSTALL_CACHE_DEFAULT_NAME = "spotless-npm-install-cache";
    @Parameter
    private String npmExecutable;
    @Parameter
    private String nodeExecutable;
    @Parameter
    private String npmrc;
    @Parameter
    private String npmInstallCache;

    protected File npm(FormatterStepConfig stepConfig) {
        return this.npmExecutable != null ? stepConfig.getFileLocator().locateFile(this.npmExecutable) : null;
    }

    protected File node(FormatterStepConfig stepConfig) {
        return this.nodeExecutable != null ? stepConfig.getFileLocator().locateFile(this.nodeExecutable) : null;
    }

    protected File npmrc(FormatterStepConfig stepConfig) {
        return this.npmrc != null ? stepConfig.getFileLocator().locateFile(this.npmrc) : null;
    }

    protected File buildDir(FormatterStepConfig stepConfig) {
        return stepConfig.getFileLocator().getBuildDir();
    }

    protected File cacheDir(FormatterStepConfig stepConfig) {
        if (this.npmInstallCache == null) {
            return null;
        }
        if ("true".equals(this.npmInstallCache.toLowerCase(Locale.ROOT))) {
            return new File(this.buildDir(stepConfig), SPOTLESS_NPM_INSTALL_CACHE_DEFAULT_NAME);
        }
        return Path.of(this.npmInstallCache, new String[0]).toFile();
    }

    protected File baseDir(FormatterStepConfig stepConfig) {
        return stepConfig.getFileLocator().getBaseDir();
    }

    protected NpmPathResolver npmPathResolver(FormatterStepConfig stepConfig) {
        return new NpmPathResolver(this.npm(stepConfig), this.node(stepConfig), this.npmrc(stepConfig), List.of(this.baseDir(stepConfig)));
    }

    protected boolean moreThanOneNonNull(Object ... objects) {
        return Arrays.stream(objects).filter(Objects::nonNull).filter(o -> !(o instanceof String) || !((String)o).isEmpty()).count() > 1L;
    }

    protected Map<String, String> propertiesAsMap(Properties devDependencyProperties) {
        return devDependencyProperties.stringPropertyNames().stream().map(name -> new AbstractMap.SimpleEntry<String, String>((String)name, devDependencyProperties.getProperty((String)name))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

