/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class SpotlessTaskImpl
extends SpotlessTask {
    @Override
    @Internal
    abstract DirectoryProperty getProjectDir();

    void init(Provider<SpotlessTaskService> service) {
        this.getTaskService().set(service);
        this.getProjectDir().set(this.getProject().getProjectDir());
    }

    @Inject
    protected abstract FileSystemOperations getFs();

    @TaskAction
    public void performAction(InputChanges inputs) throws Exception {
        ((SpotlessTaskService)this.getTaskService().get()).registerSourceAlreadyRan(this);
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> target'");
        }
        if (!inputs.isIncremental()) {
            this.getLogger().info("Not incremental: removing prior outputs");
            this.getFs().delete(d -> d.delete(new Object[]{this.outputDirectory}));
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        try (Formatter formatter = this.buildFormatter();){
            for (FileChange fileChange : inputs.getFileChanges(this.target)) {
                File input = fileChange.getFile();
                if (fileChange.getChangeType() == ChangeType.REMOVED) {
                    this.deletePreviousResult(input);
                    continue;
                }
                if (!input.isFile()) continue;
                this.processInputFile(formatter, input);
            }
        }
    }

    private void processInputFile(Formatter formatter, File input) throws IOException {
        File output = this.getOutputFile(input);
        this.getLogger().debug("Applying format to " + input + " and writing to " + output);
        PaddedCell.DirtyState dirtyState = this.getRatchet() != null && this.getRatchet().isClean(((Directory)this.getProjectDir().get()).getAsFile(), this.getRootTreeSha(), input) ? PaddedCell.isClean() : PaddedCell.calculateDirtyState((Formatter)formatter, (File)input);
        if (dirtyState.isClean()) {
            Files.deleteIfExists(output.toPath());
        } else if (dirtyState.didNotConverge()) {
            this.getLogger().warn("Skipping '" + input + "' because it does not converge.  Run {@code spotlessDiagnose} to understand why");
        } else {
            Path parentDir = output.toPath().getParent();
            if (parentDir == null) {
                throw new IllegalStateException("Every file has a parent folder.");
            }
            Files.createDirectories(parentDir, new FileAttribute[0]);
            Files.copy(input.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            dirtyState.writeCanonicalTo(output);
        }
    }

    private void deletePreviousResult(File input) throws IOException {
        File output = this.getOutputFile(input);
        if (output.isDirectory()) {
            this.getFs().delete(d -> d.delete(new Object[]{output}));
        } else {
            Files.deleteIfExists(output.toPath());
        }
    }

    private File getOutputFile(File input) {
        File projectDir = ((Directory)this.getProjectDir().get()).getAsFile();
        String outputFileName = FormatExtension.relativize(projectDir, input);
        if (outputFileName == null) {
            throw new IllegalArgumentException(StringPrinter.buildString(printer -> {
                printer.println("Spotless error! All target files must be within the project dir.");
                printer.println("  project dir: " + projectDir.getAbsolutePath());
                printer.println("       target: " + input.getAbsolutePath());
            }));
        }
        return new File(this.outputDirectory, outputFileName);
    }
}

