/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.executor;

import dorkbox.executor.NullOutputStream;
import dorkbox.executor.ProcessStreamProxy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ShellExecutor {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final boolean isWindows;
    static final boolean isMacOsX;
    private static String defaultShell;
    private final PrintStream outputStream;
    private final PrintStream outputErrorStream;
    private final InputStream inputStream;
    protected List<String> arguments = new ArrayList<String>();
    private Map<String, String> environment = null;
    private String workingDirectory = null;
    private String executableName = null;
    private String executableDirectory = null;
    private Process process = null;
    private ProcessStreamProxy writeToProcess_input = null;
    private ProcessStreamProxy readFromProcess_output = null;
    private ProcessStreamProxy readFromProcess_error = null;
    private boolean createReadWriterThreads = false;
    private boolean executeAsShell;
    private String pipeToNullString = "";
    private ByteArrayOutputStream byteArrayOutputStream;
    private List<String> fullCommand;

    public static String getVersion() {
        return "1.0";
    }

    public static boolean run(String executableName, String ... args) {
        ShellExecutor shell = new ShellExecutor();
        shell.setExecutable(executableName);
        shell.addArguments(args);
        return shell.start() == 0;
    }

    public static boolean runShell(String executableName, String ... args) {
        ShellExecutor shell = new ShellExecutor();
        shell.setExecutable(executableName);
        shell.addArguments(args);
        shell.executeAsShellCommand();
        return shell.start() == 0;
    }

    public ShellExecutor() {
        this.byteArrayOutputStream = new ByteArrayOutputStream(8196);
        PrintStream outputStream = new PrintStream(this.byteArrayOutputStream);
        this.inputStream = null;
        this.outputStream = outputStream;
        this.outputErrorStream = outputStream;
    }

    public ShellExecutor(PrintStream out) {
        this.inputStream = null;
        this.outputStream = out;
        this.outputErrorStream = out;
    }

    public ShellExecutor(InputStream in, PrintStream out) {
        this.inputStream = in;
        this.outputStream = out;
        this.outputErrorStream = out;
    }

    public ShellExecutor(InputStream in, PrintStream out, PrintStream err) {
        this.inputStream = in;
        this.outputStream = out;
        this.outputErrorStream = err;
    }

    public final ShellExecutor createReadWriterThreads() {
        this.createReadWriterThreads = true;
        return this;
    }

    public final ShellExecutor setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = new File(workingDirectory).getAbsolutePath();
        return this;
    }

    public final ShellExecutor setEnvironment(Map<String, String> environment) {
        this.environment = environment;
        return this;
    }

    public final ShellExecutor addArgument(String argument) {
        this.arguments.add(argument);
        return this;
    }

    public final ShellExecutor addArguments(String ... args) {
        for (String path : args) {
            this.arguments.add(path);
        }
        return this;
    }

    public final ShellExecutor addArguments(List<String> paths) {
        this.arguments.addAll(paths);
        return this;
    }

    public final ShellExecutor setExecutable(String executableName) {
        this.executableName = executableName;
        return this;
    }

    public ShellExecutor setExecutableDirectory(String executableDirectory) {
        this.executableDirectory = new File(executableDirectory).getAbsolutePath();
        return this;
    }

    public ShellExecutor executeAsShellCommand() {
        this.executeAsShell = true;
        return this;
    }

    public ShellExecutor pipeOutputToNull() throws IllegalArgumentException {
        if (this.outputStream != null || this.outputErrorStream != null) {
            throw new IllegalArgumentException("Cannot pipe shell command to 'null' if an output stream is specified");
        }
        this.pipeToNullString = isWindows ? ">NUL" : ">/dev/null 2>&1";
        return this;
    }

    public String getCommand() {
        StringBuilder execCommand = new StringBuilder();
        Iterator<String> iterator = this.fullCommand.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            execCommand.append(s);
            if (!iterator.hasNext()) continue;
            execCommand.append(" ");
        }
        return execCommand.toString();
    }

    public int start() {
        return this.start(true);
    }

    public int start(boolean waitForProcesses) {
        boolean pipeToNull;
        block55: {
            this.fullCommand = new ArrayList<String>();
            if (this.executeAsShell) {
                if (isWindows) {
                    this.fullCommand.add("cmd");
                    this.fullCommand.add("/c");
                } else {
                    if (defaultShell == null) {
                        String[] shells;
                        for (String string : shells = new String[]{"/bin/bash", "/usr/bin/bash", "/bin/pfbash", "/usr/bin/pfbash", "/bin/csh", "/usr/bin/csh", "/bin/pfcsh", "/usr/bin/pfcsh", "/bin/jsh", "/usr/bin/jsh", "/bin/ksh", "/usr/bin/ksh", "/bin/pfksh", "/usr/bin/pfksh", "/bin/ksh93", "/usr/bin/ksh93", "/bin/pfksh93", "/usr/bin/pfksh93", "/bin/pfsh", "/usr/bin/pfsh", "/bin/tcsh", "/usr/bin/tcsh", "/bin/pftcsh", "/usr/bin/pftcsh", "/usr/xpg4/bin/sh", "/usr/xp4/bin/pfsh", "/bin/zsh", "/usr/bin/zsh", "/bin/pfzsh", "/usr/bin/pfzsh", "/bin/sh", "/usr/bin/sh"}) {
                            if (!new File(string).canExecute()) continue;
                            defaultShell = string;
                            break;
                        }
                    }
                    if (defaultShell == null) {
                        throw new RuntimeException("Unable to determine the default shell for the linux/unix environment.");
                    }
                    this.fullCommand.add(defaultShell);
                    this.fullCommand.add("-c");
                }
            } else {
                if (this.workingDirectory != null && !this.workingDirectory.endsWith(File.separator)) {
                    this.workingDirectory = this.workingDirectory + File.separator;
                }
                if (this.executableDirectory != null) {
                    if (!this.executableDirectory.endsWith(File.separator)) {
                        this.executableDirectory = this.executableDirectory + File.separator;
                    }
                    this.fullCommand.add(0, this.executableDirectory + this.executableName);
                } else {
                    this.fullCommand.add(this.executableName);
                }
            }
            boolean bl = pipeToNull = !this.pipeToNullString.isEmpty();
            if (this.executeAsShell && !isWindows) {
                StringBuilder stringBuilder = new StringBuilder(1024);
                stringBuilder.append(this.executableName).append(" ");
                for (String arg : this.arguments) {
                    stringBuilder.append(arg).append(" ");
                }
                if (!this.arguments.isEmpty()) {
                    if (pipeToNull) {
                        stringBuilder.append(this.pipeToNullString);
                    } else {
                        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                    }
                }
                this.fullCommand.add(stringBuilder.toString());
            } else {
                for (String arg : this.arguments) {
                    if (arg.contains(" ")) {
                        String[] split;
                        for (String s : split = arg.split(" ")) {
                            if ((s = s.trim()).isEmpty()) continue;
                            this.fullCommand.add(s);
                        }
                        continue;
                    }
                    this.fullCommand.add(arg);
                }
                if (pipeToNull) {
                    this.fullCommand.add(this.pipeToNullString);
                }
            }
            ProcessBuilder processBuilder = new ProcessBuilder(this.fullCommand);
            if (this.workingDirectory != null) {
                processBuilder.directory(new File(this.workingDirectory));
            }
            Map<String, String> environment = processBuilder.environment();
            if (isMacOsX) {
                environment.put("SOFTWARE", "");
            }
            environment.put("LANG", "C");
            if (this.environment != null) {
                for (Map.Entry<String, String> entry : this.environment.entrySet()) {
                    environment.put(entry.getKey(), entry.getValue());
                }
            }
            if (pipeToNull || this.outputErrorStream == null) {
                processBuilder.redirectErrorStream(true);
            }
            try {
                this.process = processBuilder.start();
            }
            catch (Exception ex) {
                if (this.outputErrorStream != null) {
                    this.outputErrorStream.println("There was a problem executing the program.  Details:");
                    ex.printStackTrace(this.outputErrorStream);
                } else {
                    System.err.println("There was a problem executing the program.  Details:");
                    ex.printStackTrace();
                }
                if (this.process == null) break block55;
                try {
                    this.process.destroy();
                    this.process = null;
                }
                catch (Exception exception) {
                    if (this.outputErrorStream != null) {
                        this.outputErrorStream.println("Error destroying process:");
                    } else {
                        System.err.println("Error destroying process:");
                    }
                    exception.printStackTrace(this.outputErrorStream);
                }
            }
        }
        if (this.process != null) {
            int n;
            if (this.outputErrorStream == null && this.outputStream == null) {
                if (!pipeToNull) {
                    NullOutputStream nullOutputStream = new NullOutputStream();
                    this.readFromProcess_output = new ProcessStreamProxy("Process Reader: " + this.executableName, this.process.getInputStream(), nullOutputStream);
                }
            } else {
                this.readFromProcess_output = new ProcessStreamProxy("Process Reader: " + this.executableName, this.process.getInputStream(), this.outputStream);
                if (this.outputErrorStream != this.outputStream) {
                    this.readFromProcess_error = new ProcessStreamProxy("Process Reader: " + this.executableName, this.process.getErrorStream(), this.outputErrorStream);
                }
            }
            if (this.inputStream != null) {
                this.writeToProcess_input = new ProcessStreamProxy("Process Writer: " + this.executableName, this.inputStream, this.process.getOutputStream());
            }
            Thread hook = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ShellExecutor.this.writeToProcess_input != null) {
                            ShellExecutor.this.writeToProcess_input.close();
                            if (ShellExecutor.this.createReadWriterThreads) {
                                ShellExecutor.this.writeToProcess_input.join();
                            }
                        }
                        ShellExecutor.this.readFromProcess_output.close();
                        if (ShellExecutor.this.createReadWriterThreads) {
                            ShellExecutor.this.readFromProcess_output.join();
                        }
                        if (ShellExecutor.this.readFromProcess_error != null) {
                            ShellExecutor.this.readFromProcess_error.close();
                            if (ShellExecutor.this.createReadWriterThreads) {
                                ShellExecutor.this.readFromProcess_error.join();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    ShellExecutor.this.process.destroy();
                }
            });
            hook.setName("ShellExecutor Shutdown Hook for " + this.executableName);
            try {
                Runtime.getRuntime().addShutdownHook(hook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (this.writeToProcess_input != null) {
                if (this.createReadWriterThreads) {
                    this.writeToProcess_input.start();
                } else {
                    this.writeToProcess_input.run();
                }
            }
            if (this.createReadWriterThreads) {
                this.readFromProcess_output.start();
            } else {
                this.readFromProcess_output.run();
            }
            if (this.readFromProcess_error != null) {
                if (this.createReadWriterThreads) {
                    this.readFromProcess_error.start();
                } else {
                    this.readFromProcess_error.run();
                }
            }
            boolean bl = false;
            if (waitForProcesses) {
                try {
                    this.process.waitFor();
                    n = this.process.exitValue();
                    hook.run();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return n;
        }
        return 1;
    }

    public String getOutput() {
        if (this.byteArrayOutputStream != null) {
            return ShellExecutor.getOutput(this.byteArrayOutputStream);
        }
        return null;
    }

    public String getOutputLineBuffered() {
        if (this.byteArrayOutputStream != null) {
            return ShellExecutor.getOutputLineBuffered(this.byteArrayOutputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOutput(ByteArrayOutputStream byteArrayOutputStream) {
        String s;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        synchronized (byteArrayOutputStream2) {
            s = byteArrayOutputStream.toString();
            byteArrayOutputStream.reset();
        }
        int endIndex = s.lastIndexOf(LINE_SEPARATOR);
        if (endIndex > -1) {
            return s.substring(0, endIndex);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOutputLineBuffered(ByteArrayOutputStream byteArrayOutputStream) {
        String s;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        synchronized (byteArrayOutputStream2) {
            try {
                byteArrayOutputStream.wait();
            }
            catch (InterruptedException ignored) {
                return null;
            }
            s = byteArrayOutputStream.toString();
            byteArrayOutputStream.reset();
        }
        return s;
    }

    static {
        String osName = System.getProperty("os.name");
        isWindows = osName.startsWith("windows");
        isMacOsX = osName.startsWith("mac") || osName.startsWith("darwin");
        defaultShell = null;
    }
}

